/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.scope;

import java.io.IOException;
import org.basex.io.in.NewlineInput;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ExprInfo;
import org.basex.query.func.inspect.Inspect;
import org.basex.query.scope.Scope;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.TokenList;

public abstract class StaticScope
extends ExprInfo
implements Scope {
    public final StaticContext sc;
    public final VarScope vs;
    public final InputInfo info;
    public Expr expr;
    protected boolean compiled;
    private final byte[] doc;

    StaticScope(StaticContext sc, VarScope vs, String doc, InputInfo info) {
        this.sc = sc;
        this.vs = vs;
        this.doc = doc != null && !doc.isEmpty() ? Token.token(doc) : null;
        this.info = info;
    }

    @Override
    public final boolean compiled() {
        return this.compiled;
    }

    public final TokenObjMap<TokenList> doc() {
        if (this.doc == null) {
            return null;
        }
        TokenObjMap<TokenList> map = new TokenObjMap<TokenList>();
        TokenBuilder key = new TokenBuilder();
        TokenBuilder value = new TokenBuilder();
        Runnable add = () -> {
            byte[] k = key.isEmpty() ? Inspect.DOC_TAGS[0] : key.next();
            map.computeIfAbsent(k, TokenList::new).add(value.trim().next());
        };
        TokenBuilder input = new TokenBuilder();
        try (NewlineInput nli = new NewlineInput(this.doc);){
            while (nli.readLine(input)) {
                String line = input.toString().replaceAll("^\\s*:? *", "");
                if (line.matches("^@\\w+\\s+.*")) {
                    add.run();
                    key.add(line.replaceAll("^@|\\s+.*", ""));
                    line = line.replaceAll("^@\\w+\\s+", "");
                }
                value.add(line).add(10);
            }
        }
        catch (IOException ex) {
            throw Util.notExpected(ex, new Object[0]);
        }
        add.run();
        return map;
    }
}

