/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.scope;

import java.util.IdentityHashMap;
import org.basex.core.locks.Locks;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.func.StaticFunc;
import org.basex.query.func.StaticFuncCall;
import org.basex.query.iter.Iter;
import org.basex.query.scope.AModule;
import org.basex.query.scope.Scope;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.Value;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.StaticVar;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.hash.TokenSet;

public final class MainModule
extends AModule {
    private final SeqType declType;

    public static MainModule get(VarScope vs, Expr expr, SeqType declType, String doc, InputInfo ii) {
        return new MainModule(vs, expr, declType, doc, ii, null, null, null);
    }

    public static MainModule get(StaticFunc sf, Expr[] args) throws QueryException {
        StaticFuncCall expr = new StaticFuncCall(sf.name, args, sf.sc, sf.info).init(sf);
        return new MainModule(new VarScope(sf.sc), expr, null, null, null, null, null, null);
    }

    public MainModule(VarScope vs, Expr expr, SeqType declType, String doc, InputInfo info, TokenObjMap<StaticFunc> funcs, TokenObjMap<StaticVar> vars, TokenSet imports) {
        super(vs.sc, vs, doc, info, funcs, vars, imports);
        this.expr = expr;
        this.declType = declType;
    }

    @Override
    public void comp(CompileContext cc) throws QueryException {
        if (this.compiled) {
            return;
        }
        this.compiled = true;
        cc.pushScope(this.vs);
        try {
            this.expr = this.expr.compile(cc);
        }
        finally {
            cc.removeScope(this);
        }
    }

    public Iter iter(final QueryContext qc) throws QueryException {
        if (this.declType != null) {
            return this.value(qc).iter();
        }
        final int fp = this.vs.enter(qc);
        final Iter iter = this.expr.iter(qc);
        return new Iter(){
            boolean more = true;

            @Override
            public Item next() throws QueryException {
                if (this.more) {
                    Item item = iter.next();
                    if (item != null) {
                        return item;
                    }
                    this.more = false;
                    VarScope.exit(fp, qc);
                }
                return null;
            }

            @Override
            public long size() throws QueryException {
                return iter.size();
            }

            @Override
            public Item get(long i) throws QueryException {
                return iter.get(i);
            }

            @Override
            public Value value(QueryContext q, Expr ex) throws QueryException {
                return iter.value(qc, ex);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value value(QueryContext qc) throws QueryException {
        int fp = this.vs.enter(qc);
        try {
            Value value = this.expr.value(qc);
            if (this.declType != null) {
                this.declType.treat(value, null, qc, this.info);
            }
            Value value2 = value;
            return value2;
        }
        finally {
            VarScope.exit(fp, qc);
        }
    }

    public boolean databases(Locks locks, QueryContext qc) {
        return this.expr.accept(new LockVisitor(locks, qc));
    }

    @Override
    public boolean visit(ASTVisitor visitor) {
        return this.expr.accept(visitor);
    }

    @Override
    public void plan(QueryPlan plan) {
        this.expr.plan(plan);
    }

    @Override
    public void plan(QueryString qs) {
        qs.token(this.expr);
    }

    private static final class LockVisitor
    extends ASTVisitor {
        private final IdentityHashMap<Scope, Object> funcs = new IdentityHashMap();
        private final Locks locks;
        private final boolean updating;
        private int level;

        private LockVisitor(Locks locks, QueryContext qc) {
            this.locks = locks;
            this.updating = qc.updating;
            this.level = qc.ctxItem == null ? 0 : 1;
        }

        @Override
        public boolean lock(String lock, boolean update) {
            if (lock == null) {
                return false;
            }
            if (this.level == 0 || lock != "internal:context") {
                (this.updating || update ? this.locks.writes : this.locks.reads).add(lock);
            }
            return true;
        }

        @Override
        public void enterFocus() {
            ++this.level;
        }

        @Override
        public void exitFocus() {
            --this.level;
        }

        @Override
        public boolean staticVar(StaticVar var) {
            if (this.funcs.containsKey(var)) {
                return true;
            }
            this.funcs.put(var, null);
            return var.visit(this);
        }

        @Override
        public boolean staticFuncCall(StaticFuncCall call) {
            return this.func(call.func());
        }

        @Override
        public boolean inlineFunc(Scope scope) {
            this.enterFocus();
            boolean ac = scope.visit(this);
            this.exitFocus();
            return ac;
        }

        @Override
        public boolean funcItem(FuncItem func) {
            return this.func(func);
        }

        private boolean func(Scope scope) {
            if (this.funcs.containsKey(scope)) {
                return true;
            }
            this.funcs.put(scope, null);
            this.enterFocus();
            boolean ac = scope.visit(this);
            this.exitFocus();
            return ac;
        }
    }
}

