/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.util;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arith;
import org.basex.query.expr.Calc;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.SingletonSeq;
import org.basex.query.value.type.Occ;

public final class UtilReplicate
extends StandardFunc {
    @Override
    public Value value(QueryContext qc) throws QueryException {
        boolean single;
        Expr expr = this.exprs[0];
        long count = this.toLong(this.exprs[1], qc);
        boolean bl = single = this.exprs.length < 3 || !this.toBoolean(this.exprs[2], qc);
        if (count <= 0L) {
            return Empty.VALUE;
        }
        if (count == 1L) {
            return expr.value(qc);
        }
        if (single) {
            return SingletonSeq.get(expr.value(qc), count);
        }
        ValueBuilder vb = new ValueBuilder(qc);
        for (long c = 0L; c < count; ++c) {
            vb.add(expr.value(qc));
        }
        return vb.value(this);
    }

    @Override
    public Iter iter(final QueryContext qc) throws QueryException {
        boolean single;
        final Expr expr = this.exprs[0];
        final long count = this.toLong(this.exprs[1], qc);
        boolean bl = single = this.exprs.length < 3 || !this.toBoolean(this.exprs[2], qc);
        if (count <= 0L) {
            return Empty.ITER;
        }
        if (count == 1L) {
            return expr.iter(qc);
        }
        if (single) {
            return SingletonSeq.get(expr.value(qc), count).iter();
        }
        return new Iter(){
            long c;
            Iter iter;
            {
                this.c = count;
            }

            @Override
            public Item next() throws QueryException {
                while (true) {
                    Item item;
                    if (this.iter == null) {
                        if (this.c-- == 0L) {
                            return null;
                        }
                        this.iter = expr.iter(qc);
                    }
                    if ((item = this.iter.next()) != null) {
                        return item;
                    }
                    this.iter = null;
                }
            }
        };
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Expr expr = this.exprs[0];
        Expr count = this.exprs[1];
        boolean single = this.singleEval();
        if (Function._UTIL_REPLICATE.is(expr) && single == ((UtilReplicate)expr).singleEval()) {
            ExprList args = (ExprList)((Object)new ExprList(2L).add(expr.arg(0)));
            args.add(new Arith(this.info, count, expr.arg(1), Calc.MULT).optimize(cc));
            if (!single) {
                args.add(Bln.TRUE);
            }
            return cc.function(Function._UTIL_REPLICATE, this.info, (Expr[])args.finish());
        }
        long sz = -1L;
        long c = -1L;
        if (count instanceof Value) {
            c = this.toLong(count, cc.qc);
            if (c <= 0L) {
                return Empty.VALUE;
            }
            if (c == 1L) {
                return expr;
            }
            sz = expr.size();
            if (sz != -1L) {
                sz *= c;
            }
        }
        if (expr == Empty.VALUE || sz == 0L && single) {
            return expr;
        }
        this.exprType.assign(expr.seqType().union(c > 0L ? Occ.ONE_OR_MORE : Occ.ZERO_OR_MORE), sz);
        this.data(expr.data());
        return this;
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Expr expr = this.exprs[0];
        if (mode == CompileContext.Simplify.DISTINCT) {
            long count = this.exprs[1] instanceof Int ? ((Int)this.exprs[1]).itr() : -1L;
            boolean single = this.singleEval();
            if (count > 0L && (single || !expr.has(Flag.NDT))) {
                return cc.replaceWith(this, expr);
            }
        } else if (mode == CompileContext.Simplify.STRING || mode == CompileContext.Simplify.NUMBER) {
            this.exprs[0] = expr.simplifyFor(mode, cc);
        }
        return super.simplifyFor(mode, cc);
    }

    public boolean singleEval() {
        return this.exprs.length < 3 || this.exprs[2] == Bln.FALSE;
    }

    public boolean once() {
        return this.singleEval() && this.exprs[1] instanceof Int;
    }
}

