/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.util;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.List;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;

public final class UtilLast
extends StandardFunc {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Item item;
        Iter iter = this.exprs[0].iter(qc);
        long size = iter.size();
        if (size >= 0L) {
            return size > 0L ? iter.get(size - 1L) : Empty.VALUE;
        }
        Item last = null;
        while ((item = qc.next(iter)) != null) {
            last = item;
        }
        return last == null ? Empty.VALUE : last;
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Expr expr = this.exprs[0];
        SeqType st = expr.seqType();
        if (st.zeroOrOne()) {
            return expr;
        }
        long size = expr.size();
        if (Function.TAIL.is(expr) && size > 1L) {
            return cc.function(Function._UTIL_LAST, this.info, expr.args());
        }
        if (Function._UTIL_INIT.is(expr) && size > 0L) {
            return cc.function(Function._UTIL_ITEM, this.info, expr.arg(0), Int.get(size));
        }
        if (Function.REVERSE.is(expr)) {
            return cc.function(Function.HEAD, this.info, expr.args());
        }
        if (Function._UTIL_REPLICATE.is(expr) && expr.arg(1) instanceof Int) {
            return cc.function(Function._UTIL_LAST, this.info, expr.arg(0));
        }
        if (expr instanceof List) {
            Expr[] args = expr.args();
            Expr last = args[args.length - 1];
            SeqType stl = last.seqType();
            if (stl.one()) {
                return last;
            }
            if (stl.oneOrMore()) {
                return cc.function(Function._UTIL_LAST, this.info, last);
            }
        }
        this.exprType.assign(st.with(st.oneOrMore() ? Occ.EXACTLY_ONE : Occ.ZERO_OR_ONE));
        this.data(expr.data());
        return this;
    }
}

