/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.sql;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.func.sql.SqlExecute;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.AtomType;
import org.basex.util.Token;
import org.basex.util.Util;

public final class SqlExecutePrepared
extends SqlExecute {
    private static final QNm Q_PARAMETERS = new QNm(QueryText.SQL_PREFIX, "parameters", QueryText.SQL_URI);
    private static final QNm Q_PARAMETER = new QNm(QueryText.SQL_PREFIX, "parameter", QueryText.SQL_URI);
    private static final byte[] INT = AtomType.INT.qname().local();
    private static final byte[] STRING = AtomType.STRING.qname().local();
    private static final byte[] BOOL = AtomType.BOOLEAN.qname().local();
    private static final byte[] DATE = AtomType.DATE.qname().local();
    private static final byte[] DOUBLE = AtomType.DOUBLE.qname().local();
    private static final byte[] FLOAT = AtomType.FLOAT.qname().local();
    private static final byte[] SHORT = AtomType.SHORT.qname().local();
    private static final byte[] TIME = AtomType.TIME.qname().local();
    private static final byte[] TIMESTAMP = Token.token("timestamp");
    private static final byte[] SQLXML = Token.token("sqlxml");
    private static final byte[] TYPE = Token.token("type");
    private static final byte[] NULL = Token.token("null");

    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        this.checkCreate(qc);
        PreparedStatement stmt = this.prepared(qc);
        ANode params = null;
        if (this.exprs.length > 1 && !(params = this.toElem(this.exprs[1], qc)).qname().eq(Q_PARAMETERS)) {
            throw QueryError.INVALIDOPTION_X.get(this.info, new Object[]{params.qname().local()});
        }
        SqlExecute.StatementOptions options = this.toOptions(2, new SqlExecute.StatementOptions(), qc);
        try {
            stmt.setQueryTimeout(options.get(SqlExecute.StatementOptions.TIMEOUT));
            if (params != null) {
                this.setParameters(params.childIter(), stmt);
            }
            return this.iter(stmt, false, stmt.execute());
        }
        catch (QueryException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw QueryError.SQL_ERROR_X.get(this.info, ex);
        }
    }

    private void setParameters(BasicNodeIter params, PreparedStatement stmt) throws QueryException {
        ANode next;
        int i = 0;
        while ((next = params.next()) != null) {
            ANode attr;
            if (!next.qname().eq(Q_PARAMETER)) {
                throw QueryError.INVALIDOPTION_X.get(this.info, new Object[]{next.qname().local()});
            }
            BasicNodeIter attrs = next.attributeIter();
            byte[] paramType = null;
            boolean isNull = false;
            while ((attr = attrs.next()) != null) {
                if (Token.eq(attr.name(), TYPE)) {
                    paramType = attr.string();
                    continue;
                }
                if (Token.eq(attr.name(), NULL)) {
                    isNull = attr.string() != null && Bln.parse(attr, this.info);
                    continue;
                }
                throw QueryError.SQL_ATTRIBUTE_X.get(this.info, new Object[]{attr.name()});
            }
            if (paramType == null) {
                throw QueryError.SQL_PARAMETERS.get(this.info, new Object[0]);
            }
            byte[] v = next.string();
            this.setParam(++i, stmt, paramType, isNull ? null : Token.string(v), isNull);
        }
    }

    private void setParam(int index, PreparedStatement stmt, byte[] type, String value, boolean isNull) throws QueryException {
        block33: {
            try {
                if (Token.eq(BOOL, type)) {
                    if (isNull) {
                        stmt.setNull(index, 16);
                    } else {
                        stmt.setBoolean(index, Boolean.parseBoolean(value));
                    }
                    break block33;
                }
                if (Token.eq(DATE, type)) {
                    if (isNull) {
                        stmt.setNull(index, 91);
                    } else {
                        stmt.setDate(index, Date.valueOf(value));
                    }
                    break block33;
                }
                if (Token.eq(DOUBLE, type)) {
                    if (isNull) {
                        stmt.setNull(index, 8);
                    } else {
                        stmt.setDouble(index, Double.parseDouble(value));
                    }
                    break block33;
                }
                if (Token.eq(FLOAT, type)) {
                    if (isNull) {
                        stmt.setNull(index, 6);
                    } else {
                        stmt.setFloat(index, Float.parseFloat(value));
                    }
                    break block33;
                }
                if (Token.eq(INT, type)) {
                    if (isNull) {
                        stmt.setNull(index, 4);
                    } else {
                        stmt.setInt(index, Integer.parseInt(value));
                    }
                    break block33;
                }
                if (Token.eq(SHORT, type)) {
                    if (isNull) {
                        stmt.setNull(index, 5);
                    } else {
                        stmt.setShort(index, Short.parseShort(value));
                    }
                    break block33;
                }
                if (Token.eq(STRING, type)) {
                    if (isNull) {
                        stmt.setNull(index, 12);
                    } else {
                        stmt.setString(index, value);
                    }
                    break block33;
                }
                if (Token.eq(TIME, type)) {
                    if (isNull) {
                        stmt.setNull(index, 92);
                    } else {
                        stmt.setTime(index, Time.valueOf(value));
                    }
                    break block33;
                }
                if (Token.eq(TIMESTAMP, type)) {
                    if (isNull) {
                        stmt.setNull(index, 93);
                    } else {
                        stmt.setTimestamp(index, Timestamp.valueOf(value));
                    }
                    break block33;
                }
                if (Token.eq(SQLXML, type)) {
                    if (isNull) {
                        stmt.setNull(index, 2009);
                    } else {
                        SQLXML xml = stmt.getConnection().createSQLXML();
                        xml.setString(value);
                        stmt.setSQLXML(index, xml);
                    }
                    break block33;
                }
                throw QueryError.SQL_ERROR_X.get(this.info, "unsupported type: " + Token.string(type));
            }
            catch (SQLException ex) {
                throw QueryError.SQL_ERROR_X.get(this.info, ex);
            }
            catch (IllegalArgumentException ex) {
                Util.debug(ex);
                throw QueryError.SQL_TYPE_X_X.get(this.info, type, value);
            }
        }
    }
}

