/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.random;

import java.util.Random;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.IntSeq;
import org.basex.query.value.seq.Seq;
import org.basex.util.list.LongList;

public final class RandomSeededInteger
extends StandardFunc {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        final long[] args = this.args(qc);
        return new Iter(){
            final Random r;
            long c;
            final int max;
            {
                this.r = new Random(args[0]);
                this.c = args[1];
                this.max = (int)args[2];
            }

            @Override
            public Item next() {
                return --this.c >= 0L ? Int.get(this.max == 0 ? (long)this.r.nextInt() : (long)this.r.nextInt(this.max)) : null;
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        long[] args = this.args(qc);
        Random r = new Random(args[0]);
        int vl = Seq.initialCapacity(args[1]);
        int max = (int)args[2];
        LongList values = new LongList(vl);
        for (long v = 0L; v < (long)vl; ++v) {
            values.add(max == 0 ? (long)r.nextInt() : (long)r.nextInt(max));
        }
        return IntSeq.get(values.finish());
    }

    private long[] args(QueryContext qc) throws QueryException {
        long seed = this.toLong(this.exprs[0], qc);
        long num = this.toLong(this.exprs[1], qc);
        if (num < 0L) {
            throw QueryError.RANGE_NEGATIVE_X.get(this.info, num);
        }
        long max = 0L;
        if (this.exprs.length > 2 && ((max = this.toLong(this.exprs[2], qc)) < 1L || max > Integer.MAX_VALUE)) {
            throw QueryError.RANDOM_BOUNDS_X.get(this.info, max);
        }
        return new long[]{seed, num, max};
    }
}

