/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.random;

import java.util.Random;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.DblSeq;
import org.basex.query.value.seq.Seq;
import org.basex.util.list.DoubleList;

public final class RandomGaussian
extends StandardFunc {
    private static final Random RND = new Random();

    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        final long num = this.toLong(this.exprs[0], qc);
        return new Iter(){
            long c;
            {
                this.c = num;
            }

            @Override
            public Item next() {
                return --this.c >= 0L ? Dbl.get(RND.nextGaussian()) : null;
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        long num = this.toLong(this.exprs[0], qc);
        DoubleList values = new DoubleList(Seq.initialCapacity(num));
        for (long n = 0L; n < num; ++n) {
            values.add(RND.nextGaussian());
        }
        return DblSeq.get(values.finish());
    }
}

