/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.util.regex.parse.ParseException;
import org.basex.query.util.regex.parse.RegExParser;
import org.basex.query.util.regex.parse.TokenMgrError;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenObjMap;

abstract class RegEx
extends StandardFunc {
    private final TokenObjMap<RegExpr> patterns = new TokenObjMap();

    RegEx() {
    }

    protected final Pattern pattern(Expr regex, Expr modifier, QueryContext qc, boolean check) throws QueryException {
        return this.regExpr((Expr)regex, (Expr)modifier, (QueryContext)qc, (boolean)check).pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final RegExpr regExpr(Expr regex, Expr modifier, QueryContext qc, boolean check) throws QueryException {
        byte[] pat = this.toToken(regex, qc);
        byte[] mod = modifier != null ? this.toToken(modifier, qc) : Token.EMPTY;
        byte[] key = Token.concat(pat, Character.valueOf('\b'), mod);
        TokenObjMap<RegExpr> tokenObjMap = this.patterns;
        synchronized (tokenObjMap) {
            RegExpr regExpr = this.patterns.get(key);
            if (regExpr == null) {
                regExpr = this.parse(pat, mod, check);
                this.patterns.put(key, regExpr);
            }
            return regExpr;
        }
    }

    private RegExpr parse(byte[] regex, byte[] modifiers, boolean check) throws QueryException {
        int flags = 0;
        boolean strip = false;
        boolean java = false;
        for (byte mod : modifiers) {
            if (mod == 105) {
                flags |= 0x42;
                continue;
            }
            if (mod == 109) {
                flags |= 8;
                continue;
            }
            if (mod == 115) {
                flags |= 0x20;
                continue;
            }
            if (mod == 113) {
                flags |= 0x10;
                continue;
            }
            if (mod == 120) {
                strip = true;
                continue;
            }
            if (mod == 106 || mod == 33) {
                java = true;
                continue;
            }
            if (mod == 59) continue;
            throw QueryError.REGMOD_X.get(this.info, Character.valueOf((char)mod));
        }
        try {
            Pattern pattern;
            int groups = 0;
            if (java || (flags & 0x10) != 0) {
                pattern = Pattern.compile(Token.string(regex), flags);
            } else {
                RegExParser parser = new RegExParser(regex, strip, (flags & 0x20) != 0, (flags & 8) != 0);
                String string = parser.parse().toString();
                pattern = Pattern.compile(string, flags);
                if (check) {
                    Pattern p;
                    Pattern pattern2 = p = (pattern.flags() & 8) == 0 ? pattern : Pattern.compile(pattern.pattern());
                    if (p.matcher("").matches()) {
                        throw QueryError.REGROUP.get(this.info, new Object[0]);
                    }
                }
                groups = parser.groups();
            }
            RegExpr regExpr = new RegExpr();
            regExpr.pattern = pattern;
            regExpr.groups = groups;
            return regExpr;
        }
        catch (PatternSyntaxException | ParseException | TokenMgrError ex) {
            Util.debug(ex);
            throw QueryError.REGPAT_X.get(this.info, new Object[]{regex});
        }
    }

    static class RegExpr {
        Pattern pattern;
        int groups;

        RegExpr() {
        }
    }
}

