/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.io.serial.SerializerMode;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.BasicIter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.seq.SingletonSeq;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public class FnTrace
extends StandardFunc {
    @Override
    public Value value(QueryContext qc) throws QueryException {
        byte[] label;
        Value value = this.exprs[0].value(qc);
        byte[] byArray = label = this.exprs.length > 1 ? this.toToken(this.exprs[1], qc) : null;
        if (value.isEmpty() || value instanceof RangeSeq || value instanceof SingletonSeq) {
            FnTrace.trace(Token.token(value.toString()), label, qc);
        } else {
            BasicIter<Item> iter = value.iter();
            try {
                Item item;
                while ((item = qc.next(iter)) != null) {
                    FnTrace.trace(item.serialize(SerializerMode.DEBUG.get()).finish(), label, qc);
                }
            }
            catch (QueryIOException ex) {
                throw ex.getCause(this.info);
            }
        }
        return value;
    }

    @Override
    protected Expr opt(CompileContext cc) {
        return this.adoptType(this.exprs[0]);
    }

    @Override
    public boolean ddo() {
        return this.exprs[0].ddo();
    }

    public static void trace(byte[] value, byte[] label, QueryContext qc) {
        String info;
        TokenBuilder tb = new TokenBuilder();
        if (label != null) {
            tb.add(label);
        }
        if (qc.jc().tracer.print(info = tb.add(value).toString())) {
            qc.evalInfo(info);
        }
    }
}

