/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.util.Arrays;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.value.Value;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.seq.Empty;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class FnSubstring
extends StandardFunc {
    @Override
    public Str item(QueryContext qc, InputInfo ii) throws QueryException {
        int end;
        byte[] string = this.toZeroToken(this.exprs[0], qc);
        boolean ascii = Token.ascii(string);
        int length = ascii ? string.length : Token.length(string);
        int start = this.start(qc);
        int n = end = this.exprs.length == 3 ? this.length(qc) : length;
        if (length == 0 || start == Integer.MIN_VALUE) {
            return Str.EMPTY;
        }
        if (start < 0) {
            end += start;
            start = 0;
        }
        if (start >= (end = Math.min(length, this.exprs.length == 3 ? start + end : Integer.MAX_VALUE))) {
            return Str.EMPTY;
        }
        if (ascii) {
            return Str.get(Token.substring(string, start, end));
        }
        int ss = start;
        int ee = end;
        int p = 0;
        int sl = string.length;
        length = 0;
        while (length < sl) {
            if (p == start) {
                ss = length;
            }
            if (p == end) {
                ee = length;
            }
            length += Token.cl(string, length);
            ++p;
        }
        if (p == end) {
            ee = length;
        }
        return Str.get(Arrays.copyOfRange(string, ss, ee));
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        int length;
        int start;
        Expr expr1 = this.exprs[0];
        Expr expr2 = this.exprs[1];
        if (expr1 == Empty.VALUE || expr1 == Str.EMPTY) {
            return Str.EMPTY;
        }
        int n = start = expr2 instanceof Value ? this.start(cc.qc) : Integer.MAX_VALUE;
        int n2 = this.exprs.length < 3 ? Integer.MAX_VALUE : (length = this.exprs[2] instanceof Value ? this.length(cc.qc) : Integer.MIN_VALUE);
        if (start == Integer.MIN_VALUE || length == 0) {
            return Str.EMPTY;
        }
        return start <= 0 && length == Integer.MAX_VALUE && expr1.seqType().type.isStringOrUntyped() ? cc.function(Function.STRING, this.info, expr1) : this;
    }

    private int start(QueryContext qc) throws QueryException {
        Item item = this.toAtomItem(this.exprs[1], qc);
        if (item instanceof Int) {
            return FnSubstring.limit(item.itr(this.info) - 1L);
        }
        double dbl = item.dbl(this.info);
        return Double.isNaN(dbl) ? Integer.MIN_VALUE : FnSubstring.subPos(dbl);
    }

    private int length(QueryContext qc) throws QueryException {
        Item item = this.toAtomItem(this.exprs[2], qc);
        return item instanceof Int ? (int)item.itr(this.info) : FnSubstring.subPos(item.dbl(this.info) + 1.0);
    }

    private static int subPos(double d) {
        int i = (int)d;
        return FnSubstring.limit(d == (double)i ? (long)(i - 1) : (long)StrictMath.floor(d - 0.5));
    }

    private static int limit(long l) {
        return (int)Math.min(Math.max(-2147483647L, l), 0x7FFFFFFEL);
    }
}

