/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.db;

import java.util.Locale;
import org.basex.core.cmd.InfoDB;
import org.basex.data.Data;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.db.DbAccess;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FElem;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;

public final class DbInfo
extends DbAccess {
    private static final String DATABASE = "database";

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Data data = this.checkData(qc);
        return DbInfo.toNode(InfoDB.db(data.meta, false, true), DATABASE);
    }

    static ANode toNode(String string, String root) {
        FElem top = new FElem(root);
        FElem node = null;
        for (String l : string.split("\r\n?|\n")) {
            String[] cols = l.split(": ", 2);
            if (cols[0].isEmpty()) continue;
            FElem n = new FElem(Token.token(DbInfo.toName(cols[0])));
            if (Strings.startsWith(cols[0], ' ')) {
                if (node != null) {
                    node.add(n);
                }
                if (cols[1].isEmpty()) continue;
                n.add(cols[1]);
                continue;
            }
            node = n;
            top.add(n);
        }
        return top;
    }

    public static String toName(String string) {
        return string.replaceAll("[ -:]", "").toLowerCase(Locale.ENGLISH);
    }
}

