/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.db;

import org.basex.core.Databases;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.db.DbNew;
import org.basex.query.iter.Iter;
import org.basex.query.up.primitives.NewInput;
import org.basex.query.up.primitives.name.DBCreate;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.list.TokenList;
import org.basex.util.options.Options;

public final class DbCreate
extends DbNew {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        NewInput[] inputs;
        String name = Token.string(this.toToken(this.exprs[0], qc));
        if (!Databases.validName(name)) {
            throw QueryError.DB_NAME_X.get(this.info, name);
        }
        TokenList paths = new TokenList();
        if (this.exprs.length > 2) {
            Item item;
            Iter iter = this.exprs[2].iter(qc);
            while ((item = qc.next(iter)) != null) {
                paths.add(this.path(this.toToken(item)));
            }
        }
        if (this.exprs.length > 1) {
            Value value = this.exprs[1].value(qc);
            long is = value.size();
            long ps = paths.size();
            if (ps != 0L && is != ps) {
                throw QueryError.DB_ARGS_X_X.get(this.info, is, ps);
            }
            inputs = new NewInput[(int)is];
            int i = 0;
            while ((long)i < is) {
                qc.checkStop();
                inputs[i] = this.checkInput(value.itemAt(i), (long)i < ps ? (byte[])paths.get(i) : Token.EMPTY);
                ++i;
            }
        } else {
            inputs = new NewInput[]{};
        }
        Options opts = this.toOptions(3, new Options(), qc);
        qc.updates().add(new DBCreate(name, inputs, opts, qc, this.info), qc);
        return Empty.VALUE;
    }
}

