/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.db;

import org.basex.core.Databases;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.db.DbAccess;
import org.basex.query.up.Updates;
import org.basex.query.up.primitives.name.BackupAlter;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.list.StringList;

public final class DbAlterBackup
extends DbAccess {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        String name = Token.string(this.toToken(this.exprs[0], qc));
        String newname = Token.string(this.toToken(this.exprs[1], qc));
        if (!Databases.validName(name)) {
            throw QueryError.DB_NAME_X.get(this.info, name);
        }
        if (!Databases.validName(newname)) {
            throw QueryError.DB_NAME_X.get(this.info, newname);
        }
        if (name.equals(newname)) {
            throw QueryError.DB_CONFLICT4_X.get(this.info, name, newname);
        }
        StringList backups = qc.context.databases.backups(name);
        if (backups.isEmpty()) {
            throw QueryError.DB_NOBACKUP_X.get(this.info, name);
        }
        Updates updates = qc.updates();
        for (String backup : backups) {
            updates.add(new BackupAlter(backup, newname, qc, this.info), qc);
        }
        return Empty.VALUE;
    }
}

