/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.archive;

import java.io.IOException;
import org.basex.core.MainOptions;
import org.basex.io.in.ArrayInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.archive.ArchiveText;
import org.basex.query.func.convert.ConvertFn;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.AStr;
import org.basex.query.value.item.Item;
import org.basex.util.hash.TokenSet;

abstract class ArchiveFn
extends StandardFunc {
    ArchiveFn() {
    }

    final Item checkElemToken(Item item) throws QueryException {
        if (item instanceof AStr || ArchiveText.ENTRY.matches(item)) {
            return item;
        }
        throw QueryError.ELMSTR_X_X_X.get(this.info, ArchiveText.Q_ENTRY.prefixId(), item.type, item);
    }

    final byte[] encode(byte[] value, String encoding, QueryContext qc) throws QueryException {
        try {
            boolean validate = qc.context.options.get(MainOptions.CHECKSTRINGS);
            return ConvertFn.toString(new ArrayInput(value), encoding, validate);
        }
        catch (IOException ex) {
            throw QueryError.ARCHIVE_ENCODE2_X.get(this.info, ex);
        }
    }

    final TokenSet entries(int e, QueryContext qc) throws QueryException {
        TokenSet hs = null;
        if (e < this.exprs.length) {
            Item en;
            hs = new TokenSet();
            Iter names = this.exprs[e].iter(qc);
            while ((en = qc.next(names)) != null) {
                hs.add(this.checkElemToken(en).string(this.info));
            }
        }
        return hs;
    }
}

