/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.archive;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import org.basex.io.IOFile;
import org.basex.io.out.BufferOutput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.archive.ArchiveFn;
import org.basex.query.func.archive.ArchiveIn;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.TokenSet;

public class ArchiveExtractTo
extends ArchiveFn {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        this.checkCreate(qc);
        Path path = this.toPath(0, qc);
        B64 archive = this.toB64(this.exprs[1], qc, false);
        TokenSet hs = this.entries(2, qc);
        try (ArchiveIn in = ArchiveIn.get(archive.input(this.info), this.info);){
            while (in.more()) {
                BufferOutput out;
                block25: {
                    ZipEntry ze = in.entry();
                    String name = ze.getName();
                    if (hs != null && hs.remove(Token.token(name)) == 0) continue;
                    Path file = path.resolve(name);
                    if (ze.isDirectory()) {
                        Files.createDirectories(file, new FileAttribute[0]);
                        continue;
                    }
                    Files.createDirectories(file.getParent(), new FileAttribute[0]);
                    out = new BufferOutput(new IOFile(file.toFile()));
                    Throwable throwable = null;
                    try {
                        in.write(out);
                        if (out == null) continue;
                        if (throwable == null) break block25;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (out == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    out.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            out.close();
                            throw throwable3;
                        }
                    }
                    try {
                        out.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                out.close();
            }
            return Empty.VALUE;
        }
        catch (IOException ex) {
            throw QueryError.ARCHIVE_ERROR_X.get(this.info, ex);
        }
    }
}

