/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.EnumSet;
import java.util.function.Supplier;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.util.Flag;
import org.basex.query.util.NSGlobal;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class FuncDefinition {
    final Supplier<? extends StandardFunc> supplier;
    final int[] minMax;
    final SeqType[] params;
    public final SeqType seqType;
    final byte[] uri;
    private final String desc;
    private final EnumSet<Flag> flags;

    FuncDefinition(Supplier<? extends StandardFunc> supplier, String desc, SeqType[] params, SeqType seqType, EnumSet<Flag> flags, byte[] uri) {
        this.supplier = supplier;
        this.desc = desc;
        this.seqType = seqType;
        this.params = params;
        this.flags = flags;
        this.uri = uri;
        this.minMax = FuncDefinition.minMax(desc, params);
        if (flags.contains((Object)Flag.UPD)) {
            flags.add(Flag.NDT);
        }
    }

    public static int[] minMax(String desc, SeqType[] args) {
        int b = desc.indexOf(91);
        int al = args.length;
        if (b == -1) {
            return new int[]{al, al};
        }
        int c = b + 1 < desc.length() && desc.charAt(b + 1) == ',' ? 1 : 0;
        for (int i = 0; i < b; ++i) {
            if (desc.charAt(i) != ',') continue;
            ++c;
        }
        return new int[]{c, desc.contains("...") ? Integer.MAX_VALUE : al};
    }

    public byte[] uri() {
        return this.uri;
    }

    public boolean has(Flag flag) {
        return this.flags.contains((Object)flag);
    }

    FuncType type(int arity, AnnList anns) {
        SeqType[] st = new SeqType[arity];
        if (arity != 0 && this.minMax[1] == Integer.MAX_VALUE) {
            int pl = this.params.length;
            Array.copy(this.params, pl, st);
            SeqType var = this.params[pl - 1];
            for (int p = pl; p < arity; ++p) {
                st[p] = var;
            }
        } else {
            Array.copy(this.params, arity, st);
        }
        return FuncType.get(anns, this.seqType, st);
    }

    String[] names() {
        String names = this.desc.replaceFirst(".*?\\(", "").replace(",...", "").replaceAll("[\\[\\])\\s]", "");
        return names.isEmpty() ? new String[]{} : Strings.split(names, ',');
    }

    QNm[] paramNames(int arity) {
        String[] strings = this.names();
        QNm[] names = new QNm[arity];
        int nl = strings.length;
        int n = Math.min(arity, nl);
        while (--n >= 0) {
            names[n] = new QNm(strings[n]);
        }
        if (arity > nl) {
            String[] parts = strings[nl - 1].split("(?=\\d+$)", 2);
            int start = Integer.parseInt(parts[1]);
            for (int n2 = nl; n2 < arity; ++n2) {
                names[n2] = new QNm(parts[0] + (start + n2 - nl + 1), "");
            }
        }
        return names;
    }

    public byte[] local() {
        return Token.token(this.desc.substring(0, this.desc.indexOf(40)));
    }

    byte[] id() {
        TokenBuilder tb = new TokenBuilder();
        if (!Token.eq(this.uri, QueryText.FN_URI)) {
            tb.add(NSGlobal.prefix(this.uri)).add(58);
        }
        return tb.add(this.local()).finish();
    }

    String args(Object ... args) {
        TokenBuilder tb = new TokenBuilder();
        for (Object arg : args) {
            if (!tb.isEmpty()) {
                tb.add(", ");
            }
            if (arg == null) {
                tb.add("()");
                continue;
            }
            if (arg instanceof Expr) {
                tb.add(arg);
                continue;
            }
            if (arg instanceof Number) {
                tb.add(arg);
                continue;
            }
            if (arg instanceof Boolean) {
                tb.add(arg + "()");
                continue;
            }
            String str = arg.toString();
            if (Strings.startsWith(str, ' ')) {
                tb.add(str.substring(1));
                continue;
            }
            tb.add('\"' + str.replaceAll("\"", "\"\"") + '\"');
        }
        return ' ' + this.toString().replaceAll("\\(.*", "(") + tb + ')';
    }

    public StandardFunc get(StaticContext sc, InputInfo ii, Expr ... args) {
        StandardFunc sf = this.supplier.get();
        sf.init(sc, ii, this, args);
        return sf;
    }

    public String toString() {
        return Strings.concat(NSGlobal.prefix(this.uri), ":", this.desc);
    }
}

