/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.index;

import org.basex.data.Data;
import org.basex.index.IndexType;
import org.basex.index.query.IndexIterator;
import org.basex.index.query.NumericRange;
import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.index.IndexAccess;
import org.basex.query.expr.index.IndexDb;
import org.basex.query.func.Function;
import org.basex.query.iter.DBNodeIter;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.seq.DBNodeSeq;
import org.basex.query.value.type.NodeType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;
import org.basex.util.list.IntList;

public final class RangeAccess
extends IndexAccess {
    private final NumericRange index;

    public RangeAccess(InputInfo info, NumericRange index, IndexDb db) {
        super(db, info, index.type() == IndexType.TEXT ? NodeType.TEXT : NodeType.ATTRIBUTE);
        this.index = index;
    }

    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        final IndexType type = this.index.type();
        Data data = this.db.data(qc, type);
        return new DBNodeIter(data){
            final byte kind;
            final IndexIterator ii;
            {
                super(data);
                this.kind = (byte)(type == IndexType.TEXT ? 2 : 3);
                this.ii = this.data.iter(RangeAccess.this.index);
            }

            @Override
            public DBNode next() {
                return this.ii.more() ? new DBNode(this.data, this.ii.pre(), this.kind) : null;
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        IndexType it = this.index.type();
        Data data = this.db.data(qc, it);
        IndexIterator ii = data.iter(this.index);
        IntList list = new IntList();
        while (ii.more()) {
            list.add(ii.pre());
        }
        return DBNodeSeq.get(list.finish(), data, this);
    }

    @Override
    public Expr inline(InlineContext ic) throws QueryException {
        return this.inlineDb(ic) ? this.optimize(ic.cc) : null;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new RangeAccess(this.info, this.index, (IndexDb)this.db.copy(cc, (IntObjMap)vm)));
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof RangeAccess && this.index.equals(((RangeAccess)obj).index) && super.equals(obj);
    }

    @Override
    public void plan(QueryPlan plan) {
        plan.add(plan.create(this, new Object[]{"index", this.index.type(), "min", this.index.min, "max", this.index.max}), this.db);
    }

    @Override
    public void plan(QueryString qs) {
        Function function = this.index.type() == IndexType.TEXT ? Function._DB_TEXT_RANGE : Function._DB_ATTRIBUTE_RANGE;
        qs.function(function, this.db, Dbl.get(this.index.min), Dbl.get(this.index.max));
    }
}

