/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.constr;

import java.util.Arrays;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.constr.CAttr;
import org.basex.query.expr.constr.CName;
import org.basex.query.expr.constr.CNode;
import org.basex.query.expr.constr.Constr;
import org.basex.query.expr.path.Test;
import org.basex.query.util.NSContext;
import org.basex.query.value.Value;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FAttr;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.IntObjMap;

public final class CElem
extends CName {
    private final Atts nspaces;

    public CElem(StaticContext sc, InputInfo info, boolean computed, Expr name, Atts nspaces, Expr ... cont) {
        super(sc, info, SeqType.ELEMENT_O, computed, name, cont);
        this.nspaces = nspaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        int s = this.addNS();
        try {
            Expr expr = super.compile(cc);
            return expr;
        }
        finally {
            this.sc.ns.size(s);
        }
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        QNm nm;
        this.name = this.name.simplifyFor(CompileContext.Simplify.STRING, cc);
        if (this.name instanceof Value && (nm = this.qname(true, cc.qc, null)) != null) {
            this.name = nm;
            this.exprType.assign(SeqType.get(NodeType.ELEMENT, Occ.EXACTLY_ONE, Test.get(NodeType.ELEMENT, nm)));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FElem item(QueryContext qc, InputInfo ii) throws QueryException {
        int s = this.addNS();
        try {
            Atts inscopeNS = new Atts();
            int nl = this.nspaces.size();
            for (int i = 0; i < nl; ++i) {
                inscopeNS.add(this.nspaces.name(i), this.nspaces.value(i));
            }
            QNm nm = this.qname(true, qc, this.sc);
            byte[] cp = nm.prefix();
            byte[] cu = nm.uri();
            if (Token.eq(cp, Token.XML) ^ Token.eq(cu, QueryText.XML_URI)) {
                throw QueryError.CEXML.get(this.info, cu, cp);
            }
            if (Token.eq(cu, QueryText.XMLNS_URI)) {
                throw QueryError.CEINV_X.get(this.info, new Object[]{cu});
            }
            if (Token.eq(cp, Token.XMLNS)) {
                throw QueryError.CEINV_X.get(this.info, new Object[]{cp});
            }
            if (!nm.hasURI() && nm.hasPrefix()) {
                throw QueryError.INVPREF_X.get(this.info, nm);
            }
            Constr constr = new Constr(this.info, this.sc);
            FElem node = new FElem(nm, inscopeNS, constr.children, constr.atts);
            constr.add(qc, this.exprs);
            if (constr.errAtt != null) {
                throw QueryError.NOATTALL_X.get(this.info, constr.errAtt);
            }
            if (constr.errNS != null) {
                throw QueryError.NONSALL_X.get(this.info, constr.errNS);
            }
            if (constr.duplAtt != null) {
                throw QueryError.CATTDUPL_X.get(this.info, constr.duplAtt);
            }
            if (constr.duplNS != null) {
                throw QueryError.DUPLNSCONS_X.get(this.info, new Object[]{constr.duplNS});
            }
            if (constr.nspaces.contains(Token.EMPTY) && !nm.hasPrefix()) {
                throw QueryError.DUPLNSCONS_X.get(this.info, new Object[]{Token.EMPTY});
            }
            if (!Token.eq(cp, Token.XML)) {
                byte[] uri = this.sc.ns.uri(cp);
                if (nm.hasURI()) {
                    if (!(this.computed || uri != null && Token.eq(uri, cu))) {
                        this.sc.ns.add(cp, cu);
                    }
                    if (!inscopeNS.contains(cp)) {
                        inscopeNS.add(cp, cu);
                    }
                } else {
                    nm.uri(uri);
                }
            }
            Atts cns = constr.nspaces;
            int cl = cns.size();
            for (int c = 0; c < cl; ++c) {
                CElem.addNS(cns.name(c), cns.value(c), inscopeNS);
            }
            int al = constr.atts.size();
            for (int a = 0; a < al; ++a) {
                byte[] auri;
                byte[] npref;
                byte[] apref;
                ANode att = (ANode)constr.atts.get(a);
                QNm qnm = att.qname();
                if (!qnm.hasPrefix() || !qnm.hasURI() || Token.eq(apref = qnm.prefix(), Token.XML) || (npref = CElem.addNS(apref, auri = qnm.uri(), inscopeNS)) == null) continue;
                QNm aname = new QNm(Token.concat(npref, Token.COLON, qnm.local()), auri);
                constr.atts.set(a, new FAttr(aname, att.string()));
            }
            for (ANode ch : constr.children) {
                ch.optimize();
            }
            FElem fElem = node.optimize();
            return fElem;
        }
        finally {
            this.sc.ns.size(s);
        }
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new CElem(this.sc, this.info, this.computed, this.name.copy(cc, vm), this.nspaces.copy(), CElem.copyAll((CompileContext)cc, vm, (Expr[])this.exprs)));
    }

    private static byte[] addNS(byte[] pref, byte[] uri, Atts ns) {
        byte[] u = ns.value(pref);
        if (u == null) {
            ns.add(pref, uri);
        } else if (!Token.eq(u, uri)) {
            byte[] apref = null;
            int nl = ns.size();
            for (int n = 0; n < nl; ++n) {
                if (!Token.eq(ns.value(n), uri)) continue;
                apref = ns.name(n);
            }
            if (apref == null) {
                int i = 1;
                while (ns.contains(apref = Token.concat(pref, "_", i++))) {
                }
                ns.add(apref, uri);
            }
            return apref;
        }
        return null;
    }

    private int addNS() {
        NSContext ns = this.sc.ns;
        int size = ns.size();
        int nl = this.nspaces.size();
        for (int n = 0; n < nl; ++n) {
            ns.add(this.nspaces.name(n), this.nspaces.value(n));
        }
        return size;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof CElem && this.nspaces.equals(((CElem)obj).nspaces) && super.equals(obj);
    }

    @Override
    public void plan(QueryString qs) {
        if (this.computed) {
            this.plan(qs, "element");
        } else {
            byte[] nm = ((QNm)this.name).string();
            qs.token('<').token(nm);
            int el = this.exprs.length;
            for (int e = 0; e < el; ++e) {
                Expr expr = this.exprs[e];
                if (!(expr instanceof CAttr) || ((CAttr)expr).computed) {
                    int f;
                    qs.token('>');
                    boolean constr = false;
                    for (f = e; f < el && !constr; ++f) {
                        constr = this.exprs[f] instanceof CNode ? ((CNode)this.exprs[f]).computed : !(this.exprs[f] instanceof Str);
                    }
                    if (constr) {
                        qs.token('{').tokens(Arrays.copyOfRange(this.exprs, e, el), ", ").token("}");
                    } else {
                        for (f = e; f < el; ++f) {
                            if (this.exprs[f] instanceof Str) {
                                qs.value(((Str)this.exprs[f]).string());
                                continue;
                            }
                            qs.token(this.exprs[f]);
                        }
                    }
                    qs.token('<').token('/').token(nm).token('>');
                    return;
                }
                qs.token(expr);
            }
            qs.token('/').token('>');
        }
    }
}

