/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.constr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.constr.CName;
import org.basex.query.expr.path.Test;
import org.basex.query.value.Value;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.FAttr;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.IntObjMap;

public final class CAttr
extends CName {
    private static final byte[] NS0 = Token.token("ns0:");

    public CAttr(StaticContext sc, InputInfo info, boolean computed, Expr name, Expr ... value) {
        super(sc, info, SeqType.ATTRIBUTE_O, computed, name, value);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        QNm nm;
        this.name = this.name.simplifyFor(CompileContext.Simplify.STRING, cc);
        if (this.name instanceof Value && (nm = this.qname(true, cc.qc, null)) != null) {
            this.name = nm;
            this.exprType.assign(SeqType.get(NodeType.ATTRIBUTE, Occ.EXACTLY_ONE, Test.get(NodeType.ATTRIBUTE, nm)));
        }
        this.optValue(cc);
        return this;
    }

    @Override
    public FAttr item(QueryContext qc, InputInfo ii) throws QueryException {
        QNm nm = this.qname(false, qc, this.sc);
        byte[] cp = nm.prefix();
        if (this.computed) {
            byte[] cu = nm.uri();
            if (Token.eq(cp, Token.XML) ^ Token.eq(cu, QueryText.XML_URI)) {
                throw QueryError.CAXML.get(this.info, new Object[0]);
            }
            if (Token.eq(cu, QueryText.XMLNS_URI)) {
                throw QueryError.CAINV_.get(this.info, new Object[]{cu});
            }
            if (Token.eq(cp, Token.XMLNS) || cp.length == 0 && Token.eq(nm.string(), Token.XMLNS)) {
                throw QueryError.CAINV_.get(this.info, new Object[]{nm.string()});
            }
            if (Token.eq(cp, Token.EMPTY) && !Token.eq(cu, Token.EMPTY)) {
                nm = new QNm(Token.concat(NS0, nm.string()), cu);
            }
        }
        if (!nm.hasURI() && nm.hasPrefix()) {
            throw QueryError.INVPREF_X.get(this.info, nm);
        }
        byte[] value = this.atomValue(qc);
        if (Token.eq(cp, Token.XML) && Token.eq(nm.local(), Token.ID)) {
            value = Token.normalize(value);
        }
        return new FAttr(nm, value);
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new CAttr(this.sc, this.info, this.computed, this.name.copy(cc, vm), CAttr.copyAll((CompileContext)cc, vm, (Expr[])this.exprs)));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof CAttr && super.equals(obj);
    }

    @Override
    public void plan(QueryString qs) {
        if (this.computed) {
            this.plan(qs, "attribute");
        } else {
            qs.token(((QNm)this.name).string()).token('=');
            if (this.exprs.length == 1 && this.exprs[0] instanceof Str) {
                qs.quoted(((Str)this.exprs[0]).string());
            } else {
                qs.token("\"{").tokens(this.exprs, ", ").token("}\"");
            }
        }
    }
}

