/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.ArrayList;
import java.util.Arrays;
import org.basex.data.Data;
import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Arr;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.Expr;
import org.basex.query.expr.If;
import org.basex.query.expr.List;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.SwitchGroup;
import org.basex.query.expr.TypeCheck;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.Array;
import org.basex.util.Checks;
import org.basex.util.InputInfo;
import org.basex.util.Util;
import org.basex.util.hash.IntObjMap;

public final class Switch
extends ParseExpr {
    private Expr cond;
    private SwitchGroup[] groups;

    public Switch(InputInfo info, Expr cond, SwitchGroup[] groups) {
        super(info, SeqType.ITEM_ZM);
        this.cond = cond;
        this.groups = groups;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoUp(this.cond);
        for (SwitchGroup group : this.groups) {
            group.checkUp();
        }
        ExprList rtrns = new ExprList(this.groups.length);
        for (SwitchGroup group : this.groups) {
            rtrns.add(group.rtrn());
        }
        this.checkAllUp((Expr[])rtrns.finish());
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        this.cond = this.cond.compile(cc);
        for (SwitchGroup group : this.groups) {
            group.compile(cc);
        }
        return this.optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        this.cond = this.cond.simplifyFor(CompileContext.Simplify.STRING, cc);
        Expr expr = this.opt(cc);
        if (expr != this) {
            return cc.replaceWith(this, expr);
        }
        int gl = this.groups.length;
        SeqType st = this.groups[0].seqType();
        for (int g = 1; g < gl; ++g) {
            st = st.union(this.groups[g].seqType());
        }
        this.exprType.assign(st);
        return this;
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        boolean changed = false;
        for (SwitchGroup group : this.groups) {
            changed |= group.simplify(mode, cc);
        }
        return changed ? this.optimize(cc) : super.simplifyFor(mode, cc);
    }

    private Expr opt(CompileContext cc) throws QueryException {
        Expr expr;
        ExprList cases = new ExprList();
        Item cnd = this.cond instanceof Value ? this.cond.atomItem(cc.qc, this.info) : null;
        ArrayList<SwitchGroup> tmpGroups = new ArrayList<SwitchGroup>();
        for (SwitchGroup group : this.groups) {
            int el = group.exprs.length;
            Expr rtrn = group.rtrn();
            ExprList list = (ExprList)((Object)new ExprList(el).add(rtrn));
            for (int e = 1; e < el; ++e) {
                Expr expr2 = group.exprs[e];
                if (cases.contains(expr2)) {
                    cc.info("remove % from %", expr2, this::description);
                    continue;
                }
                if (cnd != null) {
                    if (expr2 instanceof Value) {
                        Item cs = expr2.atomItem(cc.qc, this.info);
                        if (cnd == cs || cs != Empty.VALUE && cnd != Empty.VALUE && cnd.equiv(cs, null, this.info)) {
                            return rtrn;
                        }
                        cc.info("remove % from %", expr2, this::description);
                        continue;
                    }
                    cnd = null;
                }
                cases.add(expr2);
                list.add(expr2);
            }
            if (list.size() <= 1 && el != 1) continue;
            group.exprs = (Expr[])list.finish();
            tmpGroups.add(group);
        }
        for (int g = 0; g < tmpGroups.size(); ++g) {
            SwitchGroup group1 = g > 0 ? (SwitchGroup)tmpGroups.get(g - 1) : null;
            SwitchGroup group2 = (SwitchGroup)tmpGroups.get(g);
            if (g <= 0 || !group1.rtrn().equals(group2.rtrn())) continue;
            if (g + 1 == tmpGroups.size() && !group1.has(Flag.NDT)) {
                tmpGroups.set(g - 1, group2);
            } else {
                ExprList list = new ExprList(group1.exprs.length + group2.exprs.length - 1);
                ((ExprList)list.add(group1.exprs)).add(Arrays.copyOfRange(group2.exprs, 1, group2.exprs.length));
                tmpGroups.set(g - 1, new SwitchGroup(group1.info, (Expr[])list.finish()).optimize(cc));
            }
            tmpGroups.remove(g--);
        }
        if (tmpGroups.size() != this.groups.length) {
            this.groups = tmpGroups.toArray(new SwitchGroup[0]);
            cc.info("simplify %: %", this::description, this);
        }
        if ((expr = this.simplify()) == this) {
            expr = this.toIf(cc);
        }
        return expr;
    }

    private Expr simplify() {
        Expr expr = this.groups[0].rtrn();
        for (int g = this.groups.length - 1; g >= 1; --g) {
            if (expr.equals(this.groups[g].rtrn())) continue;
            return this;
        }
        return expr;
    }

    private Expr toIf(CompileContext cc) throws QueryException {
        if (this.groups.length != 2) {
            return this;
        }
        SeqType st = this.cond.seqType();
        boolean string = st.type.isStringOrUntyped();
        boolean dec = st.type.instanceOf(AtomType.DECIMAL);
        if (!st.one() || !string && !dec) {
            return this;
        }
        Expr[] exprs = this.groups[0].exprs;
        for (int e = exprs.length - 1; e >= 1; --e) {
            SeqType mt = exprs[e].seqType();
            if (mt.one() && (string && mt.type.isStringOrUntyped() || dec && mt.type.instanceOf(AtomType.DECIMAL))) continue;
            return this;
        }
        Expr list = List.get(cc, this.groups[0].info, Arrays.copyOfRange(exprs, 1, exprs.length));
        CmpG cmp = new CmpG(this.cond, list, CmpG.OpG.EQ, null, null, this.groups[0].info);
        return new If(this.info, cmp.optimize(cc), this.groups[0].rtrn(), this.groups[1].rtrn()).optimize(cc);
    }

    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        return this.expr(qc).iter(qc);
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.expr(qc).value(qc);
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        return this.expr(qc).item(qc, this.info);
    }

    private Expr expr(QueryContext qc) throws QueryException {
        Item item = this.cond.atomItem(qc, this.info);
        for (SwitchGroup group : this.groups) {
            if (!group.match(item, qc)) continue;
            return group.rtrn();
        }
        throw Util.notExpected();
    }

    @Override
    public boolean vacuous() {
        return ((Checks<SwitchGroup>)group -> group.rtrn().vacuous()).all((SwitchGroup[])this.groups);
    }

    @Override
    public boolean ddo() {
        return ((Checks<SwitchGroup>)group -> group.rtrn().ddo()).all((SwitchGroup[])this.groups);
    }

    @Override
    public boolean has(Flag ... flags) {
        for (SwitchGroup group : this.groups) {
            if (!group.has(flags)) continue;
            return true;
        }
        return this.cond.has(flags);
    }

    @Override
    public boolean inlineable(InlineContext ic) {
        for (SwitchGroup group : this.groups) {
            if (group.inlineable(ic)) continue;
            return false;
        }
        return this.cond.inlineable(ic);
    }

    @Override
    public VarUsage count(Var var) {
        VarUsage max = VarUsage.NEVER;
        VarUsage uses = VarUsage.NEVER;
        for (SwitchGroup cs : this.groups) {
            uses = uses.plus(cs.countCases(var));
            max = max.max(uses.plus(cs.count(var)));
        }
        return max.plus(this.cond.count(var));
    }

    @Override
    public Expr inline(InlineContext ic) throws QueryException {
        boolean changed = ic.inline(this.groups, true);
        Expr inlined = this.cond.inline(ic);
        if (inlined != null) {
            changed = true;
            this.cond = inlined;
        }
        return changed ? this.optimize(ic.cc) : null;
    }

    @Override
    public Expr typeCheck(TypeCheck tc, CompileContext cc) throws QueryException {
        boolean changed = false;
        for (SwitchGroup group : this.groups) {
            changed = group.typeCheck(tc, cc) != null;
        }
        return changed ? this.optimize(cc) : this;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new Switch(this.info, this.cond.copy(cc, vm), (SwitchGroup[])Arr.copyAll((CompileContext)cc, vm, (Expr[])this.groups)));
    }

    @Override
    public void markTailCalls(CompileContext cc) {
        for (SwitchGroup group : this.groups) {
            group.markTailCalls(cc);
        }
    }

    @Override
    public Data data() {
        ExprList list = new ExprList(this.groups.length);
        for (SwitchGroup group : this.groups) {
            list.add(group.rtrn());
        }
        return Switch.data((Expr[])list.finish());
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return this.cond.accept(visitor) && Switch.visitAll(visitor, this.groups);
    }

    @Override
    public int exprSize() {
        int size = 1;
        for (SwitchGroup group : this.groups) {
            size += ((Expr)group).exprSize();
        }
        return size;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Switch)) {
            return false;
        }
        Switch s = (Switch)obj;
        return this.cond.equals(s.cond) && Array.equals(this.groups, s.groups);
    }

    @Override
    public void plan(QueryPlan plan) {
        plan.add(plan.create(this, new Object[0]), new Object[]{this.cond, this.groups});
    }

    @Override
    public void plan(QueryString qs) {
        qs.token("switch").paren(this.cond).tokens(this.groups);
    }
}

