/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;

public abstract class Single
extends ParseExpr {
    public Expr expr;

    protected Single(InputInfo info, Expr expr, SeqType seqType) {
        super(info, seqType);
        this.expr = expr;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoUp(this.expr);
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        this.expr = this.expr.compile(cc);
        return this;
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        return this.expr instanceof Value ? cc.preEval(this) : this;
    }

    @Override
    public boolean has(Flag ... flags) {
        return this.expr.has(flags);
    }

    @Override
    public boolean inlineable(InlineContext ic) {
        return this.expr.inlineable(ic);
    }

    @Override
    public VarUsage count(Var var) {
        return this.expr.count(var);
    }

    @Override
    public Expr inline(InlineContext ic) throws QueryException {
        Expr inlined = this.expr.inline(ic);
        if (inlined == null) {
            return null;
        }
        this.expr = inlined;
        return this.optimize(ic.cc);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return this.expr.accept(visitor);
    }

    @Override
    public int exprSize() {
        return this.expr.exprSize() + 1;
    }

    final Expr simplifyForCast(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        SeqType est = this.expr.seqType();
        SeqType dst = this.seqType();
        if (est.occ.instanceOf(dst.occ)) {
            Type et = est.type;
            Type dt = dst.type;
            if (mode == CompileContext.Simplify.STRING && et.isStringOrUntyped() && dt.oneOf(AtomType.STRING, AtomType.UNTYPED_ATOMIC) || mode == CompileContext.Simplify.NUMBER && (et.isUntyped() && dt == AtomType.DOUBLE || et.instanceOf(AtomType.INT) && et.instanceOf(dt)) || mode == CompileContext.Simplify.DATA && et instanceof NodeType && dt == AtomType.UNTYPED_ATOMIC) {
                return cc.simplify(this, this.expr);
            }
        }
        return super.simplifyFor(mode, cc);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Single && this.expr.equals(((Single)obj).expr);
    }

    @Override
    public void plan(QueryPlan plan) {
        plan.add(plan.create(this, new Object[0]), this.expr);
    }
}

