/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Range
extends Arr {
    public Range(InputInfo info, Expr expr1, Expr expr2) {
        super(info, SeqType.INTEGER_ZM, expr1, expr2);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        this.simplifyAll(CompileContext.Simplify.NUMBER, cc);
        Expr expr = this.emptyExpr();
        if (expr == this) {
            if (this.allAreValues(false)) {
                return cc.preEval(this);
            }
            Expr expr1 = this.exprs[0];
            Expr expr2 = this.exprs[1];
            if (expr1.equals(expr2)) {
                if (expr1.seqType().instanceOf(SeqType.INTEGER_O)) {
                    expr = expr1;
                } else {
                    this.exprType.assign(Occ.EXACTLY_ONE);
                }
            }
        }
        return cc.replaceWith(this, expr);
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        long max;
        Item item1 = this.exprs[0].atomItem(qc, this.info);
        if (item1 == Empty.VALUE) {
            return Empty.VALUE;
        }
        Item item2 = this.exprs[1].atomItem(qc, this.info);
        if (item2 == Empty.VALUE) {
            return Empty.VALUE;
        }
        long min = this.toLong(item1);
        if (min > (max = this.toLong(item2))) {
            return Empty.VALUE;
        }
        long size = max - min + 1L;
        if (size > 0L) {
            return RangeSeq.get(min, size, true);
        }
        throw QueryError.RANGE_X.get(this.info, max);
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new Range(this.info, this.exprs[0].copy(cc, vm), this.exprs[1].copy(cc, vm)));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Range && super.equals(obj);
    }

    @Override
    public String description() {
        return "range expression";
    }

    @Override
    public void plan(QueryString qs) {
        qs.tokens(this.exprs, " to ", true);
    }
}

