/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Arith;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Calc;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.CmpPos;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ItrPos;
import org.basex.query.expr.Range;
import org.basex.query.func.Function;
import org.basex.query.util.Flag;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Pos
extends Arr
implements CmpPos {
    private Pos(InputInfo info, Expr min, Expr max) {
        super(info, SeqType.BOOLEAN_O, min, max);
    }

    static Expr get(Expr expr, CmpV.OpV op, InputInfo ii, CompileContext cc) throws QueryException {
        Expr min = null;
        Expr max = null;
        SeqType st2 = expr.seqType();
        if (expr.isSimple()) {
            if (expr instanceof Range && op == CmpV.OpV.EQ) {
                Range range = (Range)expr;
                Expr start = range.exprs[0];
                Expr end = range.exprs[1];
                if (st2.type.instanceOf(AtomType.INTEGER)) {
                    min = start;
                    max = start.equals(end) ? start : end;
                }
            } else if (st2.one() && !st2.mayBeArray()) {
                switch (op) {
                    case EQ: {
                        min = expr;
                        max = expr;
                        break;
                    }
                    case GE: {
                        min = expr;
                        max = Int.MAX;
                        break;
                    }
                    case GT: {
                        min = new Arith(ii, st2.type.instanceOf(AtomType.INTEGER) ? expr : cc.function(Function.FLOOR, ii, expr), (Expr)Int.ONE, Calc.PLUS).optimize(cc);
                        max = Int.MAX;
                        break;
                    }
                    case LE: {
                        min = Int.ONE;
                        max = expr;
                        break;
                    }
                    case LT: {
                        min = Int.ONE;
                        max = new Arith(ii, st2.type.instanceOf(AtomType.INTEGER) ? expr : cc.function(Function.CEILING, ii, expr), (Expr)Int.ONE, Calc.MINUS).optimize(cc);
                        break;
                    }
                }
            } else if (expr == Empty.VALUE) {
                return Bln.FALSE;
            }
        }
        return min != null ? new Pos(ii, min, max) : null;
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        this.simplifyAll(CompileContext.Simplify.NUMBER, cc);
        Expr expr1 = this.exprs[0];
        Expr expr2 = this.exprs[1];
        if (expr1 instanceof Int && expr2 instanceof Int) {
            return cc.replaceWith(this, ItrPos.get(((Int)expr1).itr(), ((Int)expr2).itr(), this.info));
        }
        return this;
    }

    @Override
    public Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        this.ctxValue(qc);
        return Bln.get(this.test(qc.focus.pos, qc) != 0);
    }

    @Override
    public Pos copy(CompileContext cc, IntObjMap<Var> vm) {
        Expr min = this.exprs[0].copy(cc, vm);
        Expr max = this.exact() ? min : this.exprs[1].copy(cc, vm);
        return this.copyType(new Pos(this.info, min, max));
    }

    @Override
    public Expr mergeEbv(Expr ex, boolean or, CompileContext cc) {
        if (or || !(ex instanceof Pos)) {
            return null;
        }
        Pos pos = (Pos)ex;
        Expr[] posExpr = pos.exprs;
        if (!this.exact() && !pos.exact()) {
            Expr max;
            Expr min;
            Expr expr1 = this.exprs[0];
            Expr expr2 = this.exprs[1];
            Expr expr = expr1 == Int.ONE ? posExpr[0] : (min = posExpr[0] == Int.ONE ? expr1 : null);
            Expr expr3 = expr2 == Int.MAX ? posExpr[1] : (max = posExpr[1] == Int.MAX ? expr2 : null);
            if (min != null && max != null) {
                return new Pos(this.info, min, max);
            }
        }
        return null;
    }

    @Override
    public Expr invert(CompileContext cc) throws QueryException {
        if (this.exprs[0].seqType().one()) {
            Expr pos = cc.function(Function.POSITION, this.info, new Expr[0]);
            Expr expr1 = this.exprs[0];
            Expr expr2 = this.exprs[1];
            if (this.exact()) {
                return new CmpG(pos, expr1, CmpG.OpG.NE, null, cc.sc(), this.info).optimize(cc);
            }
            if (expr1 == Int.ONE) {
                return new CmpG(pos, expr2, CmpG.OpG.GT, null, cc.sc(), this.info).optimize(cc);
            }
            if (expr2 == Int.MAX) {
                return new CmpG(pos, expr1, CmpG.OpG.LT, null, cc.sc(), this.info).optimize(cc);
            }
        }
        return this;
    }

    @Override
    public boolean exact() {
        return this.exprs[0] == this.exprs[1];
    }

    @Override
    public boolean simple() {
        return this.exprs[0].isSimple() && (this.exact() || this.exprs[1].isSimple());
    }

    @Override
    public int test(long pos, QueryContext qc) throws QueryException {
        double max;
        Item item1 = this.exprs[0].atomItem(qc, this.info);
        if (item1 == Empty.VALUE) {
            return 0;
        }
        double min = this.toDouble(item1);
        if (this.exact()) {
            max = min;
        } else {
            Item item2 = this.exprs[1].atomItem(qc, this.info);
            if (item2 == Empty.VALUE) {
                return 0;
            }
            max = this.toDouble(item2);
        }
        return (double)pos == max ? 2 : ((double)pos >= min && (double)pos <= max ? 1 : 0);
    }

    @Override
    public boolean has(Flag ... flags) {
        return Flag.POS.in(flags) || Flag.CTX.in(flags);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Pos && super.equals(obj);
    }

    @Override
    public String description() {
        return "positional access";
    }

    @Override
    public void plan(QueryPlan plan) {
        plan.add(plan.create(this, new Object[0]), this.exprs);
    }

    @Override
    public void plan(QueryString qs) {
        qs.function(Function.POSITION, new Object[0]).token("=").token(this.exprs[0]);
        if (!this.exact()) {
            qs.token("to").token(this.exprs[1]);
        }
    }
}

