/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.data.Data;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.ann.Annotation;
import org.basex.query.expr.Expr;
import org.basex.query.func.XQFunctionExpr;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.ExprType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public abstract class ParseExpr
extends Expr {
    public final ExprType exprType;
    public InputInfo info;

    protected ParseExpr(InputInfo info, SeqType seqType) {
        this.info = info;
        this.exprType = new ExprType(seqType);
    }

    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        return this.value(qc).iter();
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.item(qc, this.info);
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        return this.value(qc).item(qc, this.info);
    }

    @Override
    public final Value atomValue(QueryContext qc, InputInfo ii) throws QueryException {
        return this.value(qc).atomValue(qc, this.info);
    }

    @Override
    public final Item ebv(QueryContext qc, InputInfo ii) throws QueryException {
        Item next;
        if (this.seqType().zeroOrOne()) {
            Item item = this.item(qc, this.info);
            return item == Empty.VALUE ? Bln.FALSE : item;
        }
        Iter iter = this.iter(qc);
        Item item = iter.next();
        if (item == null) {
            return Bln.FALSE;
        }
        if (!(item instanceof ANode) && (next = iter.next()) != null) {
            ValueBuilder vb = new ValueBuilder(qc, item, next);
            if (iter.next() != null) {
                vb.add(Str.get("..."));
            }
            throw QueryError.EBV_X.get(this.info, vb.value());
        }
        return item;
    }

    @Override
    public final Item test(QueryContext qc, InputInfo ii) throws QueryException {
        Item item = this.ebv(qc, this.info);
        return (item instanceof ANum ? item.dbl(this.info) == (double)qc.focus.pos : item.bool(this.info)) ? item : null;
    }

    @Override
    public final SeqType seqType() {
        return this.exprType.seqType();
    }

    @Override
    public final long size() {
        return this.exprType.size();
    }

    @Override
    public final void refineType(Expr expr) {
        this.exprType.refine(expr);
        if (this.data() == null) {
            this.data(expr.data());
        }
    }

    public final <T extends Expr> T copyType(T expr) {
        expr.refineType(this);
        return expr;
    }

    public final ParseExpr adoptType(Expr expr) {
        this.exprType.assign(expr);
        if (this.data() == null) {
            this.data(expr.data());
        }
        return this;
    }

    static final Data data(Expr ... exprs) {
        Data data1 = null;
        for (Expr expr : exprs) {
            if (expr.seqType().zero()) continue;
            Data data2 = expr.data();
            if (data1 == null) {
                data1 = data2;
            }
            if (data1 != null && data1 == data2) continue;
            return null;
        }
        return data1;
    }

    protected final <T extends XQFunctionExpr> T checkUp(T expr, boolean updating, StaticContext sc) throws QueryException {
        if (!sc.mixUpdates && updating != expr.annotations().contains(Annotation.UPDATING)) {
            if (!updating) {
                throw QueryError.FUNCUP_X.get(this.info, expr);
            }
            if (!expr.vacuousBody()) {
                throw QueryError.FUNCNOTUP_X.get(this.info, expr);
            }
        }
        return expr;
    }

    protected final void checkNoUp(Expr expr) throws QueryException {
        if (expr == null) {
            return;
        }
        expr.checkUp();
        if (expr.has(Flag.UPD)) {
            throw QueryError.UPNOT_X.get(this.info, this.description());
        }
    }

    protected final void checkNoneUp(Expr ... exprs) throws QueryException {
        if (exprs == null) {
            return;
        }
        this.checkAllUp(exprs);
        for (Expr expr : exprs) {
            if (!expr.has(Flag.UPD)) continue;
            throw QueryError.UPNOT_X.get(this.info, this.description());
        }
    }

    protected final void checkAllUp(Expr ... exprs) throws QueryException {
        int state = 0;
        for (Expr expr : exprs) {
            expr.checkUp();
            if (expr.vacuous()) continue;
            boolean updating = expr.has(Flag.UPD);
            if (updating ? state == -1 : state == 1) {
                throw QueryError.UPALL.get(this.info, new Object[0]);
            }
            state = updating ? 1 : -1;
        }
    }

    protected final Value ctxValue(QueryContext qc) throws QueryException {
        Value value = qc.focus.value;
        if (value != null) {
            return value;
        }
        throw QueryError.NOCTX_X.get(this.info, this);
    }

    protected final byte[] toToken(Expr expr, QueryContext qc) throws QueryException {
        Item item = expr.atomItem(qc, this.info);
        if (item == Empty.VALUE) {
            throw QueryError.EMPTYFOUND_X.get(this.info, AtomType.STRING);
        }
        return this.toToken(item);
    }

    protected final byte[] toZeroToken(Expr expr, QueryContext qc) throws QueryException {
        Item item = expr.atomItem(qc, this.info);
        return item == Empty.VALUE ? Token.EMPTY : this.toToken(item);
    }

    protected final byte[] toTokenOrNull(Expr expr, QueryContext qc) throws QueryException {
        Item item = expr.atomItem(qc, this.info);
        return item != Empty.VALUE ? this.toToken(item) : null;
    }

    protected final byte[] toToken(Item item) throws QueryException {
        Type type = item.type;
        if (type.isStringOrUntyped()) {
            return item.string(this.info);
        }
        throw item instanceof FItem ? QueryError.FIATOM_X.get(this.info, item.type) : QueryError.typeError(item, AtomType.STRING, this.info);
    }

    protected final boolean toBoolean(Expr expr, QueryContext qc) throws QueryException {
        return this.toBoolean(expr.atomItem(qc, this.info));
    }

    protected final boolean toBoolean(Item item) throws QueryException {
        Type type = this.checkNoEmpty((Item)item, (Type)AtomType.BOOLEAN).type;
        if (type == AtomType.BOOLEAN) {
            return item.bool(this.info);
        }
        if (type.isUntyped()) {
            return Bln.parse(item, this.info);
        }
        throw QueryError.typeError(item, AtomType.BOOLEAN, this.info);
    }

    protected final double toDouble(Expr expr, QueryContext qc) throws QueryException {
        return this.toDouble(expr.atomItem(qc, this.info));
    }

    protected final double toDouble(Item item) throws QueryException {
        if (this.checkNoEmpty((Item)item, (Type)AtomType.DOUBLE).type.isNumberOrUntyped()) {
            return item.dbl(this.info);
        }
        throw QueryError.numberError(this, item);
    }

    protected final ANum toNumberOrNull(Expr expr, QueryContext qc) throws QueryException {
        Item item = expr.atomItem(qc, this.info);
        return item != Empty.VALUE ? this.toNumber(item) : null;
    }

    protected final ANum toNumber(Item item) throws QueryException {
        if (item.type.isUntyped()) {
            return Dbl.get(item.dbl(this.info));
        }
        if (item instanceof ANum) {
            return (ANum)item;
        }
        throw QueryError.numberError(this, item);
    }

    protected final float toFloat(Expr expr, QueryContext qc) throws QueryException {
        Item item = expr.atomItem(qc, this.info);
        if (this.checkNoEmpty((Item)item, (Type)AtomType.FLOAT).type.isNumberOrUntyped()) {
            return item.flt(this.info);
        }
        throw QueryError.numberError(this, item);
    }

    protected final long toLong(Expr expr, QueryContext qc) throws QueryException {
        return this.toLong(expr.atomItem(qc, this.info));
    }

    protected final long toLong(Item item) throws QueryException {
        Type type = this.checkNoEmpty((Item)item, (Type)AtomType.INTEGER).type;
        if (type.instanceOf(AtomType.INTEGER) || type.isUntyped()) {
            return item.itr(this.info);
        }
        throw QueryError.typeError(item, AtomType.INTEGER, this.info);
    }

    protected final ANode toNode(Expr expr, QueryContext qc) throws QueryException {
        return this.toNode(this.checkNoEmpty(expr.item(qc, this.info), NodeType.NODE));
    }

    protected final ANode toNodeOrNull(Expr expr, QueryContext qc) throws QueryException {
        Item item = expr.item(qc, this.info);
        return item == Empty.VALUE ? null : this.toNode(item);
    }

    protected final ANode toNode(Item item) throws QueryException {
        if (item instanceof ANode) {
            return (ANode)item;
        }
        throw QueryError.typeError(item, NodeType.NODE, this.info);
    }

    protected final Item toItem(Expr expr, QueryContext qc) throws QueryException {
        return this.checkNoEmpty(expr.item(qc, this.info));
    }

    protected final Item toItem(Expr expr, QueryContext qc, Type type) throws QueryException {
        return this.checkNoEmpty(expr.item(qc, this.info), type);
    }

    protected final Item toAtomItem(Expr expr, QueryContext qc) throws QueryException {
        return this.checkNoEmpty(expr.atomItem(qc, this.info));
    }

    protected final ANode toElem(Expr expr, QueryContext qc) throws QueryException {
        return (ANode)this.checkType(expr.item(qc, this.info), NodeType.ELEMENT);
    }

    protected final Bin toBin(Expr expr, QueryContext qc) throws QueryException {
        return this.toBin(expr.atomItem(qc, this.info));
    }

    protected final Bin toBin(Item item) throws QueryException {
        if (this.checkNoEmpty(item) instanceof Bin) {
            return (Bin)item;
        }
        throw QueryError.BINARY_X.get(this.info, item.type);
    }

    protected final byte[] toBytes(Expr expr, QueryContext qc) throws QueryException {
        return this.toBytes(expr.atomItem(qc, this.info));
    }

    protected final B64 toB64(Expr expr, QueryContext qc, boolean empty) throws QueryException {
        return this.toB64(expr.atomItem(qc, this.info), empty);
    }

    protected final B64 toB64(Item item, boolean empty) throws QueryException {
        if (empty && item == Empty.VALUE) {
            return null;
        }
        return (B64)this.checkType(item, AtomType.BASE64_BINARY);
    }

    protected final byte[] toBytes(Item item) throws QueryException {
        if (this.checkNoEmpty((Item)item).type.isStringOrUntyped()) {
            return item.string(this.info);
        }
        if (item instanceof Bin) {
            return ((Bin)item).binary(this.info);
        }
        throw QueryError.STRBIN_X_X.get(this.info, item.type, item);
    }

    protected final QNm toQNm(Expr expr, QueryContext qc, boolean empty) throws QueryException {
        return this.toQNm(expr.atomItem(qc, this.info), empty);
    }

    protected final QNm toQNm(Item item, boolean empty) throws QueryException {
        if (empty && item == Empty.VALUE) {
            return null;
        }
        Type type = this.checkNoEmpty((Item)item, (Type)AtomType.QNAME).type;
        if (type == AtomType.QNAME) {
            return (QNm)item;
        }
        if (type.isUntyped()) {
            throw QueryError.NSSENS_X_X.get(this.info, type, AtomType.QNAME);
        }
        throw QueryError.typeError(item, AtomType.QNAME, this.info);
    }

    protected final FItem toFunc(Expr expr, QueryContext qc) throws QueryException {
        return (FItem)this.checkType(this.toItem(expr, qc, SeqType.FUNCTION), SeqType.FUNCTION);
    }

    protected final XQMap toMap(Expr expr, QueryContext qc) throws QueryException {
        return this.toMap(this.toItem(expr, qc, SeqType.MAP));
    }

    protected final XQMap toMap(Item item) throws QueryException {
        if (item instanceof XQMap) {
            return (XQMap)item;
        }
        throw QueryError.typeError(item, SeqType.MAP, this.info);
    }

    protected final XQArray toArray(Expr expr, QueryContext qc) throws QueryException {
        return this.toArray(this.toItem(expr, qc, SeqType.ARRAY));
    }

    protected final XQArray toArray(Item item) throws QueryException {
        if (item instanceof XQArray) {
            return (XQArray)item;
        }
        throw QueryError.typeError(item, SeqType.ARRAY, this.info);
    }

    protected final Item checkType(Expr expr, QueryContext qc, AtomType type) throws QueryException {
        return this.checkType(expr.atomItem(qc, this.info), type);
    }

    protected final Item checkType(Item item, Type type) throws QueryException {
        if (this.checkNoEmpty((Item)item, (Type)type).type.instanceOf(type)) {
            return item;
        }
        throw QueryError.typeError(item, type, this.info);
    }

    protected final Item checkNoEmpty(Item item) throws QueryException {
        if (item != Empty.VALUE) {
            return item;
        }
        throw QueryError.EMPTYFOUND.get(this.info, new Object[0]);
    }

    protected final Item checkNoEmpty(Item item, Type type) throws QueryException {
        if (item != Empty.VALUE) {
            return item;
        }
        throw QueryError.EMPTYFOUND_X.get(this.info, type);
    }
}

