/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ItrPos;
import org.basex.query.expr.Range;
import org.basex.query.expr.Single;
import org.basex.query.func.Function;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class CmpIR
extends Single {
    public final long min;
    public final long max;
    private boolean single;

    private CmpIR(Expr expr, long min, long max, InputInfo info) {
        super(info, expr, SeqType.BOOLEAN_O);
        this.min = min;
        this.max = max;
    }

    private static Expr get(Expr expr, long min, long max, InputInfo info) {
        return min > max ? Bln.FALSE : (min == Long.MIN_VALUE && max == Long.MAX_VALUE ? Bln.TRUE : new CmpIR(expr, min, max, info));
    }

    public static Expr get(CmpG cmp, boolean eq, CompileContext cc) throws QueryException {
        long mx;
        long mn;
        Expr expr1 = cmp.exprs[0];
        Expr expr2 = cmp.exprs[1];
        if (cmp.has(Flag.NDT) || !expr1.seqType().type.instanceOf(AtomType.INTEGER)) {
            return cmp;
        }
        if (expr2 instanceof RangeSeq) {
            long[] range = ((RangeSeq)expr2).range(false);
            mn = range[0];
            mx = range[1];
        } else if (expr2 instanceof Int && (eq || cmp.op != CmpG.OpG.EQ)) {
            mx = mn = ((Int)expr2).itr();
        } else {
            return cmp;
        }
        switch (cmp.op) {
            case EQ: {
                break;
            }
            case GE: {
                mx = Long.MAX_VALUE;
                break;
            }
            case GT: {
                ++mn;
                mx = Long.MAX_VALUE;
                break;
            }
            case LE: {
                mn = Long.MIN_VALUE;
                break;
            }
            case LT: {
                mn = Long.MIN_VALUE;
                --mx;
                break;
            }
            default: {
                return cmp;
            }
        }
        return CmpIR.get(expr1, mn, mx, cmp.info).optimize(cc);
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        return super.compile(cc).optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        this.expr = this.expr.simplifyFor(CompileContext.Simplify.NUMBER, cc);
        SeqType st = this.expr.seqType();
        boolean bl = this.single = st.zeroOrOne() && !st.mayBeArray();
        if (this.expr instanceof Value) {
            return cc.preEval(this);
        }
        Expr ex = this;
        if (Function.POSITION.is(this.expr)) {
            long mn = Math.max(this.min, 1L);
            long mx = this.max - mn + 1L;
            ex = ItrPos.get(RangeSeq.get(mn, mx, true), CmpV.OpV.EQ, this.info);
        }
        return cc.replaceWith(this, ex);
    }

    @Override
    public Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        Item item;
        if (this.single) {
            Item item2 = this.expr.item(qc, this.info);
            return Bln.get(item2 != Empty.VALUE && this.inRange(item2.itr(this.info)));
        }
        if (this.expr instanceof Range || this.expr instanceof RangeSeq) {
            Value value = this.expr.value(qc);
            long size = value.size();
            if (size == 0L) {
                return Bln.FALSE;
            }
            if (size == 1L) {
                return Bln.get(this.inRange(((Item)value).itr(this.info)));
            }
            long[] range = ((RangeSeq)value).range(false);
            return Bln.get(range[1] >= this.min && range[0] <= this.max);
        }
        Iter iter = this.expr.atomIter(qc, this.info);
        while ((item = qc.next(iter)) != null) {
            if (!this.inRange(item.itr(this.info))) continue;
            return Bln.TRUE;
        }
        return Bln.FALSE;
    }

    private boolean inRange(long value) {
        return value >= this.min && value <= this.max;
    }

    @Override
    public Expr mergeEbv(Expr ex, boolean or, CompileContext cc) {
        if (!(ex instanceof CmpIR)) {
            return null;
        }
        CmpIR cmp = (CmpIR)ex;
        if (!this.expr.equals(cmp.expr)) {
            return null;
        }
        if (or && (this.max < cmp.min || cmp.max < this.min)) {
            return null;
        }
        long mn = or ? Math.min(this.min, cmp.min) : Math.max(this.min, cmp.min);
        long mx = or ? Math.max(this.max, cmp.max) : Math.min(this.max, cmp.max);
        return CmpIR.get(this.expr, mn, mx, this.info);
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        CmpIR cmp = new CmpIR(this.expr.copy(cc, vm), this.min, this.max, this.info);
        cmp.single = this.single;
        return this.copyType(cmp);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CmpIR)) {
            return false;
        }
        CmpIR c = (CmpIR)obj;
        return this.min == c.min && this.max == c.max && super.equals(obj);
    }

    @Override
    public String description() {
        return "integer range comparison";
    }

    @Override
    public void plan(QueryPlan plan) {
        plan.add(plan.create(this, "min", this.min, "max", this.max, "single", this.single), this.expr);
    }

    @Override
    public void plan(QueryString qs) {
        qs.token(this.expr);
        if (this.min == this.max) {
            qs.token("=").token(this.min);
        } else if (this.min != Long.MIN_VALUE && this.max != Long.MAX_VALUE) {
            qs.token("=").token(this.min).token("to").token(this.max);
        } else if (this.min != Long.MIN_VALUE) {
            qs.token(">=").token(this.min);
        } else {
            qs.token("<=").token(this.max);
        }
    }
}

