/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.util.Stack;
import org.basex.data.Data;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ExprInfo;
import org.basex.query.expr.ParseExpr;
import org.basex.query.scope.StaticDecl;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.Util;

public final class QueryPlan {
    private final FElem root;
    private final Stack<FElem> nodes = new Stack();
    private final boolean full;

    public QueryPlan(boolean compiled, boolean updating, boolean full) {
        this.root = new FElem("QueryPlan");
        this.root.add("compiled", Token.token(compiled));
        this.root.add("updating", Token.token(updating));
        this.nodes.add(this.root);
        this.full = full;
    }

    public FElem root() {
        return this.root;
    }

    public void add(FElem elem, Object ... children) {
        FElem plan = this.nodes.peek();
        plan.add(elem);
        this.nodes.add(elem);
        for (Object child : children) {
            if (child instanceof ExprInfo) {
                ((ExprInfo)child).plan(this);
                continue;
            }
            if (child instanceof ExprInfo[]) {
                for (ExprInfo ex : (ExprInfo[])child) {
                    if (ex == null) continue;
                    ex.plan(this);
                }
                continue;
            }
            if (child instanceof byte[]) {
                elem.add((byte[])child);
                continue;
            }
            if (child == null) continue;
            elem.add(child.toString());
        }
        this.nodes.pop();
    }

    public void add(FElem elem, ExprInfo ... children) {
        this.add(elem, (Object[])children);
    }

    public FElem create(ExprInfo expr, Object ... atts) {
        FElem elem = new FElem(Util.className(expr));
        int al = atts.length;
        for (int a = 0; a < al - 1; a += 2) {
            this.addAttribute(elem, atts[a], atts[a + 1]);
        }
        if (expr instanceof Expr) {
            Expr ex = (Expr)expr;
            this.attachType(elem, ex.seqType(), ex.size(), ex.data());
        } else if (expr instanceof StaticDecl) {
            this.attachType(elem, ((StaticDecl)expr).seqType(), -1L, null);
        }
        if (expr instanceof ParseExpr) {
            this.attachInputInfo(elem, ((ParseExpr)expr).info);
        }
        return elem;
    }

    public FElem create(String name, Var var) {
        FElem elem = new FElem(Strings.capitalize(name));
        if (var != null) {
            this.attachInputInfo(this.attachVariable(elem, var, true), var.info);
        }
        return elem;
    }

    public void addAttribute(FElem elem, Object name, Object value) {
        if (value != null) {
            elem.add(Util.inf(name, new Object[0]), Util.inf(value, new Object[0]));
        }
    }

    public void addElement(FElem elem, FElem child) {
        elem.add(child);
    }

    public FElem attachVariable(FElem elem, Var var, boolean type) {
        if (var != null) {
            this.addAttribute(elem, "name", var.toErrorString());
            this.addAttribute(elem, Token.ID, var.id);
            if (var.declType != null) {
                this.addAttribute(elem, "as", var.declType);
            }
            if (var.promote) {
                this.addAttribute(elem, "promote", true);
            }
            if (type) {
                this.attachType(elem, var.seqType(), var.size(), var.data());
            }
        }
        return elem;
    }

    private void attachType(FElem elem, SeqType seqType, long size, Data data) {
        this.addAttribute(elem, "type", seqType);
        if (size != -1L) {
            this.addAttribute(elem, "size", size);
        }
        if (data != null) {
            this.addAttribute(elem, "database", data.meta.name);
        }
    }

    private void attachInputInfo(FElem elem, InputInfo ii) {
        if (this.full) {
            this.addAttribute(elem, "line", ii.line());
            this.addAttribute(elem, "column", ii.column());
            this.addAttribute(elem, "path", ii.path());
        }
    }
}

