/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.basex.core.locks.Locking;
import org.basex.io.IO;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.ann.Ann;
import org.basex.query.ann.Annotation;
import org.basex.query.expr.And;
import org.basex.query.expr.Arith;
import org.basex.query.expr.BaseXPragma;
import org.basex.query.expr.CachedFilter;
import org.basex.query.expr.CachedMap;
import org.basex.query.expr.Calc;
import org.basex.query.expr.Cast;
import org.basex.query.expr.Castable;
import org.basex.query.expr.Catch;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.CmpN;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.ContextValue;
import org.basex.query.expr.DBPragma;
import org.basex.query.expr.Except;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Extension;
import org.basex.query.expr.If;
import org.basex.query.expr.Instance;
import org.basex.query.expr.Intersect;
import org.basex.query.expr.List;
import org.basex.query.expr.Lookup;
import org.basex.query.expr.Or;
import org.basex.query.expr.Pragma;
import org.basex.query.expr.Range;
import org.basex.query.expr.Switch;
import org.basex.query.expr.SwitchGroup;
import org.basex.query.expr.Treat;
import org.basex.query.expr.Try;
import org.basex.query.expr.TypeCheck;
import org.basex.query.expr.Typeswitch;
import org.basex.query.expr.TypeswitchGroup;
import org.basex.query.expr.Unary;
import org.basex.query.expr.Union;
import org.basex.query.expr.constr.CArray;
import org.basex.query.expr.constr.CAttr;
import org.basex.query.expr.constr.CComm;
import org.basex.query.expr.constr.CDoc;
import org.basex.query.expr.constr.CElem;
import org.basex.query.expr.constr.CMap;
import org.basex.query.expr.constr.CNSpace;
import org.basex.query.expr.constr.CPI;
import org.basex.query.expr.constr.CTxt;
import org.basex.query.expr.ft.FTAnd;
import org.basex.query.expr.ft.FTContains;
import org.basex.query.expr.ft.FTContent;
import org.basex.query.expr.ft.FTDistance;
import org.basex.query.expr.ft.FTExpr;
import org.basex.query.expr.ft.FTExtension;
import org.basex.query.expr.ft.FTMildNot;
import org.basex.query.expr.ft.FTNot;
import org.basex.query.expr.ft.FTOptions;
import org.basex.query.expr.ft.FTOr;
import org.basex.query.expr.ft.FTOrder;
import org.basex.query.expr.ft.FTScope;
import org.basex.query.expr.ft.FTWeight;
import org.basex.query.expr.ft.FTWindow;
import org.basex.query.expr.ft.FTWords;
import org.basex.query.expr.ft.ThesQuery;
import org.basex.query.expr.ft.Thesaurus;
import org.basex.query.expr.gflwor.Clause;
import org.basex.query.expr.gflwor.Condition;
import org.basex.query.expr.gflwor.Count;
import org.basex.query.expr.gflwor.For;
import org.basex.query.expr.gflwor.GFLWOR;
import org.basex.query.expr.gflwor.GroupBy;
import org.basex.query.expr.gflwor.GroupSpec;
import org.basex.query.expr.gflwor.Let;
import org.basex.query.expr.gflwor.OrderBy;
import org.basex.query.expr.gflwor.OrderKey;
import org.basex.query.expr.gflwor.Where;
import org.basex.query.expr.gflwor.Window;
import org.basex.query.expr.path.Axis;
import org.basex.query.expr.path.CachedStep;
import org.basex.query.expr.path.DocTest;
import org.basex.query.expr.path.KindTest;
import org.basex.query.expr.path.NamePart;
import org.basex.query.expr.path.NameTest;
import org.basex.query.expr.path.Path;
import org.basex.query.expr.path.Step;
import org.basex.query.expr.path.Test;
import org.basex.query.func.Closure;
import org.basex.query.func.DynFuncCall;
import org.basex.query.func.Function;
import org.basex.query.func.Functions;
import org.basex.query.func.PartFunc;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.StaticFunc;
import org.basex.query.func.fn.FnError;
import org.basex.query.scope.LibraryModule;
import org.basex.query.scope.MainModule;
import org.basex.query.up.expr.Delete;
import org.basex.query.up.expr.Insert;
import org.basex.query.up.expr.Rename;
import org.basex.query.up.expr.Replace;
import org.basex.query.up.expr.Transform;
import org.basex.query.up.expr.TransformWith;
import org.basex.query.util.Flag;
import org.basex.query.util.NSGlobal;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.format.DecFormatter;
import org.basex.query.util.list.AnnList;
import org.basex.query.util.list.ExprList;
import org.basex.query.util.list.ItemList;
import org.basex.query.util.parse.LocalVars;
import org.basex.query.util.parse.ModInfo;
import org.basex.query.util.parse.QNmCache;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Uri;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.ListType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.StaticVar;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarScope;
import org.basex.util.Array;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.InputParser;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.XMLToken;
import org.basex.util.ft.FTCase;
import org.basex.util.ft.FTContents;
import org.basex.util.ft.FTFlag;
import org.basex.util.ft.FTMode;
import org.basex.util.ft.FTOpt;
import org.basex.util.ft.FTUnit;
import org.basex.util.ft.Language;
import org.basex.util.ft.Stemmer;
import org.basex.util.ft.StopWords;
import org.basex.util.ft.Tokenizer;
import org.basex.util.hash.TokenMap;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.hash.TokenSet;
import org.basex.util.options.Option;

public class QueryParser
extends InputParser {
    private static final byte[] URICHECK;
    private static final byte[] SKIPCHECK;
    private static final TokenSet KEYWORDS;
    private static final byte[][] DECFORMATS;
    public final TokenSet modules = new TokenSet();
    public final TokenMap namespaces = new TokenMap();
    public final QueryContext qc;
    public final StaticContext sc;
    private final TokenSet imports = new TokenSet();
    private final ArrayList<ModInfo> mods = new ArrayList();
    private final TokenObjMap<StaticVar> vars = new TokenObjMap();
    private final TokenObjMap<StaticFunc> funcs = new TokenObjMap();
    private final TokenBuilder token = new TokenBuilder();
    private final StringBuilder currDoc = new StringBuilder();
    private String doc = "";
    private QueryError alter;
    private int alterPos;
    private final HashSet<String> decl = new HashSet();
    private final QNmCache qnames = new QNmCache();
    private final LocalVars localVars = new LocalVars(this);

    public QueryParser(String query, String uri, QueryContext qctx, StaticContext sctx) {
        super(query);
        this.qc = qctx;
        StaticContext staticContext = this.sc = sctx != null ? sctx : new StaticContext(qctx);
        if (uri != null) {
            this.sc.baseURI(uri);
        }
    }

    public final MainModule parseMain() throws QueryException {
        this.init();
        try {
            this.versionDecl();
            int p = this.pos;
            if (this.wsConsumeWs("module", "namespace", null)) {
                throw this.error(QueryError.MAINMOD, new Object[0]);
            }
            this.pos = p;
            this.prolog1();
            this.importModules();
            this.prolog2();
            this.localVars.pushContext(null);
            Expr ex = this.expr();
            if (ex == null) {
                throw this.alterError(QueryError.EXPREMPTY);
            }
            VarScope vs = this.localVars.popContext();
            MainModule mm = new MainModule(vs, ex, null, this.doc, null, this.funcs, this.vars, this.imports);
            this.finish(mm);
            this.check(mm);
            return mm;
        }
        catch (QueryException ex) {
            this.mark();
            ex.pos(this);
            throw ex;
        }
    }

    public final LibraryModule parseLibrary(boolean check) throws QueryException {
        this.init();
        try {
            this.versionDecl();
            this.wsCheck("module");
            this.wsCheck("namespace");
            this.skipWs();
            byte[] pref = this.ncName(QueryError.NONAME_X);
            this.wsCheck("=");
            byte[] uri = this.stringLiteral();
            if (uri.length == 0) {
                throw this.error(QueryError.NSMODURI, new Object[0]);
            }
            this.sc.module = new QNm(pref, uri);
            this.sc.ns.add(pref, uri, this.info());
            this.namespaces.put(pref, uri);
            this.wsCheck(";");
            IO baseO = this.sc.baseIO();
            byte[] path = Token.token(baseO == null ? "" : baseO.path());
            this.qc.modParsed.put(path, uri);
            this.qc.modStack.push(path);
            this.prolog1();
            this.importModules();
            this.prolog2();
            this.finish(null);
            if (check) {
                this.check(null);
            }
            this.qc.modStack.pop();
            return new LibraryModule(this.doc, this.funcs, this.vars, this.imports, this.sc);
        }
        catch (QueryException ex) {
            this.mark();
            ex.pos(this);
            throw ex;
        }
    }

    private void init() throws QueryException {
        int cp;
        boolean hs;
        IO baseIO = this.sc.baseIO();
        String string = this.file = baseIO == null ? null : baseIO.path();
        if (!this.more()) {
            throw this.error(QueryError.QUERYEMPTY, new Object[0]);
        }
        for (int p = 0; p < this.length; p += hs ? Character.charCount(cp) : 1) {
            cp = this.input.charAt(p);
            boolean bl = hs = cp >= 55296;
            if (hs) {
                cp = this.input.codePointAt(p);
            }
            if (XMLToken.valid(cp)) continue;
            this.pos = p;
            throw this.error(QueryError.MODLEINV_X, cp);
        }
    }

    private void finish(MainModule mm) throws QueryException {
        if (this.more()) {
            if (this.alter != null) {
                throw this.alterError(null);
            }
            String rest = this.remaining();
            ++this.pos;
            if (mm == null) {
                throw this.error(QueryError.MODEXPR, rest);
            }
            throw this.error(QueryError.QUERYEND_X, rest);
        }
        this.qnames.assignURI(this, 0);
        if (this.sc.elemNS != null) {
            this.sc.ns.add(Token.EMPTY, this.sc.elemNS, null);
        }
    }

    private void check(MainModule mm) throws QueryException {
        this.qc.funcs.check(this.qc);
        this.qc.vars.check();
        if (this.qc.updating && !this.sc.mixUpdates) {
            this.qc.funcs.checkUp();
            this.qc.vars.checkUp();
            if (mm != null) {
                mm.expr.checkUp();
            }
        }
    }

    private void versionDecl() throws QueryException {
        String ver;
        int p = this.pos;
        if (!this.wsConsumeWs("xquery")) {
            return;
        }
        boolean version = this.wsConsumeWs("version");
        if (version && !(ver = Token.string(this.stringLiteral())).equals("1.0") && !Strings.eq(ver, "1.1", "3.0", "3.1")) {
            throw this.error(QueryError.XQUERYVER_X, ver);
        }
        if (this.wsConsumeWs("encoding")) {
            String encoding = Token.string(this.stringLiteral());
            if (!Strings.supported(encoding)) {
                throw this.error(QueryError.XQUERYENC2_X, encoding);
            }
        } else if (!version) {
            this.pos = p;
            return;
        }
        this.wsCheck(";");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void prolog1() throws QueryException {
        while (true) {
            block12: {
                int p;
                block13: {
                    block20: {
                        block19: {
                            block18: {
                                block17: {
                                    block16: {
                                        block15: {
                                            block14: {
                                                p = this.pos;
                                                if (!this.wsConsumeWs("declare")) break block13;
                                                if (!this.wsConsumeWs("default")) break block14;
                                                if (!(this.defaultNamespaceDecl() || this.defaultCollationDecl() || this.emptyOrderDecl() || this.decimalFormatDecl(true))) {
                                                    throw this.error(QueryError.DECLINCOMPLETE, new Object[0]);
                                                }
                                                break block12;
                                            }
                                            if (!this.wsConsumeWs("boundary-space")) break block15;
                                            this.boundarySpaceDecl();
                                            break block12;
                                        }
                                        if (!this.wsConsumeWs("base-uri")) break block16;
                                        this.baseURIDecl();
                                        break block12;
                                    }
                                    if (!this.wsConsumeWs("construction")) break block17;
                                    this.constructionDecl();
                                    break block12;
                                }
                                if (!this.wsConsumeWs("ordering")) break block18;
                                this.orderingModeDecl();
                                break block12;
                            }
                            if (!this.wsConsumeWs("revalidation")) break block19;
                            this.revalidationDecl();
                            break block12;
                        }
                        if (!this.wsConsumeWs("copy-namespaces")) break block20;
                        this.copyNamespacesDecl();
                        break block12;
                    }
                    if (this.wsConsumeWs("decimal-format")) {
                        this.decimalFormatDecl(false);
                        break block12;
                    } else if (this.wsConsumeWs("namespace")) {
                        this.namespaceDecl();
                        break block12;
                    } else {
                        if (!this.wsConsumeWs("ft-option")) {
                            this.pos = p;
                            return;
                        }
                        FTOpt fto = new FTOpt();
                        while (this.ftMatchOption(fto)) {
                        }
                        this.qc.ftOpt().assign(fto);
                    }
                    break block12;
                }
                if (!this.wsConsumeWs("import")) {
                    return;
                }
                if (this.wsConsumeWs("schema")) {
                    this.schemaImport();
                } else {
                    if (!this.wsConsumeWs("module")) {
                        this.pos = p;
                        return;
                    }
                    this.moduleImport();
                }
            }
            this.currDoc.setLength(0);
            this.skipWs();
            this.check(';');
        }
    }

    private void prolog2() throws QueryException {
        while (true) {
            int p = this.pos;
            if (!this.wsConsumeWs("declare")) break;
            if (this.wsConsumeWs("context")) {
                this.contextItemDecl();
            } else if (this.wsConsumeWs("option")) {
                this.optionDecl();
            } else {
                if (this.wsConsumeWs("default")) {
                    throw this.error(QueryError.PROLOGORDER, new Object[0]);
                }
                AnnList anns = this.annotations(true);
                if (this.wsConsumeWs("variable")) {
                    if (anns.contains(Annotation.UPDATING)) {
                        throw this.error(QueryError.UPDATINGVAR, new Object[0]);
                    }
                    this.varDecl(anns.check(true, true));
                } else if (this.wsConsumeWs("function")) {
                    this.functionDecl(anns.check(false, true));
                } else {
                    if (!anns.isEmpty()) {
                        throw this.error(QueryError.VARFUNC, new Object[0]);
                    }
                    this.pos = p;
                    break;
                }
            }
            this.currDoc.setLength(0);
            this.skipWs();
            this.check(';');
        }
    }

    private AnnList annotations(boolean updating) throws QueryException {
        AnnList anns = new AnnList();
        while (true) {
            Ann ann;
            if (updating && this.wsConsumeWs("updating")) {
                ann = new Ann(this.info(), Annotation.UPDATING, new Item[0]);
            } else {
                if (!this.consume(37)) break;
                this.skipWs();
                InputInfo ii = this.info();
                QNm name = this.eQName(QueryError.QNAME_X, QueryText.XQ_URI);
                ItemList items = new ItemList();
                if (this.wsConsumeWs("(")) {
                    do {
                        Expr ex;
                        if (!((ex = this.literal()) instanceof Item)) {
                            if (Function.ERROR.is(ex)) {
                                ex.item(this.qc, ii);
                            }
                            throw this.error(QueryError.ANNVALUE, new Object[0]);
                        }
                        items.add((Item)ex);
                    } while (this.wsConsumeWs(","));
                    this.wsCheck(")");
                }
                this.skipWs();
                Annotation sig = Annotation.get(name);
                if (sig == null) {
                    byte[] uri = name.uri();
                    if (NSGlobal.prefix(uri).length != 0 && !Token.eq(uri, QueryText.LOCAL_URI, QueryText.ERROR_URI)) {
                        throw (NSGlobal.reserved(uri) ? QueryError.ANNWHICH_X_X : QueryError.BASEX_ANNOTATION1_X_X).get(ii, Character.valueOf('%'), name.string());
                    }
                    ann = new Ann(ii, name, (Item[])items.finish());
                } else {
                    if (sig.single && anns.contains(sig)) {
                        throw QueryError.BASEX_ANNOTATION3_X_X.get(ii, Character.valueOf('%'), sig.id());
                    }
                    long arity = items.size();
                    if (arity < (long)sig.minMax[0] || arity > (long)sig.minMax[1]) {
                        throw QueryError.BASEX_ANNOTATION2_X_X.get(ii, new Object[]{sig, QueryError.arguments(arity)});
                    }
                    int al = sig.args.length;
                    int a = 0;
                    while ((long)a < arity) {
                        Item item;
                        SeqType st = sig.args[Math.min(al - 1, a)];
                        if (!st.instance(item = (Item)items.get(a))) {
                            throw QueryError.BASEX_ANNOTATION_X_X_X.get(ii, new Object[]{sig, st, item.seqType()});
                        }
                        ++a;
                    }
                    ann = new Ann(ii, sig, (Item[])items.finish());
                }
            }
            anns.add(ann);
            if (ann.sig != Annotation.UPDATING) continue;
            this.qc.updating();
        }
        this.skipWs();
        return anns;
    }

    private void namespaceDecl() throws QueryException {
        byte[] pref = this.ncName(QueryError.NONAME_X);
        this.wsCheck("=");
        byte[] uri = this.stringLiteral();
        if (this.sc.ns.staticURI(pref) != null) {
            throw this.error(QueryError.DUPLNSDECL_X, new Object[]{pref});
        }
        this.sc.ns.add(pref, uri, this.info());
        this.namespaces.put(pref, uri);
    }

    private void revalidationDecl() throws QueryException {
        if (!this.decl.add("revalidation")) {
            throw this.error(QueryError.DUPLREVAL, new Object[0]);
        }
        if (this.wsConsumeWs("strict") || this.wsConsumeWs("lax")) {
            throw this.error(QueryError.NOREVAL, new Object[0]);
        }
        this.wsCheck("skip");
    }

    private void boundarySpaceDecl() throws QueryException {
        if (!this.decl.add("boundary-space")) {
            throw this.error(QueryError.DUPLBOUND, new Object[0]);
        }
        boolean spaces = this.wsConsumeWs("preserve");
        if (!spaces) {
            this.wsCheck("strip");
        }
        this.sc.spaces = spaces;
    }

    private boolean defaultNamespaceDecl() throws QueryException {
        boolean elem = this.wsConsumeWs("element");
        if (!elem && !this.wsConsumeWs("function")) {
            return false;
        }
        this.wsCheck("namespace");
        byte[] uri = this.stringLiteral();
        if (Token.eq(QueryText.XML_URI, uri)) {
            throw this.error(QueryError.BINDXMLURI_X_X, uri, Token.XML);
        }
        if (Token.eq(QueryText.XMLNS_URI, uri)) {
            throw this.error(QueryError.BINDXMLURI_X_X, uri, Token.XMLNS);
        }
        if (elem) {
            if (!this.decl.add("element")) {
                throw this.error(QueryError.DUPLNS, new Object[0]);
            }
            this.sc.elemNS = uri.length == 0 ? null : uri;
        } else {
            if (!this.decl.add("function")) {
                throw this.error(QueryError.DUPLNS, new Object[0]);
            }
            this.sc.funcNS = uri.length == 0 ? null : uri;
        }
        return true;
    }

    private void optionDecl() throws QueryException {
        this.skipWs();
        QNm qname = this.eQName(QueryError.QNAME_X, QueryText.XQ_URI);
        byte[] value = this.stringLiteral();
        String name = Token.string(qname.local());
        if (Token.eq(qname.uri(), QueryText.OUTPUT_URI)) {
            if (this.sc.module != null) {
                throw this.error(QueryError.OPTDECL_X, new Object[]{qname.string()});
            }
            SerializerOptions sopts = this.qc.serParams();
            if (!this.decl.add("S " + name)) {
                throw this.error(QueryError.OUTDUPL_X, name);
            }
            sopts.parse(name, value, this.sc, this.info());
        } else if (Token.eq(qname.uri(), QueryText.DB_URI)) {
            if (this.sc.module != null) {
                throw this.error(QueryError.BASEX_OPTIONS3_X, new Object[]{qname.local()});
            }
            this.qc.options.add(name, value, this);
        } else if (Token.eq(qname.uri(), QueryText.BASEX_URI)) {
            if (!name.equals("lock")) {
                throw this.error(QueryError.BASEX_OPTIONS1_X, name);
            }
            for (String lock : Locking.queryLocks(value)) {
                this.qc.locks.add(lock);
            }
        }
    }

    private void orderingModeDecl() throws QueryException {
        if (!this.decl.add("ordering")) {
            throw this.error(QueryError.DUPLORD, new Object[0]);
        }
        this.sc.ordered = this.wsConsumeWs("ordered");
        if (!this.sc.ordered) {
            this.wsCheck("unordered");
        }
    }

    private boolean emptyOrderDecl() throws QueryException {
        if (!this.wsConsumeWs("order")) {
            return false;
        }
        this.wsCheck("empty");
        if (!this.decl.add("empty")) {
            throw this.error(QueryError.DUPLORDEMP, new Object[0]);
        }
        this.sc.orderGreatest = this.wsConsumeWs("greatest");
        if (!this.sc.orderGreatest) {
            this.wsCheck("least");
        }
        return true;
    }

    private void copyNamespacesDecl() throws QueryException {
        if (!this.decl.add("copy-namespaces")) {
            throw this.error(QueryError.DUPLCOPYNS, new Object[0]);
        }
        this.sc.preserveNS = this.wsConsumeWs("preserve");
        if (!this.sc.preserveNS) {
            this.wsCheck("no-preserve");
        }
        this.wsCheck(",");
        this.sc.inheritNS = this.wsConsumeWs("inherit");
        if (!this.sc.inheritNS) {
            this.wsCheck("no-inherit");
        }
    }

    private boolean decimalFormatDecl(boolean def) throws QueryException {
        int n;
        QNm name;
        if (def && !this.wsConsumeWs("decimal-format")) {
            return false;
        }
        QNm qNm = name = def ? QNm.EMPTY : this.eQName(QueryError.QNAME_X, null);
        if (this.sc.decFormats.get(name.id()) != null) {
            throw this.error(QueryError.DECDUPL, new Object[0]);
        }
        TokenMap map = new TokenMap();
        block0: do {
            n = map.size();
            this.skipWs();
            byte[] prop = this.ncName(null);
            for (byte[] s : DECFORMATS) {
                if (!Token.eq(prop, s)) continue;
                if (map.get(s) != null) {
                    throw this.error(QueryError.DECDUPLPROP_X, new Object[]{s});
                }
                this.wsCheck("=");
                map.put(s, this.stringLiteral());
                continue block0;
            }
        } while (n != map.size());
        this.sc.decFormats.put(name.id(), new DecFormatter(map, this.info()));
        return true;
    }

    private boolean defaultCollationDecl() throws QueryException {
        if (!this.wsConsumeWs("collation")) {
            return false;
        }
        if (!this.decl.add("collation")) {
            throw this.error(QueryError.DUPLCOLL, new Object[0]);
        }
        this.sc.collation = Collation.get(this.stringLiteral(), this.qc, this.sc, this.info(), QueryError.WHICHDEFCOLL_X);
        return true;
    }

    private void baseURIDecl() throws QueryException {
        if (!this.decl.add("base-uri")) {
            throw this.error(QueryError.DUPLBASE, new Object[0]);
        }
        this.sc.baseURI(Token.string(this.stringLiteral()));
    }

    private void schemaImport() throws QueryException {
        byte[] pref = null;
        if (this.wsConsumeWs("namespace")) {
            pref = this.ncName(QueryError.NONAME_X);
            if (Token.eq(pref, Token.XML, Token.XMLNS)) {
                throw this.error(QueryError.BINDXML_X, new Object[]{pref});
            }
            this.wsCheck("=");
        } else if (this.wsConsumeWs("default")) {
            this.wsCheck("element");
            this.wsCheck("namespace");
        }
        byte[] ns = this.stringLiteral();
        if (pref != null && ns.length == 0) {
            throw this.error(QueryError.NSEMPTY, new Object[0]);
        }
        if (!Uri.uri(ns).isValid()) {
            throw this.error(QueryError.INVURI_X, new Object[]{ns});
        }
        if (this.wsConsumeWs("at")) {
            do {
                if (Uri.uri(ns = this.stringLiteral()).isValid()) continue;
                throw this.error(QueryError.INVURI_X, new Object[]{ns});
            } while (this.wsConsumeWs(","));
        }
        throw this.error(QueryError.IMPLSCHEMA, new Object[0]);
    }

    private void moduleImport() throws QueryException {
        byte[] uri;
        byte[] pref = Token.EMPTY;
        if (this.wsConsumeWs("namespace")) {
            pref = this.ncName(QueryError.NONAME_X);
            this.wsCheck("=");
        }
        if ((uri = Token.trim(this.stringLiteral())).length == 0) {
            throw this.error(QueryError.NSMODURI, new Object[0]);
        }
        if (!Uri.uri(uri).isValid()) {
            throw this.error(QueryError.INVURI_X, new Object[]{uri});
        }
        if (this.modules.contains(uri)) {
            throw this.error(QueryError.DUPLMODULE_X, new Object[]{uri});
        }
        this.modules.add(uri);
        if (pref != Token.EMPTY) {
            if (this.sc.ns.staticURI(pref) != null) {
                throw this.error(QueryError.DUPLNSDECL_X, new Object[]{pref});
            }
            this.sc.ns.add(pref, uri, this.info());
            this.namespaces.put(pref, uri);
        }
        ModInfo mi = new ModInfo();
        mi.info = this.info();
        mi.uri = uri;
        this.mods.add(mi);
        if (this.wsConsumeWs("at")) {
            do {
                mi.paths.add(this.stringLiteral());
            } while (this.wsConsumeWs(","));
        } else {
            byte[] path = this.qc.modDeclared.get(uri);
            if (path != null) {
                mi.paths.add(path);
            }
        }
    }

    private void importModules() throws QueryException {
        for (ModInfo mi : this.mods) {
            this.importModule(mi);
        }
    }

    private void importModule(ModInfo mi) throws QueryException {
        byte[] uri = mi.uri;
        if (mi.paths.isEmpty()) {
            if (Functions.staticURI(uri)) {
                return;
            }
            if (this.qc.resources.modules().addImport(Token.string(uri), this, mi.info)) {
                return;
            }
            throw QueryError.WHICHMOD_X.get(mi.info, new Object[]{uri});
        }
        for (byte[] path : mi.paths) {
            this.module(Token.string(path), Token.string(uri), mi.info);
        }
    }

    public final void module(String path, String uri, InputInfo ii) throws QueryException {
        String qu;
        IO io = this.sc.resolve(path, uri);
        byte[] tPath = Token.token(io.path());
        byte[] tUri = Token.token(uri);
        byte[] pUri = this.qc.modParsed.get(tPath);
        if (pUri != null) {
            if (!Token.eq(tUri, pUri)) {
                throw QueryError.WRONGMODULE_X_X_X.get(ii, io.name(), uri, pUri);
            }
            return;
        }
        this.qc.modParsed.put(tPath, tUri);
        this.imports.put(tUri);
        try {
            qu = Token.string(io.read());
        }
        catch (IOException ex) {
            Util.debug(ex);
            throw this.error(QueryError.WHICHMODFILE_X, io);
        }
        this.qc.modStack.push(tPath);
        QueryParser qp = new QueryParser(qu, io.path(), this.qc, null);
        LibraryModule lib = qp.parseLibrary(false);
        byte[] muri = lib.sc.module.uri();
        if (!uri.equals(Token.string(muri))) {
            throw QueryError.WRONGMODULE_X_X_X.get(ii, io.name(), uri, muri);
        }
        StaticContext sctx = qp.sc;
        if (sctx.contextType != null) {
            if (this.sc.contextType == null) {
                this.sc.contextType = sctx.contextType;
            } else if (!sctx.contextType.eq(this.sc.contextType)) {
                throw this.error(QueryError.CITYPES_X_X, sctx.contextType, this.sc.contextType);
            }
        }
        this.qc.modStack.pop();
    }

    private void contextItemDecl() throws QueryException {
        this.wsCheck("item");
        if (!this.decl.add("item")) {
            throw this.error(QueryError.DUPLITEM, new Object[0]);
        }
        if (this.wsConsumeWs("as")) {
            SeqType st = this.itemType();
            if (this.sc.contextType == null) {
                this.sc.contextType = st;
            } else if (!this.sc.contextType.eq(st)) {
                throw this.error(QueryError.CITYPES_X_X, this.sc.contextType, st);
            }
        }
        if (!this.wsConsumeWs("external")) {
            this.wsCheck(":=");
        } else if (!this.wsConsumeWs(":=")) {
            return;
        }
        this.localVars.pushContext(null);
        Expr ex = this.check(this.single(), QueryError.NOCIDECL);
        SeqType st = this.sc.contextType != null ? this.sc.contextType : SeqType.ITEM_O;
        VarScope vs = this.localVars.popContext();
        this.qc.ctxItem = MainModule.get(vs, ex, st, this.currDoc.toString(), this.info());
        if (this.sc.module != null) {
            throw this.error(QueryError.DECITEM, new Object[0]);
        }
        if (!this.sc.mixUpdates && ex.has(Flag.UPD)) {
            throw this.error(QueryError.UPCTX, ex);
        }
    }

    private void varDecl(AnnList anns) throws QueryException {
        Expr bind;
        Var var = this.newVar();
        if (this.sc.module != null && !Token.eq(var.name.uri(), this.sc.module.uri())) {
            throw this.error(QueryError.MODULENS_X, var);
        }
        this.localVars.pushContext(null);
        boolean ext = this.wsConsumeWs("external");
        if (ext) {
            bind = this.wsConsumeWs(":=") ? this.check(this.single(), QueryError.NOVARDECL) : null;
        } else {
            this.wsCheck(":=");
            bind = this.check(this.single(), QueryError.NOVARDECL);
        }
        VarScope vs = this.localVars.popContext();
        StaticVar sv = this.qc.vars.declare(var, anns, bind, ext, this.currDoc.toString(), vs);
        this.vars.put(sv.id(), sv);
    }

    private SeqType optAsType() throws QueryException {
        return this.wsConsumeWs("as") ? this.sequenceType() : null;
    }

    private void constructionDecl() throws QueryException {
        if (!this.decl.add("construction")) {
            throw this.error(QueryError.DUPLCONS, new Object[0]);
        }
        this.sc.strip = this.wsConsumeWs("strip");
        if (!this.sc.strip) {
            this.wsCheck("preserve");
        }
    }

    private void functionDecl(AnnList anns) throws QueryException {
        InputInfo ii = this.info();
        QNm name = this.eQName(QueryError.FUNCNAME, this.sc.funcNS);
        if (QueryParser.keyword(name)) {
            throw this.error(QueryError.RESERVED_X, new Object[]{name.local()});
        }
        this.wsCheck("(");
        if (this.sc.module != null && !Token.eq(name.uri(), this.sc.module.uri())) {
            throw this.error(QueryError.MODULENS_X, name);
        }
        this.localVars.pushContext(null);
        Var[] args = this.paramList();
        this.wsCheck(")");
        SeqType type = this.optAsType();
        Expr ex = this.wsConsumeWs("external") ? null : this.enclosedExpr();
        VarScope vs = this.localVars.popContext();
        String cd = this.currDoc.toString();
        StaticFunc func = this.qc.funcs.declare(anns, name, args, type, ex, cd, vs, ii);
        this.funcs.put(func.id(), func);
    }

    private static boolean keyword(QNm name) {
        return !name.hasPrefix() && KEYWORDS.contains(name.string());
    }

    private Var[] paramList() throws QueryException {
        Var[] params = new Var[]{};
        do {
            this.skipWs();
            if (this.curr() != '$' && params.length == 0) break;
            InputInfo ii = this.info();
            Var var = this.localVars.add(new Var(this.varName(), this.optAsType(), true, this.qc, this.sc, ii));
            for (Var param : params) {
                if (!param.name.eq(var.name)) continue;
                throw this.error(QueryError.FUNCDUPL_X, var);
            }
            params = Array.add(params, var);
        } while (this.consume(44));
        return params;
    }

    private Expr enclosedExpr() throws QueryException {
        this.wsCheck("{");
        Expr ex = this.expr();
        this.wsCheck("}");
        return ex == null ? Empty.VALUE : ex;
    }

    private Expr expr() throws QueryException {
        Expr ex = this.single();
        if (ex == null) {
            if (this.more()) {
                return null;
            }
            throw this.alterError(QueryError.NOEXPR);
        }
        if (!this.wsConsume(",")) {
            return ex;
        }
        ExprList el = new ExprList(ex);
        do {
            this.add(el, this.single());
        } while (this.wsConsume(","));
        return new List(this.info(), (Expr[])el.finish());
    }

    private Expr single() throws QueryException {
        this.alter = null;
        Expr ex = this.flwor();
        if (ex == null) {
            ex = this.quantified();
        }
        if (ex == null) {
            ex = this.switchh();
        }
        if (ex == null) {
            ex = this.typeswitch();
        }
        if (ex == null) {
            ex = this.iff();
        }
        if (ex == null) {
            ex = this.tryCatch();
        }
        if (ex == null) {
            ex = this.insert();
        }
        if (ex == null) {
            ex = this.delete();
        }
        if (ex == null) {
            ex = this.rename();
        }
        if (ex == null) {
            ex = this.replace();
        }
        if (ex == null) {
            ex = this.updatingFunctionCall();
        }
        if (ex == null) {
            ex = this.copyModify();
        }
        if (ex == null) {
            ex = this.ternaryIf();
        }
        return ex;
    }

    /*
     * Unable to fully structure code
     */
    private Expr flwor() throws QueryException {
        s = this.localVars.openScope();
        clauses = this.initialClause(null);
        if (clauses == null) {
            return null;
        }
        curr = new TokenObjMap<Var>();
        for (Clause fl : clauses) {
            for (Var var : fl.vars()) {
                curr.put(var.name.id(), var);
            }
        }
        do lbl-1000:
        // 3 sources

        {
            size = clauses.size();
            this.initialClause(clauses);
            for (Clause clause : clauses) {
                for (Var var : clause.vars()) {
                    curr.put(var.name.id(), var);
                }
            }
            if (size < clauses.size()) ** GOTO lbl-1000
            if (this.wsConsumeWs("where")) {
                this.alterPos = this.pos;
                clauses.add(new Where(this.check(this.single(), QueryError.NOWHERE), this.info()));
            }
            if (this.wsConsumeWs("group")) {
                this.wsCheck("by");
                this.skipWs();
                this.alterPos = this.pos;
                specs = this.groupSpecs(clauses);
                ng = new ArrayList<VarRef>();
                for (GroupSpec spec : specs) {
                    curr.put(spec.var.name.id(), spec.var);
                }
                block6: for (Var var : curr.values()) {
                    for (GroupSpec spec : specs) {
                        if (spec.var.is(var)) continue block6;
                    }
                    ng.add(new VarRef(specs[0].info, var));
                }
                ns = ng.size();
                ngrp = new Var[ns];
                i = ns;
                while (--i >= 0) {
                    ref = (VarRef)ng.get(i);
                    ngrp[i] = nv = this.localVars.add(new Var(ref.var.name, null, false, this.qc, this.sc, ref.var.info));
                    curr.put(nv.name.id(), nv);
                }
                clauses.add(new GroupBy(specs, ng.toArray(new VarRef[0]), ngrp, specs[0].info));
            }
            if (stable = this.wsConsumeWs("stable")) {
                this.wsCheck("order");
            }
            if (stable || this.wsConsumeWs("order")) {
                this.wsCheck("by");
                this.alterPos = this.pos;
                keys = null;
                do {
                    key = this.orderSpec();
                    if (keys == null) {
                        v0 = new OrderKey[1];
                        v1 = v0;
                        v0[0] = key;
                        continue;
                    }
                    v1 = keys = Array.add(keys, key);
                } while (this.wsConsume(","));
                vs = new VarRef[curr.size()];
                i = 0;
                for (Var var : curr.values()) {
                    vs[i++] = new VarRef(keys[0].info, var);
                }
                clauses.add(new OrderBy(vs, keys, keys[0].info));
            }
            if (!this.wsConsumeWs("count", "$", QueryError.NOCOUNT)) continue;
            var = this.localVars.add(this.newVar(SeqType.INTEGER_O));
            curr.put(var.name.id(), var);
            clauses.add(new Count(var));
        } while (size < clauses.size());
        if (!this.wsConsumeWs("return")) {
            throw this.alterError(QueryError.FLWORRETURN);
        }
        rtrn = this.check(this.single(), QueryError.NORETURN);
        this.localVars.closeScope(s);
        return new GFLWOR(clauses.peek().info, clauses, rtrn);
    }

    private LinkedList<Clause> initialClause(LinkedList<Clause> clauses) throws QueryException {
        LinkedList<Clause> cls = clauses;
        boolean slide = this.wsConsumeWs("for", "sliding", QueryError.NOWINDOW);
        if (slide || this.wsConsumeWs("for", "tumbling", QueryError.NOWINDOW)) {
            if (cls == null) {
                cls = new LinkedList();
            }
            cls.add(this.windowClause(slide));
        } else {
            boolean let;
            boolean bl = let = this.wsConsumeWs("let", "score", QueryError.NOLET) || this.wsConsumeWs("let", "$", QueryError.NOLET);
            if (let || this.wsConsumeWs("for", "$", QueryError.NOFOR)) {
                if (cls == null) {
                    cls = new LinkedList();
                }
                if (let) {
                    this.letClause(cls);
                } else {
                    this.forClause(cls);
                }
            }
        }
        return cls;
    }

    private void forClause(LinkedList<Clause> clauses) throws QueryException {
        do {
            Var score;
            Var var = this.newVar();
            boolean emp = this.wsConsume("allowing");
            if (emp) {
                this.wsCheck("empty");
            }
            Var at = this.wsConsumeWs("at") ? this.newVar(SeqType.INTEGER_O) : null;
            Var var2 = score = this.wsConsumeWs("score") ? this.newVar(SeqType.DOUBLE_O) : null;
            if (at != null) {
                if (var.name.eq(at.name)) {
                    throw this.error(QueryError.DUPLVAR_X, at);
                }
                if (score != null && at.name.eq(score.name)) {
                    throw this.error(QueryError.DUPLVAR_X, score);
                }
            }
            if (score != null && var.name.eq(score.name)) {
                throw this.error(QueryError.DUPLVAR_X, score);
            }
            this.wsCheck("in");
            Expr ex = this.check(this.single(), QueryError.NOVARDECL);
            clauses.add(new For(this.localVars.add(var), this.localVars.add(at), this.localVars.add(score), ex, emp));
        } while (this.wsConsumeWs(","));
    }

    private void letClause(LinkedList<Clause> clauses) throws QueryException {
        do {
            boolean score;
            Var var = (score = this.wsConsumeWs("score")) ? this.newVar(SeqType.DOUBLE_O) : this.newVar();
            this.wsCheck(":=");
            Expr ex = this.check(this.single(), QueryError.NOVARDECL);
            clauses.add(new Let(this.localVars.add(var), ex, score));
        } while (this.wsConsume(","));
    }

    private Window windowClause(boolean slide) throws QueryException {
        boolean check;
        this.wsCheck(slide ? "sliding" : "tumbling");
        this.wsCheck("window");
        this.skipWs();
        Var var = this.newVar();
        this.wsCheck("in");
        Expr ex = this.check(this.single(), QueryError.NOVARDECL);
        this.wsCheck("start");
        Condition start = this.windowCond(true);
        Condition end = null;
        boolean only = this.wsConsume("only");
        boolean bl = check = slide || only;
        if (check || this.wsConsume("end")) {
            if (check) {
                this.wsCheck("end");
            }
            end = this.windowCond(false);
        }
        return new Window(slide, this.localVars.add(var), ex, start, only, end);
    }

    private Condition windowCond(boolean start) throws QueryException {
        this.skipWs();
        InputInfo ii = this.info();
        Var var = this.curr(36) ? this.newVar(SeqType.ITEM_O) : null;
        Var at = this.wsConsumeWs("at") ? this.newVar(SeqType.INTEGER_O) : null;
        Var prv = this.wsConsumeWs("previous") ? this.newVar(SeqType.ITEM_ZO) : null;
        Var nxt = this.wsConsumeWs("next") ? this.newVar(SeqType.ITEM_ZO) : null;
        this.wsCheck("when");
        return new Condition(start, this.localVars.add(var), this.localVars.add(at), this.localVars.add(prv), this.localVars.add(nxt), this.check(this.single(), QueryError.NOEXPR), ii);
    }

    private OrderKey orderSpec() throws QueryException {
        boolean least;
        Expr ex = this.check(this.single(), QueryError.ORDERBY);
        boolean desc = false;
        if (!this.wsConsumeWs("ascending")) {
            desc = this.wsConsumeWs("descending");
        }
        boolean bl = least = !this.sc.orderGreatest;
        if (this.wsConsumeWs("empty")) {
            boolean bl2 = least = !this.wsConsumeWs("greatest");
            if (least) {
                this.wsCheck("least");
            }
        }
        Collation coll = this.wsConsumeWs("collation") ? Collation.get(this.stringLiteral(), this.qc, this.sc, this.info(), QueryError.FLWORCOLL_X) : this.sc.collation;
        return new OrderKey(this.info(), ex, desc, least, coll);
    }

    private GroupSpec[] groupSpecs(LinkedList<Clause> cl) throws QueryException {
        GroupSpec[] specs = null;
        do {
            Expr by;
            Var var = this.newVar();
            if (var.declType != null || this.wsConsume(":=")) {
                if (var.declType != null) {
                    this.wsCheck(":=");
                }
                by = this.check(this.single(), QueryError.NOVARDECL);
            } else {
                VarRef ref = this.localVars.resolveLocal(var.name, var.info);
                boolean dec = false;
                if (ref != null) {
                    for (Clause f : cl) {
                        if (!f.declares(ref.var)) continue;
                        dec = true;
                        break;
                    }
                    if (!dec && specs != null) {
                        for (Iterator iterator : specs) {
                            if (!((GroupSpec)((Object)iterator)).var.is(ref.var)) continue;
                            dec = true;
                            break;
                        }
                    }
                }
                if (!dec) {
                    throw this.error(QueryError.GVARNOTDEFINED_X, var);
                }
                by = ref;
            }
            Collation coll = this.wsConsumeWs("collation") ? Collation.get(this.stringLiteral(), this.qc, this.sc, this.info(), QueryError.FLWORCOLL_X) : this.sc.collation;
            GroupSpec spec = new GroupSpec(var.info, this.localVars.add(var), by, coll);
            if (specs == null) {
                specs = new GroupSpec[]{spec};
                continue;
            }
            int i = specs.length;
            while (--i >= 0) {
                if (!specs[i].var.name.eq(spec.var.name)) continue;
                specs[i].occluded = true;
                break;
            }
            specs = Array.add(specs, spec);
        } while (this.wsConsumeWs(","));
        return specs;
    }

    private Expr quantified() throws QueryException {
        boolean some = this.wsConsumeWs("some", "$", QueryError.NOSOME);
        if (!some && !this.wsConsumeWs("every", "$", QueryError.NOSOME)) {
            return null;
        }
        int s = this.localVars.openScope();
        LinkedList<Clause> clauses = new LinkedList<Clause>();
        do {
            Var var = this.newVar();
            this.wsCheck("in");
            Expr ex = this.check(this.single(), QueryError.NOSOME);
            clauses.add(new For(this.localVars.add(var), ex));
        } while (this.wsConsumeWs(","));
        this.wsCheck("satisfies");
        StandardFunc rtrn = Function.BOOLEAN.get(this.sc, this.info(), this.check(this.single(), QueryError.NOSOME));
        this.localVars.closeScope(s);
        InputInfo info = ((Clause)clauses.peek()).info;
        GFLWOR flwor = new GFLWOR(info, clauses, rtrn);
        CmpG cmp = new CmpG(flwor, (Expr)Bln.get(some), CmpG.OpG.EQ, null, this.sc, info);
        return some ? cmp : Function.NOT.get(this.sc, info, cmp);
    }

    private Expr switchh() throws QueryException {
        ExprList exprs;
        if (!this.wsConsumeWs("switch", "(", QueryError.TYPEPAR)) {
            return null;
        }
        InputInfo ii = this.info();
        this.wsCheck("(");
        Expr cond = this.check(this.expr(), QueryError.NOSWITCH);
        ArrayList<SwitchGroup> groups = new ArrayList<SwitchGroup>();
        this.wsCheck(")");
        do {
            exprs = new ExprList(null);
            while (this.wsConsumeWs("case")) {
                this.add(exprs, this.single());
            }
            if (exprs.size() == 1) {
                if (groups.isEmpty()) {
                    throw this.error(QueryError.WRONGCHAR_X_X, "case", this.found());
                }
                this.wsCheck("default");
            }
            this.wsCheck("return");
            exprs.set(0, this.check(this.single(), QueryError.NOSWITCH));
            groups.add(new SwitchGroup(this.info(), (Expr[])exprs.finish()));
        } while (exprs.size() != 1);
        return new Switch(ii, cond, groups.toArray(new SwitchGroup[0]));
    }

    private Expr typeswitch() throws QueryException {
        boolean cs;
        if (!this.wsConsumeWs("typeswitch", "(", QueryError.TYPEPAR)) {
            return null;
        }
        InputInfo ii = this.info();
        this.wsCheck("(");
        Expr ts = this.check(this.expr(), QueryError.NOTYPESWITCH);
        this.wsCheck(")");
        TypeswitchGroup[] cases = new TypeswitchGroup[]{};
        ArrayList<SeqType> types = new ArrayList<SeqType>();
        int s = this.localVars.openScope();
        do {
            if (!(cs = this.wsConsumeWs("case"))) {
                this.wsCheck("default");
                this.skipWs();
            }
            Var var = null;
            if (this.curr(36)) {
                var = this.localVars.add(this.newVar(SeqType.ITEM_ZM));
                if (cs) {
                    this.wsCheck("as");
                }
            }
            if (cs) {
                do {
                    types.add(this.sequenceType());
                } while (this.wsConsume("|"));
            }
            this.wsCheck("return");
            Expr rtrn = this.check(this.single(), QueryError.NOTYPESWITCH);
            SeqType[] st = types.toArray(new SeqType[0]);
            cases = Array.add(cases, new TypeswitchGroup(this.info(), var, st, rtrn));
            this.localVars.closeScope(s);
            types.clear();
        } while (cs);
        if (cases.length == 1) {
            throw this.error(QueryError.NOTYPESWITCH, new Object[0]);
        }
        return new Typeswitch(ii, ts, cases);
    }

    private Expr iff() throws QueryException {
        if (!this.wsConsumeWs("if", "(", QueryError.IFPAR)) {
            return null;
        }
        InputInfo ii = this.info();
        this.wsCheck("(");
        Expr iff = this.check(this.expr(), QueryError.NOIF);
        this.wsCheck(")");
        if (!this.wsConsumeWs("then")) {
            throw this.error(QueryError.NOIF, new Object[0]);
        }
        Expr thn = this.check(this.single(), QueryError.NOIF);
        Empty els = this.wsConsumeWs("else") ? this.check(this.single(), QueryError.NOIF) : Empty.VALUE;
        return new If(ii, iff, thn, (Expr)els);
    }

    private Expr ternaryIf() throws QueryException {
        Expr iff = this.elvis();
        if (!this.wsConsumeWs("??")) {
            return iff;
        }
        InputInfo ii = this.info();
        Expr thn = this.check(this.single(), QueryError.NOTERNARY);
        if (!this.wsConsumeWs("!!")) {
            throw this.error(QueryError.NOTERNARY, new Object[0]);
        }
        Expr els = this.check(this.single(), QueryError.NOTERNARY);
        return new If(ii, iff, thn, els);
    }

    private Expr elvis() throws QueryException {
        Expr ex = this.or();
        if (!this.wsConsumeWs("?:")) {
            return ex;
        }
        return Function._UTIL_OR.get(this.sc, this.info(), ex, this.check(this.single(), QueryError.NOELVIS));
    }

    private Expr or() throws QueryException {
        Expr ex = this.and();
        if (!this.wsConsumeWs("or")) {
            return ex;
        }
        InputInfo ii = this.info();
        ExprList el = (ExprList)((Object)new ExprList(2L).add(ex));
        do {
            this.add(el, this.and());
        } while (this.wsConsumeWs("or"));
        return new Or(ii, (Expr[])el.finish());
    }

    private Expr and() throws QueryException {
        Expr ex = this.update();
        if (!this.wsConsumeWs("and")) {
            return ex;
        }
        InputInfo ii = this.info();
        ExprList el = (ExprList)((Object)new ExprList(2L).add(ex));
        do {
            this.add(el, this.update());
        } while (this.wsConsumeWs("and"));
        return new And(ii, (Expr[])el.finish());
    }

    private Expr update() throws QueryException {
        Expr ex = this.comparison();
        if (ex != null) {
            while (this.wsConsumeWs("update")) {
                this.qc.updating();
                ex = new TransformWith(this.info(), ex, this.curr(123) ? this.enclosedExpr() : this.check(this.single(), QueryError.UPDATEEXPR));
            }
        }
        return ex;
    }

    private Expr comparison() throws QueryException {
        Expr ex = this.ftContains();
        if (ex != null) {
            for (CmpV.OpV opV : CmpV.OpV.VALUES) {
                if (!this.wsConsumeWs(opV.name)) continue;
                return new CmpV(ex, this.check(this.ftContains(), QueryError.CMPEXPR), opV, this.sc.collation, this.sc, this.info());
            }
            for (Enum enum_ : CmpN.OpN.VALUES) {
                if (!this.wsConsumeWs(((CmpN.OpN)enum_).name)) continue;
                return new CmpN(ex, this.check(this.ftContains(), QueryError.CMPEXPR), (CmpN.OpN)enum_, this.info());
            }
            for (Enum enum_ : CmpG.OpG.VALUES) {
                if (!this.wsConsumeWs(((CmpG.OpG)enum_).name)) continue;
                return new CmpG(ex, this.check(this.ftContains(), QueryError.CMPEXPR), (CmpG.OpG)enum_, this.sc.collation, this.sc, this.info());
            }
        }
        return ex;
    }

    private Expr ftContains() throws QueryException {
        Expr ex = this.stringConcat();
        int p = this.pos;
        if (!this.wsConsumeWs("contains") || !this.wsConsumeWs("text")) {
            this.pos = p;
            return ex;
        }
        FTExpr select = this.ftSelection(false);
        if (this.wsConsumeWs("without")) {
            this.wsCheck("content");
            this.union();
            throw this.error(QueryError.FTIGNORE, new Object[0]);
        }
        return new FTContains(ex, select, this.info());
    }

    private Expr stringConcat() throws QueryException {
        Expr ex = this.range();
        if (ex == null || !this.consume("||")) {
            return ex;
        }
        ExprList el = new ExprList(ex);
        do {
            this.add(el, this.range());
        } while (this.wsConsume("||"));
        return Function.CONCAT.get(this.sc, this.info(), (Expr[])el.finish());
    }

    private Expr range() throws QueryException {
        Expr ex = this.additive();
        if (!this.wsConsumeWs("to")) {
            return ex;
        }
        return new Range(this.info(), ex, this.check(this.additive(), QueryError.INCOMPLETE));
    }

    private Expr additive() throws QueryException {
        Expr ex = this.multiplicative();
        while (ex != null) {
            Calc c;
            Calc calc = this.consume(43) ? Calc.PLUS : (c = this.consume(45) ? Calc.MINUS : null);
            if (c == null) break;
            ex = new Arith(this.info(), ex, this.check(this.multiplicative(), QueryError.CALCEXPR), c);
        }
        return ex;
    }

    private Expr multiplicative() throws QueryException {
        Expr ex = this.union();
        while (ex != null) {
            Calc c;
            Calc calc = this.consume(42) ? Calc.MULT : (this.wsConsumeWs("div") ? Calc.DIV : (this.wsConsumeWs("idiv") ? Calc.IDIV : (c = this.wsConsumeWs("mod") ? Calc.MOD : null)));
            if (c == null) break;
            ex = new Arith(this.info(), ex, this.check(this.union(), QueryError.CALCEXPR), c);
        }
        return ex;
    }

    private Expr union() throws QueryException {
        Expr ex = this.intersect();
        if (ex == null || !this.isUnion()) {
            return ex;
        }
        ExprList el = new ExprList(ex);
        do {
            this.add(el, this.intersect());
        } while (this.isUnion());
        return new Union(this.info(), (Expr[])el.finish());
    }

    private boolean isUnion() throws QueryException {
        if (this.wsConsumeWs("union")) {
            return true;
        }
        int p = this.pos;
        if (this.consume("|") && !this.consume("|")) {
            return true;
        }
        this.pos = p;
        return false;
    }

    private Expr intersect() throws QueryException {
        boolean is;
        Expr ex = this.instanceoff();
        boolean lastIs = false;
        ExprList el = null;
        while ((is = this.wsConsumeWs("intersect")) || this.wsConsumeWs("except")) {
            if (is != lastIs && el != null) {
                ex = this.intersectExcept(lastIs, el);
                el = null;
            }
            lastIs = is;
            if (el == null) {
                el = new ExprList(ex);
            }
            this.add(el, this.instanceoff());
        }
        return el != null ? this.intersectExcept(lastIs, el) : ex;
    }

    private Expr intersectExcept(boolean intersect, ExprList el) {
        return intersect ? new Intersect(this.info(), (Expr[])el.finish()) : new Except(this.info(), (Expr[])el.finish());
    }

    private Expr instanceoff() throws QueryException {
        Expr ex = this.treat();
        if (!this.wsConsumeWs("instance")) {
            return ex;
        }
        this.wsCheck("of");
        return new Instance(this.info(), ex, this.sequenceType());
    }

    private Expr treat() throws QueryException {
        Expr ex = this.promote();
        if (!this.wsConsumeWs("treat")) {
            return ex;
        }
        this.wsCheck("as");
        return new Treat(this.sc, this.info(), ex, this.sequenceType());
    }

    private Expr promote() throws QueryException {
        Expr ex = this.castable();
        if (!this.wsConsumeWs("promote")) {
            return ex;
        }
        this.wsCheck("to");
        return new TypeCheck(this.sc, this.info(), ex, this.sequenceType(), true);
    }

    private Expr castable() throws QueryException {
        Expr ex = this.cast();
        if (!this.wsConsumeWs("castable")) {
            return ex;
        }
        this.wsCheck("as");
        return new Castable(this.sc, this.info(), ex, this.simpleType());
    }

    private Expr cast() throws QueryException {
        Expr ex = this.transformWith();
        if (!this.wsConsumeWs("cast")) {
            return ex;
        }
        this.wsCheck("as");
        return new Cast(this.sc, this.info(), ex, this.simpleType());
    }

    private Expr transformWith() throws QueryException {
        Expr ex = this.arrow();
        int p = this.pos;
        if (ex != null && this.wsConsume("transform") && this.wsConsume("with")) {
            this.qc.updating();
            return new TransformWith(this.info(), ex, this.enclosedExpr());
        }
        this.pos = p;
        return ex;
    }

    private Expr arrow() throws QueryException {
        Expr ex = this.unary();
        if (ex != null) {
            while (this.wsConsume("=>")) {
                InputInfo ii;
                Expr e;
                this.skipWs();
                if (this.curr(40)) {
                    e = this.parenthesized();
                } else if (this.curr(36)) {
                    ii = this.info();
                    e = this.localVars.resolve(this.varName(), ii);
                } else {
                    e = this.eQName(QueryError.ARROWSPEC, this.sc.funcNS);
                }
                ii = this.info();
                this.wsCheck("(");
                if (e instanceof QNm) {
                    QNm name = (QNm)e;
                    if (QueryParser.keyword(name)) {
                        throw this.error(QueryError.RESERVED_X, new Object[]{name.local()});
                    }
                    ex = this.functionCall(name, new ExprList(ex), ii);
                    continue;
                }
                ExprList argList = new ExprList(ex);
                int[] holes = this.argumentList(argList);
                Expr[] args = (Expr[])argList.finish();
                ex = holes == null ? new DynFuncCall(ii, this.sc, e, args) : new PartFunc(this.sc, ii, e, args, holes);
            }
        }
        return ex;
    }

    private Expr unary() throws QueryException {
        boolean minus = false;
        boolean found = false;
        while (true) {
            this.skipWs();
            if (this.consume(45)) {
                minus ^= true;
                found = true;
                continue;
            }
            if (!this.consume(43)) break;
            found = true;
        }
        Expr ex = this.value();
        return found ? new Unary(this.info(), this.check(ex, QueryError.EVALUNARY), minus) : ex;
    }

    private Expr value() throws QueryException {
        this.validate();
        Expr ex = this.extension();
        return ex == null ? this.map() : ex;
    }

    private void validate() throws QueryException {
        int p = this.pos;
        if (!this.wsConsumeWs("validate")) {
            return;
        }
        if (this.consume("type")) {
            InputInfo ii = this.info();
            this.qnames.add(this.eQName(QueryError.QNAME_X, SKIPCHECK), ii);
        }
        this.consume("strict");
        this.consume("lax");
        this.skipWs();
        if (this.curr(123)) {
            this.enclosedExpr();
            throw this.error(QueryError.IMPLVAL, new Object[0]);
        }
        this.pos = p;
    }

    private Expr extension() throws QueryException {
        Pragma[] pragmas = this.pragma();
        if (pragmas == null) {
            return null;
        }
        this.wsCheck("{");
        Expr ex = this.check(this.expr(), QueryError.NOPRAGMA);
        this.wsCheck("}");
        for (int p = pragmas.length - 1; p >= 0; --p) {
            ex = new Extension(this.info(), pragmas[p], ex);
        }
        return ex;
    }

    private Pragma[] pragma() throws QueryException {
        if (!this.wsConsumeWs("(#")) {
            return null;
        }
        ArrayList<Pragma> el = new ArrayList<Pragma>();
        do {
            QNm name = this.eQName(QueryError.QNAME_X, null);
            char ch = this.curr();
            if (ch != '#' && !Token.ws(ch)) {
                throw this.error(QueryError.PRAGMAINV, new Object[0]);
            }
            this.token.reset();
            while (ch != '#' || this.next() != ')') {
                if (ch == '\u0000') {
                    throw this.error(QueryError.PRAGMAINV, new Object[0]);
                }
                this.token.add(this.consume());
                ch = this.curr();
            }
            byte[] value = this.token.trim().toArray();
            if (Token.eq(name.prefix(), QueryText.DB_PREFIX)) {
                String key = Token.string(Token.uc(name.local()));
                Option<?> opt = this.qc.context.options.option(key);
                if (opt == null) {
                    throw this.error(QueryError.BASEX_OPTIONS1_X, key);
                }
                el.add(new DBPragma(name, opt, value));
            } else if (Token.eq(name.prefix(), QueryText.BASEX_PREFIX)) {
                el.add(new BaseXPragma(name, value));
            }
            this.pos += 2;
        } while (this.wsConsumeWs("(#"));
        return el.toArray(new Pragma[0]);
    }

    private Expr map() throws QueryException {
        char next;
        Expr ex = this.path();
        if (ex != null && (next = this.next()) != '=' && next != '!' && this.wsConsumeWs("!")) {
            ExprList el = new ExprList(ex);
            do {
                this.add(el, this.path());
            } while (this.next() != '=' && this.wsConsumeWs("!"));
            return new CachedMap(this.info(), (Expr[])el.finish());
        }
        return ex;
    }

    private Expr path() throws QueryException {
        ExprList el;
        this.checkInit();
        Expr root = null;
        if (this.consume(47)) {
            Expr ex;
            InputInfo ii = this.info();
            root = Function._UTIL_ROOT.get(this.sc, ii, new ContextValue(ii));
            el = new ExprList();
            if (this.consume(47)) {
                this.checkAxis(Axis.DESCENDANT);
                this.add(el, new CachedStep(this.info(), Axis.DESCENDANT_OR_SELF, KindTest.NOD, new Expr[0]));
                this.mark();
                ex = this.step(true);
            } else {
                this.checkAxis(Axis.CHILD);
                this.mark();
                ex = this.step(false);
                if (ex == null) {
                    return root;
                }
            }
            this.add(el, ex);
            this.relativePath(el);
        } else {
            this.mark();
            Expr ex = this.step(false);
            if (ex == null) {
                return null;
            }
            if (this.curr() != '/' && !(ex instanceof Step)) {
                return ex;
            }
            el = new ExprList();
            if (ex instanceof Step) {
                this.add(el, ex);
            } else {
                root = ex;
            }
            this.relativePath(el);
        }
        return Path.get(this.info(), root, (Expr[])el.finish());
    }

    private void relativePath(ExprList el) throws QueryException {
        while (true) {
            if (this.consume(47)) {
                if (this.consume(47)) {
                    this.add(el, new CachedStep(this.info(), Axis.DESCENDANT_OR_SELF, KindTest.NOD, new Expr[0]));
                    this.checkAxis(Axis.DESCENDANT);
                } else {
                    this.checkAxis(Axis.CHILD);
                }
            } else {
                return;
            }
            this.mark();
            this.add(el, this.step(true));
        }
    }

    void checkInit() {
    }

    void checkAxis(Axis axis) {
    }

    void checkTest(Test test, boolean element) {
    }

    void checkPred(boolean open) {
    }

    private Expr step(boolean error) throws QueryException {
        Expr ex = this.postfix();
        return ex != null ? ex : this.axisStep(error);
    }

    private Step axisStep(boolean error) throws QueryException {
        Axis axis = null;
        Test test = null;
        if (this.wsConsume("..")) {
            axis = Axis.PARENT;
            test = KindTest.NOD;
            this.checkTest(test, true);
        } else if (this.consume(64)) {
            axis = Axis.ATTRIBUTE;
            test = this.nodeTest(NodeType.ATTRIBUTE, true);
            this.checkTest(test, false);
            if (test == null) {
                --this.pos;
                throw this.error(QueryError.NOATTNAME, new Object[0]);
            }
        } else {
            for (Axis ax : Axis.VALUES) {
                int p = this.pos;
                if (!this.wsConsumeWs(ax.name)) continue;
                if (this.wsConsumeWs("::")) {
                    this.alterPos = this.pos;
                    axis = ax;
                    boolean element = ax != Axis.ATTRIBUTE;
                    test = this.nodeTest(element ? NodeType.ELEMENT : NodeType.ATTRIBUTE, true);
                    this.checkTest(test, element);
                    if (test != null) break;
                    throw this.error(QueryError.AXISMISS_X, new Object[]{axis});
                }
                this.pos = p;
            }
            if (axis == null) {
                axis = Axis.CHILD;
                test = this.nodeTest(NodeType.ELEMENT, true);
                if (test == KindTest.NSP) {
                    throw this.error(QueryError.NSAXIS, new Object[0]);
                }
                if (test != null && test.type == NodeType.ATTRIBUTE) {
                    axis = Axis.ATTRIBUTE;
                }
                this.checkTest(test, axis != Axis.ATTRIBUTE);
            }
            if (test == null) {
                if (error) {
                    throw this.error(QueryError.STEPMISS_X, new Object[]{this.found()});
                }
                return null;
            }
        }
        ExprList el = new ExprList();
        while (this.wsConsume("[")) {
            this.checkPred(true);
            this.add(el, this.expr());
            this.wsCheck("]");
            this.checkPred(false);
        }
        return new CachedStep(this.info(), axis, test, (Expr[])el.finish());
    }

    private Test nodeTest(NodeType type, boolean all) throws QueryException {
        int p = this.pos;
        if (this.consume(42)) {
            p = this.pos;
            if (this.consume(58) && !this.consume(42)) {
                return new NameTest(new QNm(this.ncName(QueryError.QNAME_X)), NamePart.LOCAL, type, this.sc.elemNS);
            }
            this.pos = p;
            return KindTest.get(type);
        }
        if (this.consume("Q{")) {
            byte[] uri = this.bracedURILiteral();
            if (this.consume(42)) {
                QNm name = new QNm(Token.COLON, uri);
                return new NameTest(name, NamePart.URI, type, this.sc.elemNS);
            }
        }
        this.pos = p;
        InputInfo ii = this.info();
        QNm name = this.eQName(null, SKIPCHECK);
        if (name != null) {
            p = this.pos;
            if (all && this.wsConsumeWs("(")) {
                NodeType nt = NodeType.find(name);
                if (nt != null) {
                    Test test = this.kindTest(nt);
                    return test == null ? KindTest.get(nt) : test;
                }
            } else {
                this.pos = p;
                if (!name.hasPrefix() && this.consume(":*")) {
                    name = new QNm(Token.concat(name.string(), Token.COLON));
                    this.qnames.add(name, type == NodeType.ELEMENT, ii);
                    return new NameTest(name, NamePart.URI, type, this.sc.elemNS);
                }
                this.qnames.add(name, type == NodeType.ELEMENT, ii);
                return new NameTest(name, NamePart.FULL, type, this.sc.elemNS);
            }
        }
        this.pos = p;
        return null;
    }

    private Expr postfix() throws QueryException {
        Expr ex = this.primary();
        if (ex != null) {
            Expr old;
            do {
                old = ex;
                if (this.wsConsume("[")) {
                    ExprList el = new ExprList();
                    do {
                        this.add(el, this.expr());
                        this.wsCheck("]");
                    } while (this.wsConsume("["));
                    ex = new CachedFilter(this.info(), ex, (Expr[])el.finish());
                    continue;
                }
                if (this.consume("(")) {
                    InputInfo ii = this.info();
                    ExprList argList = new ExprList();
                    int[] holes = this.argumentList(argList);
                    Expr[] args = (Expr[])argList.finish();
                    ex = holes == null ? new DynFuncCall(ii, this.sc, ex, args) : new PartFunc(this.sc, ii, ex, args, holes);
                    continue;
                }
                int p = this.pos;
                if (this.consume("?") && !this.consume("?") && !this.consume(58)) {
                    ex = new Lookup(this.info(), ex, this.keySpecifier());
                    continue;
                }
                this.pos = p;
            } while (ex != old);
        }
        return ex;
    }

    private Expr primary() throws QueryException {
        this.skipWs();
        char ch = this.curr();
        if (ch == '$') {
            InputInfo ii = this.info();
            return this.localVars.resolve(this.varName(), ii);
        }
        if (ch == '(' && this.next() != '#') {
            return this.parenthesized();
        }
        if (ch == '<') {
            return this.dirConstructor();
        }
        if (ch == '`') {
            return this.stringConstructor();
        }
        Expr ex = this.functionItem();
        if (ex != null) {
            return ex;
        }
        ex = this.functionCall();
        if (ex != null) {
            return ex;
        }
        ex = this.compConstructor();
        if (ex != null) {
            return ex;
        }
        int p = this.pos;
        if (this.wsConsumeWs("ordered") || this.wsConsumeWs("unordered")) {
            if (this.curr(123)) {
                return this.enclosedExpr();
            }
            this.pos = p;
        }
        if (this.wsConsumeWs("map", "{", QueryError.INCOMPLETE)) {
            return new CMap(this.info(), this.keyValues());
        }
        if (this.wsConsumeWs("[")) {
            return new CArray(this.info(), true, this.values());
        }
        if (this.wsConsumeWs("array", "{", QueryError.INCOMPLETE)) {
            this.wsCheck("{");
            Expr exp = this.expr();
            this.wsCheck("}");
            return exp == null ? new CArray(this.info(), false, new Expr[0]) : new CArray(this.info(), false, exp);
        }
        p = this.pos;
        if (this.consume("?")) {
            if (!this.wsConsume(",") && !this.consume(")")) {
                InputInfo info = this.info();
                return new Lookup(info, new ContextValue(info), this.keySpecifier());
            }
            this.pos = p;
        }
        if (ch == '.') {
            if (this.next() == '.') {
                return null;
            }
            if (!Token.digit(this.next())) {
                this.consume();
                return new ContextValue(this.info());
            }
        }
        return this.literal();
    }

    private Expr keySpecifier() throws QueryException {
        this.skipWs();
        char ch = this.curr();
        if (ch == '*') {
            this.consume();
            return Lookup.WILDCARD;
        }
        if (ch == '(') {
            return this.parenthesized();
        }
        Expr num = this.numericLiteral(ch);
        if (num != null) {
            if (Function.ERROR.is(num) || num instanceof Int) {
                return num;
            }
            throw this.error(QueryError.NUMBERITR_X_X, num.seqType(), num);
        }
        return Str.get(this.ncName(QueryError.KEYSPEC));
    }

    private Expr[] keyValues() throws QueryException {
        this.wsCheck("{");
        ExprList el = new ExprList();
        if (!this.wsConsume("}")) {
            do {
                this.add(el, this.check(this.single(), QueryError.INVMAPKEY));
                if (!this.wsConsume(":")) {
                    throw this.error(QueryError.WRONGCHAR_X_X, ":", this.found());
                }
                this.add(el, this.check(this.single(), QueryError.INVMAPVAL));
            } while (this.wsConsume(","));
            this.wsCheck("}");
        }
        return (Expr[])el.finish();
    }

    private Expr[] values() throws QueryException {
        ExprList el = new ExprList();
        if (!this.wsConsume("]")) {
            do {
                this.add(el, this.check(this.single(), QueryError.INVMAPVAL));
            } while (this.wsConsume(","));
            this.wsCheck("]");
        }
        return (Expr[])el.finish();
    }

    private Expr functionItem() throws QueryException {
        this.skipWs();
        int p = this.pos;
        AnnList anns = this.annotations(false).check(false, true);
        if (this.wsConsume("function") && this.wsConsume("(")) {
            if (anns.contains(Annotation.PRIVATE) || anns.contains(Annotation.PUBLIC)) {
                throw this.error(QueryError.NOVISALLOWED, new Object[0]);
            }
            HashMap<Var, Expr> global = new HashMap<Var, Expr>();
            this.localVars.pushContext(global);
            Var[] params = this.paramList();
            this.wsCheck(")");
            SeqType type = this.optAsType();
            Expr body = this.enclosedExpr();
            VarScope vs = this.localVars.popContext();
            return new Closure(this.info(), type, params, body, anns, global, vs);
        }
        if (!anns.isEmpty()) {
            throw this.error(QueryError.NOANN, new Object[0]);
        }
        this.pos = p;
        QNm name = this.eQName(null, this.sc.funcNS);
        if (name != null && this.wsConsumeWs("#")) {
            if (QueryParser.keyword(name)) {
                throw this.error(QueryError.RESERVED_X, new Object[]{name.local()});
            }
            char ch = this.curr();
            Expr num = this.numericLiteral(ch);
            if (Function.ERROR.is(num)) {
                return num;
            }
            if (!(num instanceof Int)) {
                Object[] objectArray = new Object[1];
                objectArray[0] = num == null ? (ch == '\u0000' ? "" : Character.valueOf(ch)) : this.token;
                throw this.error(QueryError.ARITY_X, objectArray);
            }
            long a = ((Int)num).itr();
            if (a > Integer.MAX_VALUE) {
                return FnError.get(QueryError.RANGE_X.get(this.info(), num), SeqType.ITEM_ZM, this.sc);
            }
            int arity = (int)a;
            Expr ex = Functions.getLiteral(name, arity, this.qc, this.sc, this.info(), false);
            return ex != null ? ex : this.undeclaredLiteral(name, arity, this.info());
        }
        this.pos = p;
        return null;
    }

    private Closure undeclaredLiteral(QNm name, int arity, InputInfo ii) throws QueryException {
        Closure ex = Closure.undeclaredLiteral(name, arity, this.qc, this.sc, ii);
        this.qc.funcs.registerFuncLiteral(ex);
        return ex;
    }

    private Expr literal() throws QueryException {
        char ch = this.curr();
        Expr num = this.numericLiteral(ch);
        return num != null ? num : (QueryParser.quote(ch) ? Str.get(this.stringLiteral()) : null);
    }

    private Expr numericLiteral(char ch) throws QueryException {
        if (!Token.digit(ch) && ch != '.') {
            return null;
        }
        this.token.reset();
        while (Token.digit(this.curr())) {
            this.token.add(this.consume());
        }
        boolean dec = this.consume(46);
        if (dec) {
            this.token.add(46);
            if (Token.digit(this.curr())) {
                do {
                    this.token.add(this.consume());
                } while (Token.digit(this.curr()));
            } else if (this.token.size() == 1) {
                throw this.error(QueryError.NUMBER_X, this.token);
            }
        }
        if (XMLToken.isNCStartChar(this.curr())) {
            if (!this.consume(101) && !this.consume(69)) {
                throw this.error(QueryError.NUMBERWS_X, this.token);
            }
            this.token.add(101);
            if (this.curr(43) || this.curr(45)) {
                this.token.add(this.consume());
            }
            if (!Token.digit(this.curr())) {
                throw this.error(QueryError.NUMBER_X, this.token);
            }
            do {
                this.token.add(this.consume());
            } while (Token.digit(this.curr()));
            if (XMLToken.isNCStartChar(this.curr())) {
                throw this.error(QueryError.NUMBERWS_X, this.token);
            }
            return Dbl.get(this.token.toArray(), this.info());
        }
        if (dec) {
            return Dec.get(new BigDecimal(Token.string(this.token.toArray())));
        }
        if (this.token.isEmpty()) {
            throw this.error(QueryError.NUMBER_X, this.token);
        }
        long l = Token.toLong(this.token.toArray());
        return l != Long.MIN_VALUE ? Int.get(l) : FnError.get(QueryError.RANGE_X.get(this.info(), new Object[]{QueryError.normalize(this.token, null)}), SeqType.INTEGER_O, this.sc);
    }

    private byte[] stringLiteral() throws QueryException {
        this.skipWs();
        char del = this.curr();
        if (!QueryParser.quote(del)) {
            throw this.error(QueryError.NOQUOTE_X, new Object[]{this.found()});
        }
        this.consume();
        this.token.reset();
        while (true) {
            if (!this.consume(del)) {
                if (!this.more()) {
                    throw this.error(QueryError.NOQUOTE_X, new Object[]{this.found()});
                }
                this.entity(this.token);
                continue;
            }
            if (!this.consume(del)) break;
            this.token.add(del);
        }
        return this.token.toArray();
    }

    private byte[] bracedURILiteral() throws QueryException {
        int p = this.pos;
        this.token.reset();
        while (!this.consume(125)) {
            if (!this.more() || this.curr() == '{') {
                throw this.error(QueryError.WRONGCHAR_X_X, "}", this.found());
            }
            this.entity(this.token);
        }
        byte[] ns = Token.normalize(this.token.toArray());
        if (Token.eq(ns, QueryText.XMLNS_URI)) {
            this.pos = p;
            throw this.error(QueryError.ILLEGALEQNAME_X, this.info(), new Object[]{ns});
        }
        return ns;
    }

    private QNm varName() throws QueryException {
        this.check('$');
        this.skipWs();
        return this.eQName(QueryError.NOVARNAME, null);
    }

    private Var newVar() throws QueryException {
        return this.newVar(null);
    }

    private Var newVar(SeqType type) throws QueryException {
        InputInfo ii = this.info();
        QNm name = this.varName();
        SeqType st = type != null ? type : this.optAsType();
        return new Var(name, st, false, this.qc, this.sc, ii);
    }

    private Expr parenthesized() throws QueryException {
        this.check('(');
        Expr ex = this.expr();
        this.wsCheck(")");
        return ex == null ? Empty.VALUE : ex;
    }

    private Expr functionCall() throws QueryException {
        int p = this.pos;
        QNm name = this.eQName(null, this.sc.funcNS);
        if (name != null && !QueryParser.keyword(name)) {
            Expr ex;
            InputInfo ii = this.info();
            if (this.wsConsume("(") && (ex = this.functionCall(name, new ExprList(), ii)) != null) {
                return ex;
            }
        }
        this.pos = p;
        return null;
    }

    private Expr functionCall(QNm name, ExprList argList, InputInfo ii) throws QueryException {
        int[] holes = this.argumentList(argList);
        Expr[] args = (Expr[])argList.finish();
        if (holes == null) {
            return Functions.get(name, args, this.qc, this.sc, ii);
        }
        int arity = args.length + holes.length;
        Expr func = Functions.getLiteral(name, arity, this.qc, this.sc, ii, false);
        Expr ex = func != null ? func : this.undeclaredLiteral(name, arity, ii);
        return new PartFunc(this.sc, ii, ex, args, holes);
    }

    private int[] argumentList(ExprList args) throws QueryException {
        int[] holes = null;
        if (!this.wsConsume(")")) {
            int i = args.size();
            do {
                Expr ex;
                if ((ex = this.single()) != null) {
                    args.add(ex);
                } else if (this.wsConsume("?")) {
                    int[] nArray;
                    if (holes == null) {
                        int[] nArray2 = new int[1];
                        nArray = nArray2;
                        nArray2[0] = i;
                    } else {
                        nArray = Array.add(holes, i);
                    }
                    holes = nArray;
                } else {
                    throw this.error(QueryError.FUNCARG_X, new Object[]{this.found()});
                }
                ++i;
            } while (this.wsConsume(","));
            if (!this.wsConsume(")")) {
                throw this.error(QueryError.FUNCARG_X, new Object[]{this.found()});
            }
        }
        return holes;
    }

    private Expr stringConstructor() throws QueryException {
        this.check('`');
        this.check('`');
        this.check('[');
        ExprList el = new ExprList();
        TokenBuilder tb = new TokenBuilder();
        while (this.more()) {
            int p = this.pos;
            if (this.consume(93) && this.consume(96) && this.consume(96)) {
                if (!tb.isEmpty()) {
                    el.add(Str.get(tb.next()));
                }
                return el.size() == 1 ? (Expr)el.get(0) : Function.CONCAT.get(this.sc, this.info(), (Expr[])el.finish());
            }
            this.pos = p;
            if (this.consume(96) && this.consume(123)) {
                Expr ex;
                if (!tb.isEmpty()) {
                    el.add(Str.get(tb.next()));
                }
                if ((ex = this.expr()) != null) {
                    el.add(Function.STRING_JOIN.get(this.sc, this.info(), ex, Str.get(" ")));
                }
                this.skipWs();
                this.check('}');
                this.check('`');
                continue;
            }
            this.pos = p;
            tb.add(this.consume());
        }
        throw this.error(QueryError.INCOMPLETE, new Object[0]);
    }

    private Expr dirConstructor() throws QueryException {
        this.check('<');
        return this.consume(33) ? this.dirComment() : (this.consume(63) ? this.dirPI() : this.dirElement());
    }

    private Expr dirElement() throws QueryException {
        byte[] atn;
        int size = this.sc.ns.size();
        byte[] nse = this.sc.elemNS;
        int npos = this.qnames.size();
        InputInfo ii = this.info();
        QNm name = new QNm(this.qName(QueryError.ELEMNAME_X));
        this.qnames.add(name, ii);
        this.consumeWS();
        Atts ns = new Atts();
        ExprList cont = new ExprList();
        boolean xmlDecl = false;
        ArrayList<QNm> atts = null;
        while ((atn = this.qName(null)).length != 0) {
            boolean pr;
            ExprList attv = new ExprList();
            this.consumeWS();
            this.check('=');
            this.consumeWS();
            char delim = this.consume();
            if (!QueryParser.quote(delim)) {
                throw this.error(QueryError.NOQUOTE_X, new Object[]{this.found()});
            }
            TokenBuilder tb = new TokenBuilder();
            boolean simple = true;
            while (true) {
                if (!this.consume(delim)) {
                    char ch = this.curr();
                    switch (ch) {
                        case '{': {
                            if (this.next() == '{') {
                                tb.add(this.consume());
                                this.consume();
                                break;
                            }
                            byte[] text = tb.next();
                            if (text.length == 0) {
                                this.add(attv, this.enclosedExpr());
                                simple = false;
                                break;
                            }
                            this.add(attv, Str.get(text));
                            break;
                        }
                        case '}': {
                            this.consume();
                            this.check('}');
                            tb.add(125);
                            break;
                        }
                        case '\u0000': 
                        case '<': {
                            throw this.error(QueryError.NOQUOTE_X, new Object[]{this.found()});
                        }
                        case '\t': 
                        case '\n': {
                            tb.add(32);
                            this.consume();
                            break;
                        }
                        case '\r': {
                            if (this.next() != '\n') {
                                tb.add(32);
                            }
                            this.consume();
                            break;
                        }
                        default: {
                            this.entity(tb);
                        }
                    }
                    continue;
                }
                if (!this.consume(delim)) break;
                tb.add(delim);
            }
            if (!tb.isEmpty()) {
                this.add(attv, Str.get(tb.finish()));
            }
            if ((pr = Token.startsWith(atn, Token.XMLNS_COLON)) || Token.eq(atn, Token.XMLNS)) {
                byte[] uri;
                if (!simple) {
                    throw this.error(QueryError.NSCONS, new Object[0]);
                }
                byte[] pref = pr ? Token.local(atn) : Token.EMPTY;
                byte[] byArray = uri = attv.isEmpty() ? Token.EMPTY : ((Str)attv.get(0)).string();
                if (Token.eq(pref, Token.XML) && Token.eq(uri, QueryText.XML_URI)) {
                    if (xmlDecl) {
                        throw this.error(QueryError.DUPLNSDEF_X, new Object[]{Token.XML});
                    }
                    xmlDecl = true;
                } else {
                    if (!Uri.uri(uri).isValid()) {
                        throw this.error(QueryError.INVURI_X, new Object[]{uri});
                    }
                    if (pr) {
                        if (uri.length == 0) {
                            throw this.error(QueryError.NSEMPTYURI, new Object[0]);
                        }
                        if (Token.eq(pref, Token.XML, Token.XMLNS)) {
                            throw this.error(QueryError.BINDXML_X, new Object[]{pref});
                        }
                        if (Token.eq(uri, QueryText.XML_URI)) {
                            throw this.error(QueryError.BINDXMLURI_X_X, uri, Token.XML);
                        }
                        if (Token.eq(uri, QueryText.XMLNS_URI)) {
                            throw this.error(QueryError.BINDXMLURI_X_X, uri, Token.XMLNS);
                        }
                        this.sc.ns.add(pref, uri);
                    } else {
                        if (Token.eq(uri, QueryText.XML_URI)) {
                            throw this.error(QueryError.XMLNSDEF_X, new Object[]{uri});
                        }
                        this.sc.elemNS = uri;
                    }
                    if (ns.contains(pref)) {
                        throw this.error(QueryError.DUPLNSDEF_X, new Object[]{pref});
                    }
                    ns.add(pref, uri);
                }
            } else {
                QNm attn = new QNm(atn);
                if (atts == null) {
                    atts = new ArrayList<QNm>(1);
                }
                atts.add(attn);
                this.qnames.add(attn, false, this.info());
                this.add(cont, new CAttr(this.sc, this.info(), false, (Expr)attn, (Expr[])attv.finish()));
            }
            if (this.consumeWS()) continue;
            break;
        }
        if (this.consume(47)) {
            this.check('>');
        } else {
            this.check('>');
            while (this.curr() != '<' || this.next() != '/') {
                Expr ex = this.dirElemContent(name.string());
                if (ex == null) continue;
                this.add(cont, ex);
            }
            this.pos += 2;
            byte[] close = this.qName(QueryError.ELEMNAME_X);
            this.consumeWS();
            this.check('>');
            if (!Token.eq(name.string(), close)) {
                throw this.error(QueryError.TAGWRONG_X_X, name.string(), close);
            }
        }
        this.qnames.assignURI(this, npos);
        if (atts != null) {
            int as = atts.size();
            for (int a = 0; a < as - 1; ++a) {
                for (int b = a + 1; b < as; ++b) {
                    if (!((QNm)atts.get(a)).eq((QNm)atts.get(b))) continue;
                    throw this.error(QueryError.ATTDUPL_X, atts.get(a));
                }
            }
        }
        this.sc.ns.size(size);
        this.sc.elemNS = nse;
        return new CElem(this.sc, this.info(), false, (Expr)name, ns, (Expr[])cont.finish());
    }

    private Expr dirElemContent(byte[] name) throws QueryException {
        TokenBuilder tb = new TokenBuilder();
        boolean strip = true;
        while (true) {
            char ch;
            if ((ch = this.curr()) == '<') {
                if (this.wsConsume("<![CDATA[")) {
                    tb.add(this.cDataSection());
                    strip = false;
                    continue;
                }
                Str txt = this.text(tb, strip);
                return txt != null ? txt : (this.next() == '/' ? null : this.dirConstructor());
            }
            if (ch == '{') {
                if (this.next() == '{') {
                    tb.add(this.consume());
                    this.consume();
                    continue;
                }
                Str txt = this.text(tb, strip);
                return txt != null ? txt : this.enclosedExpr();
            }
            if (ch == '}') {
                this.consume();
                this.check('}');
                tb.add(125);
                continue;
            }
            if (ch == '\u0000') break;
            strip &= !this.entity(tb);
        }
        throw this.error(QueryError.NOCLOSING_X, new Object[]{name});
    }

    private Str text(TokenBuilder tb, boolean strip) {
        byte[] text = tb.toArray();
        return text.length == 0 || strip && !this.sc.spaces && Token.ws(text) ? null : Str.get(text);
    }

    private Expr dirComment() throws QueryException {
        this.check('-');
        this.check('-');
        TokenBuilder tb = new TokenBuilder();
        while (true) {
            char ch;
            if ((ch = this.consumeContent()) == '-' && this.consume(45)) {
                this.check('>');
                return new CComm(this.sc, this.info(), false, (Expr)Str.get(tb.finish()));
            }
            tb.add(ch);
        }
    }

    private Expr dirPI() throws QueryException {
        byte[] str = this.ncName(QueryError.INVALPI);
        if (Token.eq(Token.lc(str), Token.XML)) {
            throw this.error(QueryError.PIXML_X, new Object[]{str});
        }
        boolean space = this.skipWs();
        TokenBuilder tb = new TokenBuilder();
        char ch;
        while ((ch = this.consumeContent()) != '?' || !this.consume(62)) {
            if (!space) {
                throw this.error(QueryError.PIWRONG, new Object[0]);
            }
            tb.add(ch);
        }
        return new CPI(this.sc, this.info(), false, (Expr)Str.get(str), (Expr)Str.get(tb.finish()));
    }

    private byte[] cDataSection() throws QueryException {
        TokenBuilder tb = new TokenBuilder();
        while (true) {
            char ch;
            if ((ch = this.consumeContent()) == ']' && this.curr(93) && this.next() == '>') {
                this.pos += 2;
                return tb.finish();
            }
            tb.add(ch);
        }
    }

    private Expr compConstructor() throws QueryException {
        int p = this.pos;
        if (this.wsConsumeWs("document")) {
            return this.consume(this.compDoc(), p);
        }
        if (this.wsConsumeWs("element")) {
            return this.consume(this.compElement(), p);
        }
        if (this.wsConsumeWs("attribute")) {
            return this.consume(this.compAttribute(), p);
        }
        if (this.wsConsumeWs("namespace")) {
            return this.consume(this.compNamespace(), p);
        }
        if (this.wsConsumeWs("text")) {
            return this.consume(this.compText(), p);
        }
        if (this.wsConsumeWs("comment")) {
            return this.consume(this.compComment(), p);
        }
        if (this.wsConsumeWs("processing-instruction")) {
            return this.consume(this.compPI(), p);
        }
        return null;
    }

    private Expr consume(Expr expr, int p) {
        if (expr == null) {
            this.pos = p;
        }
        return expr;
    }

    private Expr compDoc() throws QueryException {
        return this.curr(123) ? new CDoc(this.sc, this.info(), false, this.enclosedExpr()) : null;
    }

    private Expr compElement() throws QueryException {
        Expr name;
        this.skipWs();
        InputInfo ii = this.info();
        QNm qn = this.eQName(null, SKIPCHECK);
        if (qn != null) {
            name = qn;
            this.qnames.add(qn, ii);
        } else {
            if (!this.wsConsume("{")) {
                return null;
            }
            name = this.check(this.expr(), QueryError.NOELEMNAME);
            this.wsCheck("}");
        }
        this.skipWs();
        return this.curr(123) ? new CElem(this.sc, this.info(), true, name, new Atts(), this.enclosedExpr()) : null;
    }

    private Expr compAttribute() throws QueryException {
        Expr name;
        this.skipWs();
        InputInfo ii = this.info();
        QNm qn = this.eQName(null, SKIPCHECK);
        if (qn != null) {
            name = qn;
            this.qnames.add(qn, false, ii);
        } else {
            if (!this.wsConsume("{")) {
                return null;
            }
            name = this.check(this.expr(), QueryError.NOATTNAME);
            this.wsCheck("}");
        }
        this.skipWs();
        return this.curr(123) ? new CAttr(this.sc, this.info(), true, name, this.enclosedExpr()) : null;
    }

    private Expr compNamespace() throws QueryException {
        Expr name;
        this.skipWs();
        byte[] str = this.ncName(null);
        if (str.length == 0) {
            if (!this.curr(123)) {
                return null;
            }
            name = this.enclosedExpr();
        } else {
            name = Str.get(str);
        }
        this.skipWs();
        return this.curr(123) ? new CNSpace(this.sc, this.info(), true, name, this.enclosedExpr()) : null;
    }

    private Expr compText() throws QueryException {
        return this.curr(123) ? new CTxt(this.sc, this.info(), true, this.enclosedExpr()) : null;
    }

    private Expr compComment() throws QueryException {
        return this.curr(123) ? new CComm(this.sc, this.info(), true, this.enclosedExpr()) : null;
    }

    private Expr compPI() throws QueryException {
        Expr name;
        this.skipWs();
        byte[] str = this.ncName(null);
        if (str.length == 0) {
            if (!this.wsConsume("{")) {
                return null;
            }
            name = this.check(this.expr(), QueryError.PIWRONG);
            this.wsCheck("}");
        } else {
            name = Str.get(str);
        }
        this.skipWs();
        return this.curr(123) ? new CPI(this.sc, this.info(), true, name, this.enclosedExpr()) : null;
    }

    private SeqType simpleType() throws QueryException {
        this.skipWs();
        QNm name = this.eQName(QueryError.TYPEINVALID, this.sc.elemNS);
        Enum type = ListType.find(name);
        if (type == null) {
            type = AtomType.find(name, false);
            if (this.consume("(")) {
                throw this.error(QueryError.SIMPLETYPE_X, new Object[]{name.prefixId(Token.XML)});
            }
            if (type == null ? name.eq(AtomType.ANY_SIMPLE_TYPE.qname()) : type.oneOf(AtomType.ANY_ATOMIC_TYPE, AtomType.NOTATION)) {
                throw this.error(QueryError.INVALIDCAST_X, new Object[]{name.prefixId(Token.XML)});
            }
            if (type == null) {
                throw this.error(QueryError.WHICHCAST_X, new Object[]{AtomType.similar(name)});
            }
        }
        this.skipWs();
        return SeqType.get((Type)((Object)type), this.consume(63) ? Occ.ZERO_OR_ONE : Occ.EXACTLY_ONE);
    }

    private SeqType sequenceType() throws QueryException {
        if (this.wsConsumeWs("empty-sequence", "(", null)) {
            this.wsCheck("(");
            this.wsCheck(")");
            return SeqType.EMPTY_SEQUENCE_Z;
        }
        SeqType st = this.itemType();
        this.skipWs();
        Occ occ = this.consume(63) ? Occ.ZERO_OR_ONE : (this.consume(43) ? Occ.ONE_OR_MORE : (this.consume(42) ? Occ.ZERO_OR_MORE : Occ.EXACTLY_ONE));
        this.skipWs();
        return st.with(occ);
    }

    private SeqType itemType() throws QueryException {
        this.skipWs();
        if (this.consume("(")) {
            SeqType type = this.itemType();
            this.wsCheck(")");
            return type;
        }
        AnnList anns = this.annotations(false).check(false, false);
        QNm name = this.eQName(QueryError.TYPEINVALID, null);
        this.skipWs();
        boolean func = this.curr(40);
        Type type = null;
        if (func) {
            this.consume("(");
            if (name.eq(AtomType.ITEM.qname())) {
                type = AtomType.ITEM;
            }
            if (type == null) {
                type = NodeType.find(name);
            }
            if (type == null && (type = FuncType.find(name)) != null) {
                return this.functionTest(anns, type).seqType();
            }
            if (type == null) {
                throw this.error(QueryError.WHICHTYPE_X, new Object[]{name.prefixId(Token.XML)});
            }
        } else {
            if (!name.hasURI()) {
                name.uri(this.sc.elemNS);
            }
            if ((type = AtomType.find(name, false)) == null) {
                throw this.error(QueryError.TYPEUNKNOWN_X, new Object[]{name.prefixId(Token.XML)});
            }
        }
        if (!anns.isEmpty()) {
            throw this.error(QueryError.NOANN, new Object[0]);
        }
        if (!func || this.wsConsume(")")) {
            return type.seqType();
        }
        if (!(type instanceof NodeType)) {
            this.wsCheck(")");
        }
        return SeqType.get(type, Occ.EXACTLY_ONE, this.kindTest((NodeType)type));
    }

    private Type functionTest(AnnList anns, Type type) throws QueryException {
        if (this.wsConsume("*")) {
            this.wsCheck(")");
            return type;
        }
        if (type instanceof MapType) {
            Type key = this.itemType().type;
            if (!key.instanceOf(AtomType.ANY_ATOMIC_TYPE)) {
                throw this.error(QueryError.MAPTAAT_X, key);
            }
            this.wsCheck(",");
            MapType tp = MapType.get((AtomType)key, this.sequenceType());
            this.wsCheck(")");
            return tp;
        }
        if (type instanceof ArrayType) {
            ArrayType tp = ArrayType.get(this.sequenceType());
            this.wsCheck(")");
            return tp;
        }
        SeqType[] args = new SeqType[]{};
        if (!this.wsConsume(")")) {
            do {
                args = Array.add(args, this.sequenceType());
            } while (this.wsConsume(","));
            this.wsCheck(")");
        }
        this.wsCheck("as");
        return FuncType.get(anns, this.sequenceType(), args);
    }

    private Test kindTest(NodeType type) throws QueryException {
        Test tp;
        switch (type) {
            case DOCUMENT_NODE: {
                tp = this.documentTest();
                break;
            }
            case ELEMENT: {
                tp = this.elementTest();
                break;
            }
            case ATTRIBUTE: {
                tp = this.attributeTest();
                break;
            }
            case PROCESSING_INSTRUCTION: {
                tp = this.piTest();
                break;
            }
            case SCHEMA_ELEMENT: 
            case SCHEMA_ATTRIBUTE: {
                tp = this.schemaTest();
                break;
            }
            default: {
                tp = null;
            }
        }
        this.wsCheck(")");
        return tp;
    }

    private Test documentTest() throws QueryException {
        boolean elem = this.consume("element");
        if (!elem && !this.consume("schema-element")) {
            return null;
        }
        this.wsCheck("(");
        this.skipWs();
        Test test = elem ? this.elementTest() : this.schemaTest();
        this.wsCheck(")");
        return new DocTest(test != null ? test : KindTest.ELM);
    }

    private Test elementTest() throws QueryException {
        boolean wc;
        QNm name = this.eQName(null, this.sc.elemNS);
        boolean bl = wc = name == null && this.consume("*");
        if (name != null || wc) {
            Enum ann = null;
            if (this.wsConsumeWs(",")) {
                QNm tn = this.eQName(QueryError.QNAME_X, this.sc.elemNS);
                ann = ListType.find(tn);
                if (ann == null) {
                    ann = AtomType.find(tn, true);
                }
                if (ann == null) {
                    throw this.error(QueryError.TYPEUNDEF_X, tn);
                }
                this.wsConsume("?");
            }
            if (ann != null || !wc) {
                Test test = Test.get(NodeType.ELEMENT, name, ann, this.sc.elemNS);
                if (test == null) {
                    throw this.error(QueryError.STATIC_X, ann);
                }
                return test;
            }
        }
        return null;
    }

    private Test schemaTest() throws QueryException {
        QNm name = this.eQName(QueryError.QNAME_X, this.sc.elemNS);
        throw this.error(QueryError.SCHEMAINV_X, name);
    }

    private Test attributeTest() throws QueryException {
        boolean wc;
        QNm name = this.eQName(null, null);
        boolean bl = wc = name == null && this.consume("*");
        if (name != null || wc) {
            Enum ann = null;
            if (this.wsConsumeWs(",")) {
                QNm tn = this.eQName(QueryError.QNAME_X, this.sc.elemNS);
                ann = ListType.find(tn);
                if (ann == null) {
                    ann = AtomType.find(tn, true);
                }
                if (ann == null) {
                    throw this.error(QueryError.TYPEUNDEF_X, tn);
                }
            }
            if (ann != null || !wc) {
                Test test = Test.get(NodeType.ATTRIBUTE, name, ann, this.sc.elemNS);
                if (test == null) {
                    throw this.error(QueryError.STATIC_X, ann);
                }
                return test;
            }
        }
        return null;
    }

    private Test piTest() throws QueryException {
        byte[] name;
        this.token.reset();
        if (QueryParser.quote(this.curr())) {
            name = Token.trim(this.stringLiteral());
            if (!XMLToken.isNCName(name)) {
                throw this.error(QueryError.INVNCNAME_X, new Object[]{name});
            }
        } else if (this.ncName()) {
            name = this.token.toArray();
        } else {
            return null;
        }
        return Test.get(NodeType.PROCESSING_INSTRUCTION, new QNm(name));
    }

    private Expr tryCatch() throws QueryException {
        if (!this.wsConsumeWs("try")) {
            return null;
        }
        Expr ex = this.enclosedExpr();
        this.wsCheck("catch");
        Catch[] catches = new Catch[]{};
        do {
            NameTest[] codes = new NameTest[]{};
            do {
                this.skipWs();
                Test test = this.nodeTest(NodeType.ELEMENT, false);
                if (test == null) {
                    throw this.error(QueryError.NOCATCH, new Object[0]);
                }
                codes = Array.add(codes, test instanceof NameTest ? (NameTest)test : null);
            } while (this.wsConsumeWs("|"));
            int s = this.localVars.openScope();
            int cl = Catch.NAMES.length;
            Var[] vs = new Var[cl];
            InputInfo ii = this.info();
            for (int i = 0; i < cl; ++i) {
                vs[i] = this.localVars.add(new Var(Catch.NAMES[i], Catch.TYPES[i], false, this.qc, this.sc, ii));
            }
            Catch c = new Catch(ii, codes, vs);
            c.expr = this.enclosedExpr();
            this.localVars.closeScope(s);
            catches = Array.add(catches, c);
        } while (this.wsConsumeWs("catch"));
        return new Try(this.info(), ex, catches);
    }

    private FTExpr ftSelection(boolean prg) throws QueryException {
        FTExpr old;
        FTExpr ex = this.ftOr(prg);
        FTExpr first = null;
        boolean ordered = false;
        do {
            old = ex;
            if (this.wsConsumeWs("ordered")) {
                ordered = true;
                old = null;
            } else if (this.wsConsumeWs("window")) {
                ex = new FTWindow(this.info(), ex, this.additive(), this.ftUnit());
            } else if (this.wsConsumeWs("distance")) {
                Expr[] rng = this.ftRange(false);
                if (rng == null) {
                    throw this.error(QueryError.FTRANGE, new Object[0]);
                }
                ex = new FTDistance(this.info(), ex, rng[0], rng[1], this.ftUnit());
            } else if (this.wsConsumeWs("at")) {
                FTContents cont;
                FTContents fTContents = this.wsConsumeWs("start") ? FTContents.START : (cont = this.wsConsumeWs("end") ? FTContents.END : null);
                if (cont == null) {
                    throw this.error(QueryError.INCOMPLETE, new Object[0]);
                }
                ex = new FTContent(this.info(), ex, cont);
            } else if (this.wsConsumeWs("entire")) {
                this.wsCheck("content");
                ex = new FTContent(this.info(), ex, FTContents.ENTIRE);
            } else {
                boolean diff;
                boolean same = this.wsConsumeWs("same");
                boolean bl = diff = !same && this.wsConsumeWs("different");
                if (same || diff) {
                    FTUnit unit;
                    if (this.wsConsumeWs("sentence")) {
                        unit = FTUnit.SENTENCES;
                    } else if (this.wsConsumeWs("paragraph")) {
                        unit = FTUnit.PARAGRAPHS;
                    } else {
                        throw this.error(QueryError.INCOMPLETE, new Object[0]);
                    }
                    ex = new FTScope(this.info(), ex, same, unit);
                }
            }
            if (first != null || old == null || old == ex) continue;
            first = ex;
        } while (old != ex);
        if (ordered) {
            if (first == null) {
                return new FTOrder(this.info(), ex);
            }
            first.exprs[0] = new FTOrder(this.info(), first.exprs[0]);
        }
        return ex;
    }

    private FTExpr ftOr(boolean prg) throws QueryException {
        FTExpr ex = this.ftAnd(prg);
        if (!this.wsConsumeWs("ftor")) {
            return ex;
        }
        FTExpr[] list = new FTExpr[]{ex};
        do {
            list = Array.add(list, this.ftAnd(prg));
        } while (this.wsConsumeWs("ftor"));
        return new FTOr(this.info(), list);
    }

    private FTExpr ftAnd(boolean prg) throws QueryException {
        FTExpr ex = this.ftMildNot(prg);
        if (!this.wsConsumeWs("ftand")) {
            return ex;
        }
        FTExpr[] list = new FTExpr[]{ex};
        do {
            list = Array.add(list, this.ftMildNot(prg));
        } while (this.wsConsumeWs("ftand"));
        return new FTAnd(this.info(), list);
    }

    private FTExpr ftMildNot(boolean prg) throws QueryException {
        FTExpr not;
        FTExpr ex = this.ftUnaryNot(prg);
        if (!this.wsConsumeWs("not")) {
            return ex;
        }
        FTExpr[] list = new FTExpr[]{};
        do {
            this.wsCheck("in");
            list = Array.add(list, this.ftUnaryNot(prg));
        } while (this.wsConsumeWs("not"));
        InputInfo ii = this.info();
        FTExpr fTExpr = not = list.length == 1 ? list[0] : new FTOr(ii, list);
        if (ex.usesExclude() || not.usesExclude()) {
            throw QueryError.FTMILD.get(ii, new Object[0]);
        }
        return new FTMildNot(ii, ex, not);
    }

    private FTExpr ftUnaryNot(boolean prg) throws QueryException {
        boolean not = this.wsConsumeWs("ftnot");
        FTExpr ex = this.ftPrimaryWithOptions(prg);
        return not ? new FTNot(this.info(), ex) : ex;
    }

    private FTExpr ftPrimaryWithOptions(boolean prg) throws QueryException {
        FTExpr ex = this.ftPrimary(prg);
        FTOpt fto = new FTOpt();
        boolean found = false;
        while (this.ftMatchOption(fto)) {
            found = true;
        }
        if (found) {
            if (fto.ln == null) {
                fto.ln = Language.def();
            }
            if (!Tokenizer.supportFor(fto.ln)) {
                throw this.error(QueryError.FTNOTOK_X, fto.ln);
            }
            if (fto.is(FTFlag.ST) && fto.sd == null && !Stemmer.supportFor(fto.ln)) {
                throw this.error(QueryError.FTNOSTEM_X, fto.ln);
            }
        }
        if (this.wsConsumeWs("weight")) {
            ex = new FTWeight(this.info(), ex, this.enclosedExpr());
        }
        return found ? new FTOptions(this.info(), ex, fto) : ex;
    }

    private FTExpr ftPrimary(boolean prg) throws QueryException {
        Expr e;
        Pragma[] pragmas = this.pragma();
        if (pragmas != null) {
            this.wsCheck("{");
            FTExpr ex = this.ftSelection(true);
            this.wsCheck("}");
            for (int p = pragmas.length - 1; p >= 0; --p) {
                ex = new FTExtension(this.info(), pragmas[p], ex);
            }
            return ex;
        }
        if (this.wsConsumeWs("(")) {
            FTExpr ex = this.ftSelection(false);
            this.wsCheck(")");
            return ex;
        }
        this.skipWs();
        if (QueryParser.quote(this.curr())) {
            e = Str.get(this.stringLiteral());
        } else if (this.curr(123)) {
            e = this.enclosedExpr();
        } else {
            throw this.error(prg ? QueryError.NOPRAGMA : QueryError.NOFTSELECT_X, new Object[]{this.found()});
        }
        FTMode mode = FTMode.ANY;
        if (this.wsConsumeWs("all")) {
            mode = this.wsConsumeWs("words") ? FTMode.ALL_WORDS : FTMode.ALL;
        } else if (this.wsConsumeWs("any")) {
            mode = this.wsConsumeWs("word") ? FTMode.ANY_WORD : FTMode.ANY;
        } else if (this.wsConsumeWs("phrase")) {
            mode = FTMode.PHRASE;
        }
        Expr[] occ = null;
        if (this.wsConsumeWs("occurs")) {
            occ = this.ftRange(false);
            if (occ == null) {
                throw this.error(QueryError.FTRANGE, new Object[0]);
            }
            this.wsCheck("times");
        }
        return new FTWords(this.info(), e, mode, occ);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Expr[] ftRange(boolean i) throws QueryException {
        Expr[] occ = new Expr[]{Int.ZERO, Int.MAX};
        if (this.wsConsumeWs("exactly")) {
            occ[0] = this.ftAdditive(i);
            occ[1] = occ[0];
            return occ;
        } else if (this.wsConsumeWs("at")) {
            if (this.wsConsumeWs("least")) {
                occ[0] = this.ftAdditive(i);
                return occ;
            } else {
                if (!this.wsConsumeWs("most")) return null;
                occ[1] = this.ftAdditive(i);
            }
            return occ;
        } else {
            if (!this.wsConsumeWs("from")) return null;
            occ[0] = this.ftAdditive(i);
            this.wsCheck("to");
            occ[1] = this.ftAdditive(i);
        }
        return occ;
    }

    private Expr ftAdditive(boolean i) throws QueryException {
        if (!i) {
            return this.additive();
        }
        this.skipWs();
        this.token.reset();
        while (Token.digit(this.curr())) {
            this.token.add(this.consume());
        }
        if (this.token.isEmpty()) {
            throw this.error(QueryError.INTEXP, new Object[0]);
        }
        return Int.get(Token.toLong(this.token.toArray()));
    }

    private FTUnit ftUnit() throws QueryException {
        if (this.wsConsumeWs("words")) {
            return FTUnit.WORDS;
        }
        if (this.wsConsumeWs("sentences")) {
            return FTUnit.SENTENCES;
        }
        if (this.wsConsumeWs("paragraphs")) {
            return FTUnit.PARAGRAPHS;
        }
        throw this.error(QueryError.INCOMPLETE, new Object[0]);
    }

    private boolean ftMatchOption(FTOpt opt) throws QueryException {
        if (!this.wsConsumeWs("using")) {
            return false;
        }
        if (this.wsConsumeWs("lowercase")) {
            if (opt.cs != null) {
                throw this.error(QueryError.FTDUP_X, "case");
            }
            opt.cs = FTCase.LOWER;
        } else if (this.wsConsumeWs("uppercase")) {
            if (opt.cs != null) {
                throw this.error(QueryError.FTDUP_X, "case");
            }
            opt.cs = FTCase.UPPER;
        } else if (this.wsConsumeWs("case")) {
            if (opt.cs != null) {
                throw this.error(QueryError.FTDUP_X, "case");
            }
            if (this.wsConsumeWs("sensitive")) {
                opt.cs = FTCase.SENSITIVE;
            } else {
                opt.cs = FTCase.INSENSITIVE;
                this.wsCheck("insensitive");
            }
        } else if (this.wsConsumeWs("diacritics")) {
            if (opt.isSet(FTFlag.DC)) {
                throw this.error(QueryError.FTDUP_X, "diacritics");
            }
            opt.set(FTFlag.DC, this.wsConsumeWs("sensitive"));
            if (!opt.is(FTFlag.DC)) {
                this.wsCheck("insensitive");
            }
        } else if (this.wsConsumeWs("language")) {
            if (opt.ln != null) {
                throw this.error(QueryError.FTDUP_X, "language");
            }
            byte[] lan = this.stringLiteral();
            opt.ln = Language.get(Token.string(lan));
            if (opt.ln == null) {
                throw this.error(QueryError.FTNOTOK_X, new Object[]{lan});
            }
        } else if (this.wsConsumeWs("option")) {
            this.optionDecl();
        } else {
            boolean using;
            boolean bl = using = !this.wsConsumeWs("no");
            if (this.wsConsumeWs("stemming")) {
                if (opt.isSet(FTFlag.ST)) {
                    throw this.error(QueryError.FTDUP_X, "stemming");
                }
                opt.set(FTFlag.ST, using);
            } else if (this.wsConsumeWs("thesaurus")) {
                if (opt.th != null) {
                    throw this.error(QueryError.FTDUP_X, "thesaurus");
                }
                opt.th = new ThesQuery();
                if (using) {
                    boolean par = this.wsConsume("(");
                    if (!this.wsConsumeWs("default")) {
                        this.ftThesaurusID(opt.th);
                    }
                    while (par && this.wsConsume(",")) {
                        this.ftThesaurusID(opt.th);
                    }
                    if (par) {
                        this.wsCheck(")");
                    }
                }
            } else if (this.wsConsumeWs("stop")) {
                StopWords sw;
                this.wsCheck("words");
                if (opt.sw != null) {
                    throw this.error(QueryError.FTDUP_X, "stop words");
                }
                opt.sw = sw = new StopWords();
                if (this.wsConsumeWs("default")) {
                    if (!using) {
                        throw this.error(QueryError.FTSTOP, new Object[0]);
                    }
                } else if (using) {
                    boolean union = false;
                    boolean except = false;
                    do {
                        if (this.wsConsume("(")) {
                            do {
                                byte[] sl = this.stringLiteral();
                                if (except) {
                                    sw.remove(sl);
                                    continue;
                                }
                                sw.add(sl);
                            } while (this.wsConsume(","));
                            this.wsCheck(")");
                        } else if (this.wsConsumeWs("at")) {
                            String fn = Token.string(this.stringLiteral());
                            IO fl = this.qc.resources.stopWords(fn, this.sc);
                            try {
                                opt.sw.read(fl, except);
                            }
                            catch (IOException ex) {
                                Util.debug(ex);
                                throw this.error(QueryError.NOSTOPFILE_X, fl);
                            }
                        } else if (!union && !except) {
                            throw this.error(QueryError.FTSTOP, new Object[0]);
                        }
                        union = this.wsConsumeWs("union");
                        boolean bl2 = except = !union && this.wsConsumeWs("except");
                    } while (union || except);
                }
            } else if (this.wsConsumeWs("wildcards")) {
                if (opt.isSet(FTFlag.WC)) {
                    throw this.error(QueryError.FTDUP_X, "wildcards");
                }
                if (opt.is(FTFlag.FZ)) {
                    throw this.error(QueryError.FT_OPTIONS, new Object[0]);
                }
                opt.set(FTFlag.WC, using);
            } else if (this.wsConsumeWs("fuzzy")) {
                if (opt.isSet(FTFlag.FZ)) {
                    throw this.error(QueryError.FTDUP_X, "fuzzy");
                }
                if (opt.is(FTFlag.WC)) {
                    throw this.error(QueryError.FT_OPTIONS, new Object[0]);
                }
                opt.set(FTFlag.FZ, using);
            } else {
                throw this.error(QueryError.FTMATCH_X, Character.valueOf(this.consume()));
            }
        }
        return true;
    }

    private void ftThesaurusID(ThesQuery thes) throws QueryException {
        this.wsCheck("at");
        String fn = Token.string(this.stringLiteral());
        IO fl = this.qc.resources.thesaurus(fn, this.sc);
        byte[] rel = this.wsConsumeWs("relationship") ? this.stringLiteral() : Token.EMPTY;
        Expr[] range = this.ftRange(true);
        long min = 0L;
        long max = Long.MAX_VALUE;
        if (range != null) {
            this.wsCheck("levels");
            min = ((ANum)range[0]).itr();
            max = ((ANum)range[1]).itr();
        }
        thes.add(new Thesaurus(fl, rel, min, max, this.qc.context));
    }

    private Expr insert() throws QueryException {
        int p = this.pos;
        if (!this.wsConsumeWs("insert") || !this.wsConsumeWs("node") && !this.wsConsumeWs("nodes")) {
            this.pos = p;
            return null;
        }
        Expr s = this.check(this.single(), QueryError.INCOMPLETE);
        Insert.Mode mode = Insert.Mode.INTO;
        if (this.wsConsumeWs("as")) {
            if (this.wsConsumeWs("first")) {
                mode = Insert.Mode.FIRST;
            } else {
                this.wsCheck("last");
                mode = Insert.Mode.LAST;
            }
            this.wsCheck("into");
        } else if (!this.wsConsumeWs("into")) {
            if (this.wsConsumeWs("after")) {
                mode = Insert.Mode.AFTER;
            } else if (this.wsConsumeWs("before")) {
                mode = Insert.Mode.BEFORE;
            } else {
                throw this.error(QueryError.INCOMPLETE, new Object[0]);
            }
        }
        Expr trg = this.check(this.single(), QueryError.INCOMPLETE);
        this.qc.updating();
        return new Insert(this.sc, this.info(), s, mode, trg);
    }

    private Expr delete() throws QueryException {
        int p = this.pos;
        if (!this.wsConsumeWs("delete") || !this.wsConsumeWs("nodes") && !this.wsConsumeWs("node")) {
            this.pos = p;
            return null;
        }
        this.qc.updating();
        return new Delete(this.sc, this.info(), this.check(this.single(), QueryError.INCOMPLETE));
    }

    private Expr rename() throws QueryException {
        int p = this.pos;
        if (!this.wsConsumeWs("rename") || !this.wsConsumeWs("node")) {
            this.pos = p;
            return null;
        }
        Expr trg = this.check(this.single(), QueryError.INCOMPLETE);
        this.wsCheck("as");
        Expr n = this.check(this.single(), QueryError.INCOMPLETE);
        this.qc.updating();
        return new Rename(this.sc, this.info(), trg, n);
    }

    private Expr replace() throws QueryException {
        int p = this.pos;
        if (!this.wsConsumeWs("replace")) {
            return null;
        }
        boolean value = this.wsConsumeWs("value");
        if (value) {
            this.wsCheck("of");
            this.wsCheck("node");
        } else if (!this.wsConsumeWs("node")) {
            this.pos = p;
            return null;
        }
        Expr trg = this.check(this.single(), QueryError.INCOMPLETE);
        this.wsCheck("with");
        Expr src = this.check(this.single(), QueryError.INCOMPLETE);
        this.qc.updating();
        return new Replace(this.sc, this.info(), trg, src, value);
    }

    private Expr copyModify() throws QueryException {
        if (!this.wsConsumeWs("copy", "$", QueryError.INCOMPLETE)) {
            return null;
        }
        int s = this.localVars.openScope();
        Let[] fl = new Let[]{};
        do {
            Var var = this.newVar(SeqType.NODE_O);
            this.wsCheck(":=");
            Expr ex = this.check(this.single(), QueryError.INCOMPLETE);
            fl = Array.add(fl, new Let(this.localVars.add(var), ex));
        } while (this.wsConsumeWs(","));
        this.wsCheck("modify");
        InputInfo ii = this.info();
        Expr m = this.check(this.single(), QueryError.INCOMPLETE);
        this.wsCheck("return");
        Expr r = this.check(this.single(), QueryError.INCOMPLETE);
        this.localVars.closeScope(s);
        this.qc.updating();
        return new Transform(ii, fl, m, r);
    }

    private Expr updatingFunctionCall() throws QueryException {
        int p = this.pos;
        this.wsConsume("invoke");
        boolean upd = this.wsConsumeWs("updating");
        boolean ndt = this.wsConsumeWs("non-deterministic");
        if (upd || ndt) {
            Expr func = this.primary();
            if (this.wsConsume("(")) {
                InputInfo ii = this.info();
                ExprList argList = new ExprList();
                if (!this.wsConsume(")")) {
                    do {
                        Expr ex;
                        if ((ex = this.single()) == null) {
                            throw this.error(QueryError.FUNCARG_X, new Object[]{this.found()});
                        }
                        argList.add(ex);
                    } while (this.wsConsume(","));
                    if (!this.wsConsume(")")) {
                        throw this.error(QueryError.FUNCARG_X, new Object[]{this.found()});
                    }
                }
                if (upd) {
                    this.qc.updating();
                }
                return new DynFuncCall(ii, this.sc, upd, ndt, func, (Expr[])argList.finish());
            }
        }
        this.pos = p;
        return null;
    }

    private byte[] ncName(QueryError error) throws QueryException {
        this.token.reset();
        if (this.ncName()) {
            return this.token.toArray();
        }
        if (error != null) {
            char ch = this.consume();
            throw this.error(error, ch == '\u0000' ? "" : Character.valueOf(ch));
        }
        return Token.EMPTY;
    }

    private QNm eQName(QueryError error, byte[] ns) throws QueryException {
        byte[] nm;
        Object name;
        int p = this.pos;
        if (this.consume("Q{")) {
            byte[] uri = this.bracedURILiteral();
            name = this.ncName(null);
            if (((byte[])name).length != 0) {
                if (ns == URICHECK && uri.length == 0) {
                    this.pos = p;
                    throw this.error(QueryError.NOURI_X, name);
                }
                return new QNm((byte[])name, uri);
            }
            this.pos = p;
        }
        if ((nm = this.qName(error)).length == 0) {
            return null;
        }
        if (ns == SKIPCHECK) {
            return new QNm(nm);
        }
        name = new QNm(nm, this.sc);
        if (!name.hasURI()) {
            if (ns == URICHECK) {
                this.pos = p;
                throw this.error(QueryError.NSMISS_X, name);
            }
            if (name.hasPrefix()) {
                this.pos = p;
                throw this.error(QueryError.NOURI_X, new Object[]{name.string()});
            }
            name.uri(ns);
        }
        return name;
    }

    private byte[] qName(QueryError error) throws QueryException {
        this.token.reset();
        if (!this.ncName()) {
            if (error != null) {
                char ch = this.consume();
                throw this.error(error, ch == '\u0000' ? "" : Character.valueOf(ch));
            }
        } else if (this.consume(58)) {
            if (XMLToken.isNCStartChar(this.curr())) {
                this.token.add(58);
                do {
                    this.token.add(this.consume());
                } while (XMLToken.isNCChar(this.curr()));
            } else {
                --this.pos;
            }
        }
        return this.token.toArray();
    }

    private boolean ncName() {
        if (!XMLToken.isNCStartChar(this.curr())) {
            return false;
        }
        do {
            this.token.add(this.consume());
        } while (XMLToken.isNCChar(this.curr()));
        return true;
    }

    private boolean entity(TokenBuilder tb) throws QueryException {
        int i = this.pos;
        boolean ent = this.consume(38);
        if (ent) {
            if (this.consume(35)) {
                int b = this.consume(120) ? 16 : 10;
                boolean ok = true;
                int n = 0;
                do {
                    boolean h;
                    char ch = this.curr();
                    boolean m = Token.digit(ch);
                    boolean bl = h = b == 16 && (ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F');
                    if (!m && !h) {
                        this.entityError(i, QueryError.INVENTITY_X);
                    }
                    long nn = n;
                    if ((long)(n = n * b + (this.consume() & 0xF)) < nn) {
                        ok = false;
                    }
                    if (m) continue;
                    n += 9;
                } while (!this.consume(59));
                if (!ok) {
                    this.entityError(i, QueryError.INVCHARREF_X);
                }
                if (!XMLToken.valid(n)) {
                    this.entityError(i, QueryError.INVCHARREF_X);
                }
                tb.add(n);
            } else {
                if (this.consume("lt")) {
                    tb.add(60);
                } else if (this.consume("gt")) {
                    tb.add(62);
                } else if (this.consume("amp")) {
                    tb.add(38);
                } else if (this.consume("quot")) {
                    tb.add(34);
                } else if (this.consume("apos")) {
                    tb.add(39);
                } else {
                    this.entityError(i, QueryError.INVENTITY_X);
                }
                if (!this.consume(59)) {
                    this.entityError(i, QueryError.INVENTITY_X);
                }
            }
        } else {
            int ch = this.consume();
            int cp = ch;
            if (cp == 13) {
                cp = 10;
                if (this.curr(cp)) {
                    this.consume();
                }
            } else if (Character.isHighSurrogate((char)ch) && this.curr() != '\u0000' && Character.isLowSurrogate(this.curr())) {
                cp = Character.toCodePoint((char)ch, this.consume());
            }
            tb.add(cp);
        }
        return ent;
    }

    private void entityError(int start, QueryError code) throws QueryException {
        String sub = this.input.substring(start, Math.min(start + 20, this.length));
        int semi = sub.indexOf(59);
        String ent = semi == -1 ? sub + "..." : sub.substring(0, semi + 1);
        throw this.error(code, ent);
    }

    private <E extends Expr> E check(E expr, QueryError error) throws QueryException {
        if (expr == null) {
            throw this.error(error, new Object[0]);
        }
        return expr;
    }

    private void check(char ch) throws QueryException {
        if (!this.consume(ch)) {
            throw this.error(QueryError.WRONGCHAR_X_X, Character.valueOf(ch), this.found());
        }
    }

    private void wsCheck(String string) throws QueryException {
        if (!this.wsConsume(string)) {
            throw this.error(QueryError.WRONGCHAR_X_X, string, this.found());
        }
    }

    private char consumeContent() throws QueryException {
        char ch = this.consume();
        if (ch == '\u0000') {
            throw this.error(QueryError.NOCONTENT, new Object[0]);
        }
        if (ch == '\r') {
            ch = '\n';
            this.consume(10);
        }
        return (char)ch;
    }

    private boolean wsConsumeWs(String string) throws QueryException {
        int p = this.pos;
        if (!this.wsConsume(string)) {
            return false;
        }
        if (this.skipWs() || !XMLToken.isNCStartChar(string.charAt(0)) || !XMLToken.isNCChar(this.curr())) {
            return true;
        }
        this.pos = p;
        return false;
    }

    private boolean wsConsumeWs(String string1, String string2, QueryError expr) throws QueryException {
        int p1 = this.pos;
        if (!this.wsConsumeWs(string1)) {
            return false;
        }
        int p2 = this.pos;
        this.alter = expr;
        this.alterPos = p2;
        boolean ok = this.wsConsume(string2);
        this.pos = ok ? p2 : p1;
        return ok;
    }

    private boolean wsConsume(String string) throws QueryException {
        this.skipWs();
        return this.consume(string);
    }

    private boolean skipWs() throws QueryException {
        int i = this.pos;
        while (this.more()) {
            char ch = this.curr();
            if (ch == '(' && this.next() == ':') {
                this.comment();
                continue;
            }
            if (ch <= '\u0000' || ch > ' ') {
                return i != this.pos;
            }
            ++this.pos;
        }
        return i != this.pos;
    }

    private void comment() throws QueryException {
        boolean xqdoc;
        ++this.pos;
        boolean bl = xqdoc = this.next() == '~';
        if (xqdoc) {
            this.currDoc.setLength(0);
            ++this.pos;
        }
        this.comment(false, xqdoc);
    }

    private void comment(boolean nested, boolean xqdoc) throws QueryException {
        while (++this.pos < this.length) {
            char curr = this.curr();
            if (curr == '(' && this.next() == ':') {
                ++this.pos;
                this.comment(true, xqdoc);
                curr = this.curr();
            }
            if (curr == ':' && this.next() == ')') {
                this.pos += 2;
                if (!nested && this.doc.isEmpty()) {
                    this.doc = this.currDoc.toString().trim();
                    this.currDoc.setLength(0);
                }
                return;
            }
            if (!xqdoc) continue;
            this.currDoc.append(curr);
        }
        throw this.error(QueryError.COMCLOSE, new Object[0]);
    }

    private boolean consumeWS() {
        int i = this.pos;
        while (this.more()) {
            char ch = this.curr();
            if (ch <= '\u0000' || ch > ' ') {
                return i != this.pos;
            }
            ++this.pos;
        }
        return true;
    }

    private QueryException alterError(QueryError error) {
        if (this.alter == null) {
            return this.error(error, new Object[0]);
        }
        this.pos = this.alterPos;
        return this.error(this.alter, new Object[0]);
    }

    private void add(ExprList ar, Expr ex) throws QueryException {
        if (ex == null) {
            throw this.error(QueryError.INCOMPLETE, new Object[0]);
        }
        ar.add(ex);
    }

    private QueryException error(QueryError error, Object ... arg) {
        return this.error(error, this.info(), arg);
    }

    public QueryException error(QueryError error, InputInfo ii, Object ... arg) {
        return error.get(ii, arg);
    }

    static {
        byte[][] keys;
        URICHECK = new byte[0];
        SKIPCHECK = new byte[0];
        KEYWORDS = new TokenSet();
        DECFORMATS = Token.tokens("decimal-separator", "digit", "grouping-separator", "exponent-separator", "infinity", "minus-sign", "NaN", "pattern-separator", "percent", "per-mille", "zero-digit");
        for (byte[] key : keys = new byte[][]{Token.token("function"), Token.token("array"), NodeType.ATTRIBUTE.qname().string(), NodeType.COMMENT.qname().string(), NodeType.DOCUMENT_NODE.qname().string(), NodeType.ELEMENT.qname().string(), Token.token("empty-sequence"), Token.token("if"), AtomType.ITEM.qname().string(), Token.token("map"), NodeType.NAMESPACE_NODE.qname().string(), NodeType.NODE.qname().string(), NodeType.PROCESSING_INSTRUCTION.qname().string(), Token.token("schema-attribute"), Token.token("schema-element"), Token.token("switch"), NodeType.TEXT.qname().string(), Token.token("typeswitch")}) {
            KEYWORDS.add(key);
        }
    }
}

