/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.random;

import java.util.Arrays;
import org.basex.data.MetaData;
import org.basex.io.random.TableAccess;
import org.basex.util.Array;

public final class TableMemAccess
extends TableAccess {
    private long[] data1 = new long[8];
    private long[] data2 = new long[8];

    public TableMemAccess(MetaData meta) {
        super(meta);
    }

    @Override
    public void flush(boolean all) {
    }

    @Override
    public void close() {
    }

    @Override
    public boolean lock(boolean lock) {
        return true;
    }

    @Override
    public int read1(int pre, int offset) {
        return (int)((offset < 8 ? this.data1 : this.data2)[pre] >> ((offset < 8 ? 7 : 15) - offset << 3) & 0xFFL);
    }

    @Override
    public int read2(int pre, int offset) {
        return (int)((offset < 8 ? this.data1 : this.data2)[pre] >> ((offset < 8 ? 6 : 14) - offset << 3) & 0xFFFFL);
    }

    @Override
    public int read4(int pre, int offset) {
        return (int)((offset < 8 ? this.data1 : this.data2)[pre] >> ((offset < 8 ? 4 : 12) - offset << 3));
    }

    @Override
    public long read5(int pre, int offset) {
        return (offset < 8 ? this.data1 : this.data2)[pre] >> ((offset < 8 ? 3 : 11) - offset << 3) & 0xFFFFFFFFFFL;
    }

    @Override
    public void write1(int pre, int offset, int value) {
        this.dirty();
        long[] buf = offset < 8 ? this.data1 : this.data2;
        long d = (offset < 8 ? 7 : 15) - offset << 3;
        buf[pre] = buf[pre] & (255L << (int)d ^ 0xFFFFFFFFFFFFFFFFL) | (long)value << (int)d;
    }

    @Override
    public void write2(int pre, int offset, int value) {
        this.dirty();
        long[] buf = offset < 8 ? this.data1 : this.data2;
        long d = (offset < 8 ? 6 : 14) - offset << 3;
        buf[pre] = buf[pre] & (65535L << (int)d ^ 0xFFFFFFFFFFFFFFFFL) | (long)value << (int)d;
    }

    @Override
    public void write4(int pre, int offset, int value) {
        this.dirty();
        long[] buf = offset < 8 ? this.data1 : this.data2;
        long d = (offset < 8 ? 4 : 12) - offset << 3;
        buf[pre] = buf[pre] & (0xFFFFFFFFL << (int)d ^ 0xFFFFFFFFFFFFFFFFL) | (long)value << (int)d;
    }

    @Override
    public void write5(int pre, int offset, long value) {
        this.dirty();
        long[] buf = offset < 8 ? this.data1 : this.data2;
        long d = (offset < 8 ? 3 : 11) - offset << 3;
        buf[pre] = buf[pre] & (0xFFFFFFFFFFL << (int)d ^ 0xFFFFFFFFFFFFFFFFL) | value << (int)d;
    }

    @Override
    protected void copy(byte[] entries, int pre, int last) {
        this.dirty();
        int o = 0;
        int i = pre;
        while (i < last) {
            this.data1[i] = TableMemAccess.getLong(entries, o);
            this.data2[i] = TableMemAccess.getLong(entries, o + 8);
            ++i;
            o += 16;
        }
    }

    @Override
    public void delete(int pre, int count) {
        if (count == 0) {
            return;
        }
        this.move(pre + count, pre);
    }

    @Override
    public void insert(int pre, byte[] entries) {
        if (entries.length == 0) {
            return;
        }
        this.move(pre, pre + (entries.length >>> 4));
        this.set(pre, entries);
    }

    @Override
    protected void dirty() {
        this.dirty = true;
    }

    private void move(int source, int target) {
        this.dirty();
        int l = this.meta.size - source;
        while (l + target >= this.data1.length) {
            int s = Array.newCapacity(this.data1.length);
            this.data1 = Arrays.copyOf(this.data1, s);
            this.data2 = Arrays.copyOf(this.data2, s);
        }
        Array.copy(this.data1, source, l, this.data1, target);
        Array.copy(this.data2, source, l, this.data2, target);
        this.meta.size += target - source;
    }

    private static long getLong(byte[] entry, int index) {
        return ((long)entry[index] & 0xFFL) << 56 | ((long)entry[index + 1] & 0xFFL) << 48 | ((long)entry[index + 2] & 0xFFL) << 40 | ((long)entry[index + 3] & 0xFFL) << 32 | ((long)entry[index + 4] & 0xFFL) << 24 | ((long)entry[index + 5] & 0xFFL) << 16 | ((long)entry[index + 6] & 0xFFL) << 8 | (long)entry[index + 7] & 0xFFL;
    }
}

