/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.xml;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlParser {
    private final XMLReader reader = XmlParser.reader(false, false);

    public XmlParser contentHandler(ContentHandler handler) {
        this.reader.setContentHandler(handler);
        return this;
    }

    public void parse(InputStream stream) throws IOException, SAXException {
        this.reader.setErrorHandler(new XmlHandler());
        this.reader.parse(new InputSource(stream));
    }

    public static XMLReader reader(boolean dtd, boolean xinclude) throws SAXException, ParserConfigurationException {
        SAXParserFactory f = SAXParserFactory.newInstance();
        f.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", dtd);
        f.setFeature("http://xml.org/sax/features/external-parameter-entities", dtd);
        f.setFeature("http://xml.org/sax/features/use-entity-resolver2", false);
        f.setNamespaceAware(true);
        f.setValidating(false);
        f.setXIncludeAware(xinclude);
        return f.newSAXParser().getXMLReader();
    }

    private static class XmlHandler
    extends DefaultHandler {
        private XmlHandler() {
        }

        @Override
        public void fatalError(SAXParseException ex) throws SAXParseException {
            throw ex;
        }

        @Override
        public void error(SAXParseException ex) throws SAXParseException {
            throw ex;
        }

        @Override
        public void warning(SAXParseException ex) throws SAXParseException {
            throw ex;
        }
    }
}

