/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.json;

import java.util.Stack;
import org.basex.build.json.JsonParserOptions;
import org.basex.io.parse.json.JsonConverter;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.util.list.ValueList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.seq.Empty;
import org.basex.util.Token;

public final class JsonXQueryConverter
extends JsonConverter {
    private final Stack<Value> stack = new Stack();
    private final Stack<ValueList> arrays = new Stack();
    private final Stack<XQMap> maps = new Stack();

    JsonXQueryConverter(JsonParserOptions opts) throws QueryIOException {
        super(opts);
        JsonParserOptions.JsonDuplicates dupl = this.jopts.get(JsonParserOptions.DUPLICATES);
        if (dupl == JsonParserOptions.JsonDuplicates.RETAIN) {
            throw new QueryIOException(QueryError.JSON_OPTIONS_X.get(null, new Object[]{JsonParserOptions.DUPLICATES.name(), dupl}));
        }
    }

    @Override
    void init(String uri) {
    }

    @Override
    public Item finish() {
        Value value = this.stack.pop();
        return value.isEmpty() ? Empty.VALUE : (Item)value;
    }

    @Override
    void openObject() {
        this.maps.push(XQMap.EMPTY);
    }

    @Override
    void openPair(byte[] key, boolean add) {
        this.stack.push(Str.get(key));
    }

    @Override
    void closePair(boolean add) throws QueryIOException {
        Value value = this.stack.pop();
        Item key = (Item)this.stack.pop();
        if (add) {
            try {
                this.maps.push(this.maps.pop().put(key, value, null));
            }
            catch (QueryException ex) {
                throw new QueryIOException(ex);
            }
        }
    }

    @Override
    void closeObject() {
        this.stack.push(this.maps.pop());
    }

    @Override
    void openArray() {
        this.arrays.push(new ValueList());
    }

    @Override
    void openItem() {
    }

    @Override
    void closeItem() {
        this.arrays.peek().add(this.stack.pop());
    }

    @Override
    void closeArray() {
        this.stack.push(this.arrays.pop().array());
    }

    @Override
    public void numberLit(byte[] value) throws QueryIOException {
        try {
            this.stack.push(Dbl.get(value, null));
        }
        catch (QueryException ex) {
            throw new QueryIOException(ex);
        }
    }

    @Override
    public void stringLit(byte[] value) {
        this.stack.push(Str.get(value));
    }

    @Override
    public void nullLit() {
        this.stack.push(Empty.VALUE);
    }

    @Override
    public void booleanLit(byte[] value) {
        this.stack.push(Bln.get(Token.eq(value, Token.TRUE)));
    }
}

