/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.in;

import java.io.IOException;
import java.io.InputStream;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.in.BufferInput;
import org.basex.io.in.InputException;
import org.basex.io.in.TextDecoder;
import org.basex.util.Array;
import org.basex.util.Strings;
import org.basex.util.TokenBuilder;
import org.basex.util.XMLToken;

public class TextInput
extends BufferInput {
    private TextDecoder decoder;
    private boolean validate;

    public TextInput(InputStream is) throws IOException {
        super(is);
        this.guess();
    }

    public TextInput(IO io) throws IOException {
        super(io);
        this.guess();
    }

    public TextInput(byte[] token) throws IOException {
        this(new IOContent(token));
    }

    private void guess() throws IOException {
        try {
            int a = this.readByte();
            int b = this.readByte();
            int c = this.readByte();
            int d = this.readByte();
            String e = "UTF-8";
            int skip = 0;
            if (a == 255 && b == 254) {
                e = "UTF-16LE";
                skip = 2;
            } else if (a == 254 && b == 255) {
                e = "UTF-16BE";
                skip = 2;
            } else if (a == 239 && b == 187 && c == 191) {
                skip = 3;
            } else if (a == 60 && b == 0 && c == 63 && d == 0) {
                e = "UTF-16LE";
            } else if (a == 0 && b == 60 && c == 0 && d == 63) {
                e = "UTF-16BE";
            }
            this.reset();
            for (int s = 0; s < skip; ++s) {
                this.readByte();
            }
            this.decoder = TextDecoder.get(e);
        }
        catch (IOException ex) {
            this.close();
            throw ex;
        }
    }

    public final String encoding() {
        return this.decoder.encoding;
    }

    public final TextInput validate(boolean flag) {
        this.validate = flag;
        this.decoder.validate = flag;
        return this;
    }

    public TextInput encoding(String encoding) throws IOException {
        if (encoding != null && !encoding.isEmpty()) {
            String e = Strings.normEncoding(encoding);
            if (e == "UTF-16") {
                e = this.decoder.encoding == "UTF-16LE" ? "UTF-16LE" : "UTF-16BE";
            }
            this.decoder = TextDecoder.get(e);
            this.decoder.validate = this.validate;
        }
        return this;
    }

    @Override
    public int read() throws IOException {
        int cp = this.decoder.read(this);
        if (cp != -1 && !XMLToken.valid(cp)) {
            if (this.validate) {
                throw new InputException("Invalid XML character: #" + cp);
            }
            return 65533;
        }
        return cp;
    }

    @Override
    public final byte[] content() throws IOException {
        return this.cache().finish();
    }

    public final TokenBuilder cache() throws IOException {
        try {
            int ch;
            TokenBuilder tb = new TokenBuilder(Array.initialCapacity(this.length));
            while ((ch = this.read()) != -1) {
                tb.add(ch);
            }
            TokenBuilder tokenBuilder = tb;
            return tokenBuilder;
        }
        finally {
            this.close();
        }
    }
}

