/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.in;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import org.basex.io.in.DecodingException;
import org.basex.io.in.TextInput;
import org.basex.util.Token;

abstract class TextDecoder {
    String encoding;
    boolean validate;

    TextDecoder() {
    }

    abstract int read(TextInput var1) throws IOException;

    static TextDecoder get(String enc) throws IOException {
        TextDecoder td = enc == "UTF-8" ? new UTF8() : (enc == "UTF-32" ? new UTF32() : (enc == "UTF-16LE" ? new UTF16LE() : (enc == "UTF-16" || enc == "UTF-16BE" ? new UTF16BE() : new Generic(enc))));
        td.encoding = enc;
        return td;
    }

    final int invalid(int cp) throws IOException {
        if (this.validate) {
            throw new DecodingException("Decoding error: x" + Integer.toHexString(cp & 0xFF));
        }
        return 65533;
    }

    private static final class Generic
    extends TextDecoder {
        private final byte[] cache = new byte[4];
        private final ByteBuffer inc = ByteBuffer.wrap(this.cache);
        private final CharBuffer outc = CharBuffer.wrap(new char[4]);
        private final CharsetDecoder csd;

        private Generic(String enc) throws IOException {
            try {
                this.csd = Charset.forName(enc).newDecoder();
            }
            catch (Exception ex) {
                throw new DecodingException(ex);
            }
        }

        @Override
        int read(TextInput ti) throws IOException {
            int ch;
            int c = -1;
            while (++c < 4 && (ch = ti.readByte()) >= 0) {
                this.cache[c] = (byte)ch;
                this.outc.position(0);
                this.inc.position(0);
                this.inc.limit(c + 1);
                this.csd.reset();
                CoderResult cr = this.csd.decode(this.inc, this.outc, true);
                if (cr.isMalformed()) continue;
                int i = 0;
                int os = this.outc.position();
                for (int o = 0; o < os; ++o) {
                    i |= this.outc.get(o) << (o << 3);
                }
                return i;
            }
            return c == 0 ? -1 : this.invalid(c);
        }
    }

    private static class UTF32
    extends TextDecoder {
        private UTF32() {
        }

        @Override
        int read(TextInput ti) throws IOException {
            int a = ti.readByte();
            if (a < 0) {
                return a;
            }
            int b = ti.readByte();
            if (b < 0) {
                return this.invalid(b);
            }
            int c = ti.readByte();
            if (c < 0) {
                return this.invalid(c);
            }
            int d = ti.readByte();
            if (d < 0) {
                return this.invalid(d);
            }
            return a << 24 | b << 16 | c << 8 | d;
        }
    }

    private static class UTF16BE
    extends TextDecoder {
        private UTF16BE() {
        }

        @Override
        int read(TextInput ti) throws IOException {
            int a = ti.readByte();
            if (a < 0) {
                return a;
            }
            int b = ti.readByte();
            if (b < 0) {
                return this.invalid(b);
            }
            return a << 8 | b;
        }
    }

    private static class UTF16LE
    extends TextDecoder {
        private UTF16LE() {
        }

        @Override
        int read(TextInput ti) throws IOException {
            int a = ti.readByte();
            if (a < 0) {
                return a;
            }
            int b = ti.readByte();
            if (b < 0) {
                return this.invalid(b);
            }
            return a | b << 8;
        }
    }

    private static class UTF8
    extends TextDecoder {
        private final byte[] cache = new byte[4];

        private UTF8() {
        }

        @Override
        int read(TextInput ti) throws IOException {
            int ch = ti.readByte();
            if (ch < 128) {
                return ch;
            }
            if (ch < 192) {
                return this.invalid(ch);
            }
            this.cache[0] = (byte)ch;
            int cl = Token.cl((byte)ch);
            for (int c = 1; c < cl; ++c) {
                ch = ti.readByte();
                if (ch < 128) {
                    return this.invalid(ch);
                }
                this.cache[c] = (byte)ch;
            }
            return Token.cp(this.cache, 0);
        }
    }
}

