/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.basex.core.jobs.Job;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.io.out.BufferOutput;
import org.basex.util.Prop;
import org.basex.util.list.ByteList;
import org.basex.util.list.StringList;

public final class Zip
extends Job {
    private final IO file;
    private int total;
    private int curr;

    public Zip(IO file) {
        this.file = file;
    }

    private int size() throws IOException {
        try (ZipInputStream in = new ZipInputStream(this.file.inputStream());){
            int c = 0;
            while (in.getNextEntry() != null) {
                ++c;
            }
            int n = c;
            return n;
        }
    }

    public byte[] read(String path) throws IOException {
        try (ZipInputStream in = new ZipInputStream(this.file.inputStream());){
            byte[] cont = Zip.getEntry(in, path);
            if (cont == null) {
                throw new FileNotFoundException(path);
            }
            byte[] byArray = cont;
            return byArray;
        }
    }

    public void unzip(IOFile target) throws IOException {
        this.total = this.size();
        this.curr = 0;
        try (ZipInputStream in = new ZipInputStream(this.file.inputStream());){
            ZipEntry ze;
            while ((ze = in.getNextEntry()) != null) {
                ++this.curr;
                IOFile trg = new IOFile(target, ze.getName());
                if (ze.isDirectory()) {
                    trg.md();
                    continue;
                }
                trg.parent().md();
                trg.write(in);
            }
        }
    }

    public void zip(IOFile root, StringList files) throws IOException {
        if (!(this.file instanceof IOFile)) {
            throw new FileNotFoundException(this.file.path());
        }
        this.curr = 0;
        try (ZipOutputStream out = new ZipOutputStream(new BufferOutput((IOFile)this.file));){
            out.setLevel(1);
            this.total = files.size();
            byte[] data = new byte[4096];
            for (String f : files) {
                ++this.curr;
                FileInputStream in = new FileInputStream(new File(root.file(), f));
                Throwable throwable = null;
                try {
                    int c;
                    String fl = Prop.WIN ? f.replace('\\', '/') : f;
                    out.putNextEntry(new ZipEntry(root.name() + '/' + fl));
                    while ((c = in.read(data)) != -1) {
                        out.write(data, 0, c);
                    }
                    out.closeEntry();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        }
    }

    @Override
    public double progressInfo() {
        return (double)this.curr / (double)this.total;
    }

    private static byte[] getEntry(ZipInputStream in, String entry) throws IOException {
        ZipEntry ze;
        while ((ze = in.getNextEntry()) != null) {
            int c;
            if (!entry.equals(ze.getName())) continue;
            int s = (int)ze.getSize();
            if (s >= 0) {
                int c2;
                byte[] data = new byte[s];
                int o = 0;
                while (s - o != 0 && (c2 = in.read(data, o, s - o)) != -1) {
                    o += c2;
                }
                return data;
            }
            byte[] data = new byte[4096];
            ByteList bl = new ByteList();
            while ((c = in.read(data)) != -1) {
                bl.add(data, 0, c);
            }
            return bl.finish();
        }
        return null;
    }
}

