/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.transform.stream.StreamSource;
import org.basex.core.BaseXException;
import org.basex.core.StaticOptions;
import org.basex.core.Text;
import org.basex.io.IO;
import org.basex.io.IOStream;
import org.basex.io.in.BufferInput;
import org.basex.util.Base64;
import org.basex.util.Strings;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.xml.sax.InputSource;

public final class IOUrl
extends IO {
    private static final int TIMEOUT = 10;

    public IOUrl(String url) {
        super(url);
    }

    @Override
    public byte[] read() throws IOException {
        return BufferInput.get(this).content();
    }

    @Override
    public InputSource inputSource() {
        return new InputSource(this.pth);
    }

    @Override
    public StreamSource streamSource() {
        return new StreamSource(this.pth);
    }

    @Override
    public InputStream inputStream() throws IOException {
        URLConnection conn = null;
        try {
            conn = this.connection();
            return conn.getInputStream();
        }
        catch (IOException ex) {
            byte[] error;
            InputStream es;
            TokenBuilder msg = new TokenBuilder().add(ex);
            if (conn instanceof HttpURLConnection && (es = ((HttpURLConnection)conn).getErrorStream()) != null && (error = new IOStream(es).read()).length != 0) {
                msg.add(Text.NL).add(Text.INFORMATION).add(":").add(Text.NL).add(error);
            }
            IOException io = new IOException(msg.toString());
            io.setStackTrace(ex.getStackTrace());
            throw io;
        }
        catch (RuntimeException ex) {
            Util.debug(ex);
            throw new BaseXException(Text.NOT_PARSED_X, this.pth);
        }
    }

    public URLConnection connection() throws IOException {
        URL url = new URL(this.pth);
        URLConnection conn = url.openConnection();
        conn.setConnectTimeout(10000);
        String ui = url.getUserInfo();
        if (ui != null) {
            conn.setRequestProperty("Authorization", (Object)((Object)StaticOptions.AuthMethod.BASIC) + " " + Base64.encode(ui));
        }
        return conn;
    }

    @Override
    public boolean isDir() {
        return Strings.endsWith(this.pth, '/');
    }

    static boolean isValid(String url) {
        int ul = url.length();
        int u = url.indexOf(58);
        if (u < 2 || u + 1 == ul || url.charAt(u + 1) != '/') {
            return false;
        }
        while (--u >= 0) {
            char c = url.charAt(u);
            if (c >= 'a' && c <= 'z' || c == '+' || c == '-' || c == '.' || c == '_') continue;
            return false;
        }
        return true;
    }

    static String toFile(String uri) {
        try {
            String path = Paths.get(new URI(uri)).toString();
            return Strings.endsWith(uri, '/') || Strings.endsWith(uri, '\\') ? path + File.separator : path;
        }
        catch (Exception ex) {
            Util.errln(ex, new Object[0]);
            return uri;
        }
    }

    static boolean isFileURL(String url) {
        return url.startsWith("file:/");
    }

    public static void ignoreHostname() {
        HttpsURLConnection.setDefaultHostnameVerifier((hostname, session) -> true);
    }

    public static void ignoreCert() {
        IOUrl.ignoreHostname();
        TrustManager[] tm = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, tm, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception ex) {
            Util.errln(ex, new Object[0]);
        }
    }
}

