/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import javax.xml.transform.stream.StreamSource;
import org.basex.core.Databases;
import org.basex.io.IOContent;
import org.basex.io.IOFile;
import org.basex.io.IOUrl;
import org.basex.io.in.TextInput;
import org.basex.util.FTToken;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.xml.sax.InputSource;

public abstract class IO {
    public static final String TMPSUFFIX = ".tmp";
    public static final String BASEXSUFFIX = ".basex";
    public static final String BXSSUFFIX = ".bxs";
    public static final String XQSUFFIX = ".xq";
    public static final String XQMSUFFIX = ".xqm";
    public static final String XMLSUFFIX = ".xml";
    public static final String ZIPSUFFIX = ".zip";
    public static final String CSVSUFFIX = ".csv";
    public static final String JSONSUFFIX = ".json";
    public static final String JARSUFFIX = ".jar";
    public static final String TARGZSUFFIX = ".tar.gz";
    public static final String TGZSUFFIX = ".tgz";
    public static final String GZSUFFIX = ".gz";
    public static final String TARSUFFIX = ".tar";
    public static final String XARSUFFIX = ".xar";
    public static final String LOGSUFFIX = ".log";
    public static final String IGNORESUFFIX = ".ignore";
    public static final String RAW = "raw";
    public static final String FILEPREF = "file:/";
    public static final String[] XQSUFFIXES = new String[]{".xq", ".xqm", ".xqy", ".xql", ".xqu", ".xquery"};
    public static final String[] ZIPSUFFIXES = new String[]{".zip", ".gz", ".tgz", ".tar", ".xar", ".docx", ".pptx", ".xslx", ".odt", ".odp", ".ods", ".epub", ".idml"};
    public static final String[] XSLSUFFIXES = new String[]{".xsl", ".xslt", ".fo", ".fob"};
    public static final String[] HTMLSUFFIXES = new String[]{".html", ".htm"};
    public static final String[] TXTSUFFIXES = new String[]{".txt", ".text", ".ini", ".conf", ".md", ".log"};
    public static final String[] JSSUFFIXES = new String[]{".js", ".java", ".ts", ".vue"};
    public static final int BLOCKSIZE = 4096;
    public static final int NODEPOWER = 4;
    public static final int NODESIZE = 16;
    public static final int ENTRIES = 256;
    public static final int MAXATTS = 31;
    protected String pth;
    protected long len = -1L;
    private String nm;

    IO(String path) {
        this.pth = path;
        String p = Strings.endsWith(path, '/') ? path.substring(0, path.length() - 1) : path;
        this.nm = p.substring(p.lastIndexOf(47) + 1);
    }

    public static IO get(String location) {
        if (location == null) {
            return new IOContent("");
        }
        String s = location.trim();
        return s.indexOf(60) == 0 ? new IOContent(s) : (IOUrl.isFileURL(s) ? new IOFile(IOUrl.toFile(s)) : (IOUrl.isValid(s) ? new IOUrl(s) : (IOFile.isValid(s) ? new IOFile(s) : new IOContent(s))));
    }

    public abstract byte[] read() throws IOException;

    public final String string() throws IOException {
        return new TextInput(this).cache().toString();
    }

    public boolean exists() {
        return true;
    }

    public boolean isDir() {
        return false;
    }

    public boolean isAbsolute() {
        return true;
    }

    public final boolean hasSuffix(String ... suffixes) {
        return IO.checkSuffix(this.pth, suffixes);
    }

    public long timeStamp() {
        return System.currentTimeMillis();
    }

    public final void length(long length) {
        this.len = length;
    }

    public long length() {
        return this.len;
    }

    public abstract InputSource inputSource();

    public abstract StreamSource streamSource();

    public abstract InputStream inputStream() throws IOException;

    public final IO merge(String path) {
        if (path.isEmpty()) {
            return this;
        }
        IO io = IO.get(path);
        return io.isAbsolute() ? io : IO.get((Strings.endsWith(this.pth, '/') ? this.pth : this.dir()) + path);
    }

    public final boolean isArchive() {
        return this.hasSuffix(ZIPSUFFIXES);
    }

    public final String dbName() {
        TokenBuilder tb = new TokenBuilder();
        byte[] n = Token.token(this.name());
        int i = Token.lastIndexOf(n, 46);
        if (i == -1) {
            i = n.length;
        }
        for (int c = 0; c < i; c += Token.cl(n, c)) {
            int ch = FTToken.noDiacritics(Token.cp(n, c));
            if (!Databases.validChar(ch, c == 0 || c + 1 == i)) continue;
            tb.add(ch);
        }
        return tb.isEmpty() ? Integer.toString(this.hashCode()) : tb.toString();
    }

    public final String name() {
        return this.nm;
    }

    public final void name(String name) {
        this.nm = name;
        if (this.pth.isEmpty()) {
            this.pth = name;
        }
    }

    public final String path() {
        return this.pth;
    }

    public final String dir() {
        return this.pth.substring(0, this.pth.lastIndexOf(47) + 1);
    }

    public String url() {
        return this.pth;
    }

    public boolean eq(IO io) {
        return this.pth.equals(io.pth);
    }

    public String toString() {
        return this.pth;
    }

    public static boolean checkSuffix(String path, String ... suffixes) {
        int i = path.lastIndexOf(46);
        if (i == -1) {
            return false;
        }
        String suf = path.substring(i).toLowerCase(Locale.ENGLISH);
        for (String suffix : suffixes) {
            if (!suf.equals(suffix)) continue;
            return true;
        }
        return false;
    }
}

