/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.value;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.index.IndexCache;
import org.basex.index.IndexEntry;
import org.basex.index.IndexType;
import org.basex.index.query.EntryIterator;
import org.basex.index.query.IndexEntries;
import org.basex.index.query.IndexIterator;
import org.basex.index.query.IndexSearch;
import org.basex.index.query.NumericRange;
import org.basex.index.query.StringRange;
import org.basex.index.stats.IndexStats;
import org.basex.index.value.ValueCache;
import org.basex.index.value.ValueIndex;
import org.basex.io.random.DataAccess;
import org.basex.query.util.index.IndexCosts;
import org.basex.util.Num;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.IntObjMap;
import org.basex.util.list.IntList;

public class DiskValues
extends ValueIndex {
    final DataAccess idxr;
    final DataAccess idxl;
    final IndexCache cache = new IndexCache();
    final IntObjMap<byte[]> ctext = new IntObjMap();
    final AtomicInteger size = new AtomicInteger();
    private final Object monitor = new Object();

    public DiskValues(Data data, IndexType type) throws IOException {
        this(data, type, DiskValues.fileSuffix(type));
    }

    DiskValues(Data data, IndexType type, String pref) throws IOException {
        super(data, type);
        this.idxl = new DataAccess(data.meta.dbFile(pref + 'l'));
        this.idxr = new DataAccess(data.meta.dbFile(pref + 'r'));
        this.size.set(this.idxl.read4());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final byte[] info(MainOptions options) {
        TokenBuilder tb = new TokenBuilder();
        tb.add("- Structure: ").add("Sorted List").add(Text.NL);
        tb.add("- Names: ").add(this.data.meta.names(this.type)).add(Text.NL);
        IndexStats stats = new IndexStats(options.get(MainOptions.MAXSTAT));
        Object object = this.monitor;
        synchronized (object) {
            long l = this.idxl.length() + this.idxr.length();
            tb.add("- Size: ").add(Performance.format(l)).add(Text.NL);
            int entries = this.size();
            for (int index = 0; index < entries; ++index) {
                long pos = this.idxr.read5((long)index * 5L);
                int count = this.idxl.readNum(pos);
                if (!stats.adding(count)) continue;
                stats.add(this.key(this.idxl.readNum()), count);
            }
        }
        stats.print(tb);
        return tb.finish();
    }

    @Override
    public final int size() {
        return this.size.get();
    }

    @Override
    public final IndexCosts costs(IndexSearch search) {
        return IndexCosts.get(search instanceof StringRange ? Math.max(1, this.data.meta.size / 10) : (search instanceof NumericRange ? Math.max(1, this.data.meta.size / 3) : this.entry((byte[])search.token()).size));
    }

    @Override
    public final IndexIterator iter(IndexSearch search) {
        IntList pres;
        if (search instanceof StringRange) {
            pres = this.idRange((StringRange)search);
        } else if (search instanceof NumericRange) {
            pres = this.idRange((NumericRange)search);
        } else {
            IndexEntry ie = this.entry(search.token());
            pres = this.pres(ie.size, ie.offset);
        }
        return new IndexIterator(){
            final int sz;
            int c;
            {
                this.sz = pres.size();
            }

            @Override
            public boolean more() {
                return this.c < this.sz;
            }

            @Override
            public int pre() {
                return pres.get(this.c++);
            }

            @Override
            public int size() {
                return this.sz;
            }
        };
    }

    @Override
    public final boolean drop() {
        return this.data.meta.drop(DiskValues.fileSuffix(this.type) + '.');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        Object object = this.monitor;
        synchronized (object) {
            this.idxl.close();
            this.idxr.close();
        }
    }

    @Override
    public void add(ValueCache values) {
        throw Util.notExpected();
    }

    @Override
    public void delete(ValueCache values) {
        throw Util.notExpected();
    }

    @Override
    public final EntryIterator entries(IndexEntries entries) {
        byte[] token = entries.token();
        if (token.length == 0) {
            return this.keys(0, this.size(), entries.descending);
        }
        if (entries.prefix) {
            return this.keys(token);
        }
        int i = this.get(token);
        if (i < 0) {
            i = -i - 1;
        }
        return entries.descending ? this.keys(0, i, true) : this.keys(i, this.size(), false);
    }

    @Override
    public final void flush() {
        this.idxl.flush();
        this.idxr.flush();
    }

    protected int pre(int id) {
        return id;
    }

    protected final int get(byte[] key) {
        return this.get(key, 0, this.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int get(byte[] key, int first, int last) {
        int l = first;
        int h = last - 1;
        Object object = this.monitor;
        synchronized (object) {
            while (l <= h) {
                int m = l + h >>> 1;
                byte[] txt = this.indexEntry((int)m).key;
                int d = Token.diff(txt, key);
                if (d == 0) {
                    return m;
                }
                if (d < 0) {
                    l = m + 1;
                    continue;
                }
                h = m - 1;
            }
        }
        return -(l + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexEntry entry(byte[] token) {
        long offset;
        int count;
        IndexEntry entry = this.cache.get(token);
        if (entry != null) {
            return entry;
        }
        long index = this.get(token);
        if (index < 0L) {
            return new IndexEntry(token, 0, 0L);
        }
        Object object = this.monitor;
        synchronized (object) {
            long pos = this.idxr.read5(index * 5L);
            count = this.idxl.readNum(pos);
            offset = this.idxl.cursor();
        }
        return this.cache.add(token, count, offset);
    }

    private EntryIterator keys(final byte[] prefix) {
        final int first = this.get(prefix);
        final int sz = this.size();
        return new EntryIterator(){
            int c;
            IndexEntry entry;
            {
                this.c = first < 0 ? -first - 1 : first;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] next() {
                if (this.c < sz) {
                    Object object = DiskValues.this.monitor;
                    synchronized (object) {
                        this.entry = DiskValues.this.indexEntry(this.c++);
                        if (Token.startsWith(this.entry.key, prefix)) {
                            return this.entry.key;
                        }
                    }
                }
                return null;
            }

            @Override
            public int count() {
                return this.entry.size;
            }
        };
    }

    private EntryIterator keys(final int first, final int last, final boolean reverse) {
        final int sz = last - first;
        return new EntryIterator(){
            int c;
            IndexEntry entry;

            @Override
            public byte[] next() {
                return this.c < sz ? this.get(this.c++) : null;
            }

            @Override
            public int count() {
                return this.entry.size;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] get(int i) {
                Object object = DiskValues.this.monitor;
                synchronized (object) {
                    this.entry = DiskValues.this.indexEntry(reverse ? last - i - 1 : first + i);
                    return this.entry.key;
                }
            }

            @Override
            public int size() {
                return sz;
            }
        };
    }

    private IndexEntry indexEntry(int index) {
        IndexEntry entry;
        byte[] key = this.ctext.get(index);
        if (key != null && (entry = this.cache.get(key)) != null) {
            return entry;
        }
        long pos = this.idxr.read5((long)index * 5L);
        int count = this.idxl.readNum(pos);
        if (key == null) {
            key = this.key(this.idxl.readNum());
            this.ctext.put(index, key);
        }
        return this.cache.add(key, count, pos + (long)Num.length(count));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IntList pres(int sz, long offset) {
        IntList pres = new IntList(sz);
        Object object = this.monitor;
        synchronized (object) {
            this.idxl.cursor(offset);
            int id = 0;
            for (int i = 0; i < sz; ++i) {
                id += this.idxl.readNum();
                if (this.type == IndexType.TOKEN) {
                    this.idxl.readNum();
                }
                pres.add(this.pre(id));
            }
        }
        return pres;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IntList idRange(StringRange tok) {
        IntList pres = new IntList();
        Object object = this.monitor;
        synchronized (object) {
            int index;
            int i = this.get(tok.min);
            int entries = this.size();
            int n = i < 0 ? -i - 1 : (index = tok.mni ? i : i + 1);
            while (index < entries) {
                int count = this.idxl.readNum(this.idxr.read5((long)index * 5L));
                int id = this.idxl.readNum();
                int diff = Token.diff(this.key(id), tok.max);
                if (diff > 0 || !tok.mxi && diff == 0) break;
                for (int c = 0; c < count; ++c) {
                    pres.add(this.pre(id));
                    id += this.idxl.readNum();
                }
                ++index;
            }
        }
        return pres.sort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IntList idRange(NumericRange tok) {
        double min = tok.min;
        double max = tok.max;
        int len = max > 0.0 && (double)((long)max) == max ? Token.token(max).length : 0;
        boolean simple = len != 0 && min > 0.0 && (double)((long)min) == min && Token.token(min).length == len;
        IntList pres = new IntList();
        Object object = this.monitor;
        synchronized (object) {
            int entries = this.size();
            boolean text = this.type == IndexType.TEXT;
            for (int index = 0; index < entries; ++index) {
                int count = this.idxl.readNum(this.idxr.read5((long)index * 5L));
                int id = this.idxl.readNum();
                int pre = this.pre(id);
                double v = this.data.textDbl(pre, text);
                if (v >= min && v <= max) {
                    for (int c = 0; c < count; ++c) {
                        pres.add(this.pre(id));
                        id += this.idxl.readNum();
                    }
                    continue;
                }
                if (simple && v > max && this.data.textLen(pre, text) == len) break;
            }
        }
        return pres.sort();
    }

    private byte[] key(int id) {
        byte[] text = this.data.text(this.pre(id), this.type == IndexType.TEXT);
        return this.type == IndexType.TOKEN ? Token.distinctTokens(text)[this.idxl.readNum()] : text;
    }

    public final String toString(boolean all) {
        TokenBuilder tb = new TokenBuilder();
        tb.add((Object)this.type).add(" INDEX, '").add(this.data.meta.name).add("':\n");
        int entries = this.size();
        for (int index = 0; index < entries; ++index) {
            long pos = this.idxr.read5((long)index * 5L);
            int count = this.idxl.readNum(pos);
            int id = this.idxl.readNum();
            tb.add("  ").addInt(index).add(". offset: ").addLong(pos);
            if (all) {
                tb.add(", key: \"").add(this.key(id)).add(34);
                tb.add(", ids").add("/pres").add(": ").addInt(id).add(47).addInt(this.pre(id));
            } else {
                tb.add(", ids").add(": ").addInt(id);
            }
            for (int c = 1; c < count; ++c) {
                tb.add(",").addInt(id += this.idxl.readNum());
                if (!all) continue;
                tb.add(47).addInt(this.pre(id));
            }
            tb.add("\n");
        }
        return tb.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    static String fileSuffix(IndexType type) {
        return type == IndexType.TOKEN ? "tok" : (type == IndexType.TEXT ? "txt" : "atv");
    }
}

