/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import org.basex.gui.GUIConstants;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPanel;
import org.basex.gui.layout.BaseXWindow;
import org.basex.util.options.NumberOption;
import org.basex.util.options.Options;

public final class BaseXSlider
extends BaseXPanel {
    private static final int DWIDTH = 120;
    private static final double SLIDERW = 20.0;
    private final BaseXDialog dialog;
    private final int min;
    private final int max;
    private Options options;
    private NumberOption option;
    private int value;
    private int oldValue = -1;
    private int mouseX;

    public BaseXSlider(BaseXWindow win, int min, int max, NumberOption option, Options options) {
        this(win, min, max, options.get(option));
        this.options = options;
        this.option = option;
    }

    public BaseXSlider(BaseXWindow win, int min, int max, int value) {
        super(win);
        this.min = min;
        this.max = max;
        this.value = value;
        this.dialog = win.dialog();
        this.setOpaque(false);
        this.setFocusable(true);
        this.setPreferredSize(new Dimension(120, (int)((double)this.getFont().getSize() * 1.2)));
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                BaseXSlider.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                BaseXSlider.this.repaint();
            }
        });
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int v) {
        this.value = v;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int w = this.getWidth();
        int h = this.getHeight();
        int hh = h / 2;
        int s = 3;
        g.setColor(this.hasFocus() ? GUIConstants.BACK : GUIConstants.lgray);
        g.fillRect(0, hh - 3, w, 5);
        g.setColor(GUIConstants.TEXT);
        g.drawLine(0, hh - 3, w, hh - 3);
        g.drawLine(0, hh - 3, 0, hh + 3 - 1);
        g.setColor(GUIConstants.gray);
        g.drawLine(w - 1, hh - 3, w - 1, hh + 3 - 1);
        g.drawLine(0, hh + 3 - 1, w, hh + 3 - 1);
        double x = (double)(this.value - this.min) * ((double)w - 20.0) / (double)(this.max - this.min);
        BaseXLayout.drawCell(g, (int)x, (int)(x + 20.0), hh - 6, hh + 6, this.oldValue != -1);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouseX = e.getX();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.requestFocusInWindow();
        this.mouseX = e.getX();
        double w = (double)this.getWidth() - 20.0;
        double r = this.max - this.min;
        double x = (double)(this.value - this.min) * w / r;
        if ((double)this.mouseX < x || (double)this.mouseX >= x + 20.0) {
            this.value = (int)((double)this.mouseX * r / w + (double)this.min);
            this.notifyListeners();
        }
        this.oldValue = this.value;
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.oldValue = -1;
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        double prop = (double)((this.max - this.min) * (this.mouseX - e.getX())) / ((double)this.getWidth() - 20.0);
        int old = this.value;
        this.value = Math.max(this.min, Math.min(this.max, (int)((double)this.oldValue - prop)));
        if (this.value != old) {
            this.notifyListeners();
        }
        this.repaint();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int old = this.value;
        if (BaseXKeys.PREVCHAR.is(e) || BaseXKeys.PREVLINE.is(e)) {
            this.value = Math.max(this.min, this.value - 1);
        } else if (BaseXKeys.NEXTCHAR.is(e) || BaseXKeys.NEXTLINE.is(e)) {
            this.value = Math.min(this.max, this.value + 1);
        } else if (BaseXKeys.NEXTPAGE.is(e)) {
            this.value = Math.max(this.min, this.value + 10);
        } else if (BaseXKeys.PREVPAGE.is(e)) {
            this.value = Math.min(this.max, this.value - 10);
        } else if (BaseXKeys.LINESTART.is(e)) {
            this.value = this.min;
        } else if (BaseXKeys.LINEEND.is(e)) {
            this.value = this.max;
        }
        if (this.value != old) {
            this.notifyListeners();
        }
        this.repaint();
    }

    private void notifyListeners() {
        if (this.dialog != null) {
            this.dialog.action(null);
        }
        for (ActionListener al : (ActionListener[])this.listenerList.getListeners(ActionListener.class)) {
            al.actionPerformed(null);
        }
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void assign() {
        this.options.set(this.option, this.value);
    }
}

