/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import org.basex.core.Lang;
import org.basex.core.StaticOptions;
import org.basex.core.Text;
import org.basex.core.cmd.Close;
import org.basex.gui.GUI;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXFileChooser;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.BaseXWindow;
import org.basex.gui.layout.ColumnLayout;
import org.basex.gui.layout.RowLayout;
import org.basex.io.IOFile;
import org.basex.util.Util;
import org.basex.util.options.Options;

final class DialogGeneralPrefs
extends BaseXBack {
    private final GUI gui;
    private static final String[][] LANGS = Lang.parse();
    private final BaseXTextField dbPath;
    private final BaseXTextField repoPath;
    private final BaseXTextField xmlSuffixes;
    private final BaseXLabel creds;
    private final BaseXCombo lang;
    private final BaseXButton dbButton;
    private final BaseXButton repoButton;

    DialogGeneralPrefs(BaseXDialog dialog) {
        this.border(8).setLayout(new RowLayout());
        this.gui = dialog.gui;
        StaticOptions opts = this.gui.context.soptions;
        this.dbPath = new BaseXTextField(dialog, opts.get(StaticOptions.DBPATH));
        this.repoPath = new BaseXTextField(dialog, opts.get(StaticOptions.REPOPATH));
        this.xmlSuffixes = new BaseXTextField(dialog, GUIOptions.XMLSUFFIXES, (Options)this.gui.gopts);
        this.xmlSuffixes.hint(GUIOptions.XMLSUFFIXES.value());
        this.dbButton = new BaseXButton(dialog, Text.BROWSE_D);
        this.dbButton.addActionListener(e -> {
            String path = this.dbPath.getText();
            IOFile dir = new BaseXFileChooser(dialog, Text.CHOOSE_DIR, path).select(BaseXFileChooser.Mode.DOPEN);
            if (dir != null) {
                this.dbPath.setText(dir.path());
            }
        });
        this.repoButton = new BaseXButton(dialog, Text.BROWSE_D);
        this.repoButton.addActionListener(e -> {
            String path = this.repoPath.getText();
            IOFile dir = new BaseXFileChooser(dialog, Text.CHOOSE_DIR, path).select(BaseXFileChooser.Mode.DOPEN);
            if (dir != null) {
                this.repoPath.setText(dir.path());
            }
        });
        this.lang = new BaseXCombo((BaseXWindow)dialog, LANGS[0]);
        this.lang.setSelectedItem(opts.get(StaticOptions.LANG));
        this.creds = new BaseXLabel(" ");
        this.add(new BaseXLabel(Text.DATABASE_PATH + ":", true, true));
        BaseXBack p = new BaseXBack(new ColumnLayout(8));
        p.add(this.dbPath);
        p.add(this.dbButton);
        this.add(p);
        this.add(new BaseXLabel(Text.REPOSITORY_PATH + ":", true, true));
        p = new BaseXBack(new ColumnLayout(8));
        p.add(this.repoPath);
        p.add(this.repoButton);
        this.add(p);
        this.add(new BaseXLabel(Util.info(Text.FILE_SUFFIXES_X, "XML") + ":", true, true));
        p = new BaseXBack(new ColumnLayout(8));
        p.add(this.xmlSuffixes);
        this.add(p);
        this.add(new BaseXLabel(Text.LANGUAGE_RESTART + ":", true, true).border(8, 0, 8, 0));
        p = new BaseXBack(new ColumnLayout(12));
        p.add(this.lang);
        p.add(this.creds);
        this.add(p);
    }

    static String creds(String lng) {
        int ll = LANGS[0].length;
        for (int l = 0; l < ll; ++l) {
            if (!LANGS[0][l].equals(lng)) continue;
            return LANGS[1][l];
        }
        return "";
    }

    boolean action(Object source) {
        StaticOptions opts = this.gui.context.soptions;
        if (source == this.dbPath || source == this.dbButton) {
            String dbpath = this.dbPath.getText();
            if (!opts.get(StaticOptions.DBPATH).equals(dbpath) && this.gui.context.data() != null) {
                Close.close(this.gui.context);
                this.gui.notify.init();
            }
            opts.set(StaticOptions.DBPATH, dbpath);
        } else if (source == this.repoPath || source == this.repoButton) {
            this.gui.context.repo.reset();
            opts.set(StaticOptions.REPOPATH, this.repoPath.getText());
        }
        opts.set(StaticOptions.LANG, this.lang.getSelectedItem());
        this.xmlSuffixes.assign();
        this.creds.setText(Text.TRANSLATION + ": " + DialogGeneralPrefs.creds(this.lang.getSelectedItem()));
        return true;
    }
}

