/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXCheckBox;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXList;
import org.basex.gui.layout.GUIWorker;
import org.basex.gui.layout.TableLayout;
import org.basex.util.list.StringList;

public final class DialogFonts
extends BaseXDialog {
    private static final String[] SIZES = new String[]{"7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "22", "24", "26", "28", "30", "33", "36", "40", "48", "64", "96"};
    private static DialogFonts dialog;
    private final String[] fonts;
    private String[] monoFonts;
    private final BaseXList font;
    private final BaseXList font2;
    private final BaseXList type;
    private final BaseXList size;
    private final BaseXCheckBox onlyMono;

    private DialogFonts(GUI gui) {
        super(gui, Text.CHOOSE_FONT, false);
        GUIOptions gopts = gui.gopts;
        this.fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        BaseXBack p = new BaseXBack(new TableLayout(2, 4, 8, 0));
        this.font = new BaseXList((BaseXDialog)this, this.fonts);
        this.font.setWidth(200);
        p.add(this.font);
        this.font2 = new BaseXList((BaseXDialog)this, this.fonts);
        this.font2.setWidth(200);
        p.add(this.font2);
        this.type = new BaseXList((BaseXDialog)this, Text.FONT_TYPES);
        this.type.setWidth(90);
        p.add(this.type);
        this.size = new BaseXList((BaseXDialog)this, SIZES);
        this.size.setWidth(50);
        p.add(this.size);
        this.font.setValue(gopts.get(GUIOptions.FONT));
        this.font2.setValue(gopts.get(GUIOptions.MONOFONT));
        this.font2.setEnabled(false);
        this.type.setValue(Text.FONT_TYPES[gopts.get(GUIOptions.FONTTYPE)]);
        this.font.setValue(gopts.get(GUIOptions.FONT));
        p.add(new BaseXBack());
        this.onlyMono = new BaseXCheckBox(this, "Monospace", GUIOptions.ONLYMONO, gopts);
        p.add(this.onlyMono);
        this.set(p, "Center");
        this.finish();
        this.monoFonts();
        this.action(this.onlyMono);
    }

    public static void show(GUI gui) {
        if (dialog == null) {
            dialog = new DialogFonts(gui);
        }
        dialog.setVisible(true);
        DialogFonts.dialog.size.setValue(Integer.toString(gui.gopts.get(GUIOptions.FONTSIZE)));
    }

    @Override
    public void action(Object cmp) {
        GUIOptions gopts = this.gui.gopts;
        if (cmp == this.onlyMono) {
            boolean selected = this.onlyMono.isSelected();
            gopts.set(GUIOptions.ONLYMONO, selected);
            if (selected) {
                String[] stringArray;
                boolean ready = this.monoFonts != null;
                this.font2.setEnabled(ready);
                if (ready) {
                    stringArray = this.monoFonts;
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = Text.PLEASE_WAIT_D;
                }
                this.font2.setData(stringArray);
            } else {
                this.font2.setEnabled(true);
                this.font2.setData(this.fonts);
            }
            this.font2.setValue(gopts.get(GUIOptions.MONOFONT));
        } else {
            int num;
            boolean changed = false;
            if (cmp == this.font) {
                String name = this.font.getValue();
                if (!name.isEmpty()) {
                    gopts.set(GUIOptions.FONT, name);
                    changed = true;
                }
            } else if (cmp == this.font2) {
                String name = this.font2.getValue();
                if (!name.isEmpty()) {
                    gopts.set(GUIOptions.MONOFONT, name);
                    changed = true;
                }
            } else if (cmp == this.size) {
                int num2 = this.size.getNum();
                if (num2 > 0) {
                    gopts.set(GUIOptions.FONTSIZE, num2);
                    changed = true;
                }
            } else if (cmp == this.type && (num = this.type.getIndex()) >= 0) {
                gopts.set(GUIOptions.FONTTYPE, num);
                changed = true;
            }
            if (changed) {
                int t = gopts.get(GUIOptions.FONTTYPE);
                this.font.setFont(gopts.get(GUIOptions.FONT), t);
                this.font2.setFont(gopts.get(GUIOptions.MONOFONT), t);
                this.gui.updateLayout();
            }
        }
    }

    private void monoFonts() {
        new GUIWorker<Boolean>(){

            @Override
            protected Boolean doInBackground() {
                Graphics g = DialogFonts.this.getGraphics();
                StringList monos = new StringList();
                for (String name : DialogFonts.this.fonts) {
                    FontMetrics fm = g.getFontMetrics(new Font(name, 0, 128));
                    if (fm.charWidth(' ') != fm.charWidth('M')) continue;
                    monos.add(name);
                }
                DialogFonts.access$102(DialogFonts.this, (String[])monos.finish());
                return DialogFonts.this.gui.gopts.get(GUIOptions.ONLYMONO);
            }

            @Override
            protected void done(Boolean mono) {
                if (mono.booleanValue()) {
                    DialogFonts.this.action(DialogFonts.this.onlyMono);
                }
            }
        }.execute();
    }

    static /* synthetic */ String[] access$102(DialogFonts x0, String[] x1) {
        x0.monoFonts = x1;
        return x1;
    }
}

