/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.util.HashMap;
import java.util.Map;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXTextField;

public final class DialogBindings
extends BaseXDialog {
    private static final int MAX = 8;
    private final BaseXTextField[] names = new BaseXTextField[8];
    private final BaseXTextField[] values = new BaseXTextField[8];
    private final BaseXTextField ctxitem;

    public DialogBindings(GUI gui) {
        super(gui, Text.EXTERNAL_VARIABLES);
        ((BorderLayout)this.panel.getLayout()).setHgap(4);
        BaseXBack west = new BaseXBack(new GridLayout(10, 1, 0, 4));
        west.add(new BaseXLabel(Text.NAME + ": ", false, true));
        for (int c = 0; c < 8; ++c) {
            this.names[c] = new BaseXTextField(this);
            BaseXLayout.setWidth(this.names[c], 100);
            west.add(this.names[c]);
        }
        west.add(new BaseXLabel("Context item: "));
        this.set(west, "West");
        BaseXBack center = new BaseXBack(new GridLayout(10, 1, 0, 4));
        center.add(new BaseXLabel(Text.VALUE + ": ", false, true));
        for (int c = 0; c < 8; ++c) {
            this.values[c] = new BaseXTextField(this);
            BaseXLayout.setWidth(this.values[c], 250);
            center.add(this.values[c]);
        }
        this.ctxitem = new BaseXTextField(this);
        this.ctxitem.hint(gui.editor.context());
        center.add(this.ctxitem);
        this.set(center, "Center");
        this.set(this.okCancel(), "South");
        this.fill();
        this.ok = true;
        this.setResizable(true);
        this.finish();
    }

    private void fill() {
        MainOptions opts = this.gui.context.options;
        int c = 0;
        for (Map.Entry<String, String> entry : opts.toMap(MainOptions.BINDINGS).entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (name.isEmpty()) {
                this.ctxitem.setText(value);
                continue;
            }
            if (c >= 8) continue;
            this.names[c].setText('$' + name.replaceAll("^\\$", ""));
            this.values[c].setText(value);
            ++c;
        }
        while (c < 8) {
            this.names[c].setText("$");
            this.values[c].setText("");
            ++c;
        }
    }

    @Override
    public void close() {
        if (!this.ok) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int c = 0; c < 8; ++c) {
            String name = this.names[c].getText().replaceAll("^\\s*\\$|\\s+$", "");
            if (name.isEmpty()) continue;
            map.put(name, this.values[c].getText());
        }
        String value = this.ctxitem.getText();
        if (!value.isEmpty()) {
            map.put("", value);
        }
        DialogBindings.assign(map, this.gui);
        this.gui.editor.refreshContextLabel();
        super.close();
    }

    public static void assign(Map<String, String> map, GUI gui) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (sb.length() != 0) {
                sb.append(',');
            }
            sb.append((name + '=' + value).replaceAll(",", ",,"));
        }
        gui.set(MainOptions.BINDINGS, sb.toString());
    }
}

