/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.Databases;
import org.basex.core.Datas;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.cmd.Close;
import org.basex.core.users.Perm;
import org.basex.data.Data;
import org.basex.data.DiskData;
import org.basex.data.MetaData;
import org.basex.query.value.seq.DBNodes;
import org.basex.util.Util;

public final class Open
extends Command {
    public Open(String name) {
        this(name, null);
    }

    public Open(String name, String path) {
        super(Perm.NONE, name, path == null ? "" : path);
    }

    @Override
    protected boolean run() {
        String db = this.args[0];
        if (!Databases.validName(db)) {
            return this.error(Text.NAME_INVALID_X, db);
        }
        Data data = this.context.data();
        if (data == null || !data.meta.name.equals(db)) {
            Close.close(this.context);
            try {
                data = Open.open(db, this.context, this.options);
                this.context.openDB(data);
                String path = this.args[1];
                if (!path.isEmpty()) {
                    this.context.current(new DBNodes(data, data.resources.docs(path).toArray()));
                }
                if (data.meta.oldindex()) {
                    this.info(Text.H_INDEX_FORMAT, new Object[0]);
                }
                if (data.meta.corrupt) {
                    this.info(Text.DB_CORRUPT, new Object[0]);
                }
            }
            catch (IOException ex) {
                return this.error(Util.message(ex), new Object[0]);
            }
        }
        return this.info(Text.DB_OPENED_X, db, this.jc().performance);
    }

    @Override
    public void addLocks() {
        this.jc().locks.reads.add("internal:context").add(this.args[0]);
    }

    @Override
    public boolean newData(Context ctx) {
        return Close.close(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Data open(String name, Context context, MainOptions options) throws IOException {
        if (!context.perm(Perm.READ, name)) {
            throw new BaseXException(Text.PERM_REQUIRED_X, new Object[]{Perm.READ});
        }
        Datas datas = context.datas;
        synchronized (datas) {
            Data data = context.datas.pin(name);
            if (data == null) {
                if (!context.soptions.dbExists(name)) {
                    throw new BaseXException(Text.DB_NOT_FOUND_X, name);
                }
                MetaData meta = new MetaData(name, options, context.soptions);
                if (meta.updateFile().exists()) {
                    throw new BaseXException(Text.DB_UPDATED_X, meta.name);
                }
                data = new DiskData(meta);
                context.datas.pin(data);
            }
            return data;
        }
    }
}

