/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.Command;
import org.basex.core.Databases;
import org.basex.core.Text;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.Open;
import org.basex.core.locks.Locks;
import org.basex.core.users.Perm;
import org.basex.data.Data;
import org.basex.data.DataText;
import org.basex.data.MetaData;
import org.basex.index.resource.Resources;
import org.basex.util.Table;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.http.MediaType;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

public final class List
extends Command {
    public List() {
        this(null);
    }

    public List(String name) {
        this(name, null);
    }

    public List(String name, String path) {
        super(Perm.NONE, name == null ? "" : name, path == null ? "" : path);
    }

    @Override
    protected boolean run() throws IOException {
        return this.args[0].isEmpty() ? this.list() : this.listDB();
    }

    @Override
    public void addLocks() {
        Locks locks = this.jc().locks;
        if (this.args[0].isEmpty()) {
            locks.reads.addGlobal();
        } else {
            locks.reads.add(this.args[0]);
        }
    }

    private boolean list() throws IOException {
        Table table = new Table();
        table.description = Text.DATABASES_X;
        boolean create = this.context.user().has(Perm.CREATE);
        table.header.add(Text.NAME);
        table.header.add(Text.RESOURCES);
        table.header.add(Text.SIZE);
        if (create) {
            table.header.add(Text.INPUT_PATH);
        }
        for (String name : this.context.listDBs()) {
            String file;
            long dbsize = 0L;
            int count = 0;
            try {
                MetaData meta = new MetaData(name, this.options, this.soptions);
                meta.read();
                dbsize = meta.dbSize();
                file = meta.original;
                count = meta.ndocs + meta.binaryDir().descendants().size();
            }
            catch (IOException ex) {
                Util.debug(ex);
                file = Text.ERROR;
            }
            TokenList tl = new TokenList(create ? 4L : 3L);
            tl.add(name);
            tl.add(count);
            tl.add(dbsize);
            if (create) {
                tl.add(file);
            }
            table.contents.add(tl);
        }
        this.out.println(table.sort().finish());
        return true;
    }

    private boolean listDB() throws IOException {
        String db = this.args[0];
        String path = this.args[1];
        if (!Databases.validName(db)) {
            return this.error(Text.NAME_INVALID_X, db);
        }
        Table table = new Table();
        table.description = Text.RESOURCES_X;
        table.header.add(Text.INPUT_PATH);
        table.header.add(Text.TYPE);
        table.header.add(DataText.CONTENT_TYPE);
        table.header.add(Text.SIZE);
        try {
            Data data = Open.open(db, this.context, this.options);
            Resources resources = data.resources;
            IntList il = resources.docs(path);
            int ds = il.size();
            for (int i = 0; i < ds; ++i) {
                int pre = il.get(i);
                TokenList tl = new TokenList(4L);
                tl.add(data.text(pre, true));
                tl.add(Token.XML);
                tl.add(MediaType.APPLICATION_XML.toString());
                tl.add(data.size(pre, 0));
                table.contents.add(tl);
            }
            for (byte[] file : resources.binaries(path)) {
                String bin = Token.string(file);
                TokenList tl = new TokenList(4L);
                tl.add(file);
                tl.add("raw");
                tl.add(MediaType.get(bin).toString());
                tl.add(data.meta.binary(bin).length());
                table.contents.add(tl);
            }
            Close.close(data, this.context);
        }
        catch (IOException ex) {
            return this.error(Util.message(ex), new Object[0]);
        }
        this.out.println(table.sort().finish());
        return true;
    }
}

