/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import org.basex.core.Databases;
import org.basex.core.StaticOptions;
import org.basex.core.Text;
import org.basex.core.cmd.ABackup;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.core.users.Perm;
import org.basex.util.list.StringList;

public final class DropBackup
extends ABackup {
    public DropBackup(String name) {
        super(name);
    }

    @Override
    protected boolean run() {
        String pattern = this.args[0];
        if (!Databases.validPattern(pattern)) {
            return this.error(Text.NAME_INVALID_X, pattern);
        }
        StringList dbs = this.context.listDBs(pattern);
        if (dbs.isEmpty() && this.context.perm(Perm.READ, pattern)) {
            dbs.add(pattern);
        }
        for (String db : dbs) {
            for (String backup : this.context.databases.backups(db)) {
                DropBackup.drop(backup, this.soptions);
            }
        }
        return this.info(Text.BACKUP_DROPPED_X, pattern);
    }

    public static boolean drop(String name, StaticOptions sopts) {
        return sopts.dbPath(name + ".zip").delete();
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.DROP) + " " + (Object)((Object)Commands.CmdDrop.BACKUP)).args();
    }
}

