/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.basex.core.Databases;
import org.basex.core.StaticOptions;
import org.basex.core.Text;
import org.basex.core.cmd.ABackup;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.io.IOFile;
import org.basex.io.in.BufferInput;
import org.basex.io.out.BufferOutput;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class AlterBackup
extends ABackup {
    public AlterBackup(String db, String name) {
        super(db, name);
    }

    @Override
    protected boolean run() {
        String db = this.args[0];
        String name = this.args[1];
        if (!Databases.validName(db)) {
            return this.error(Text.NAME_INVALID_X, db);
        }
        if (!Databases.validName(name)) {
            return this.error(Text.NAME_INVALID_X, name);
        }
        StringList backups = this.context.databases.backups(db);
        if (backups.isEmpty()) {
            return this.error(Text.BACKUP_NOT_FOUND_X, db);
        }
        boolean ok = true;
        for (String backup : backups) {
            try {
                AlterBackup.alter(backup, name, this.soptions);
                this.info(Text.BACKUP_RENAMED_X, backup);
            }
            catch (IOException ex) {
                Util.debug(ex);
                this.info(Text.BACKUP_NOT_RENAMED_X, backup);
                ok = false;
            }
        }
        return ok;
    }

    public static void alter(String db, String name, StaticOptions sopts) throws IOException {
        IOFile src = sopts.dbPath(db + ".zip");
        IOFile trg = sopts.dbPath(name + '-' + Databases.date(db) + ".zip");
        byte[] data = new byte[4096];
        try (BufferInput bi = new BufferInput(src);
             ZipInputStream in = new ZipInputStream(bi);
             BufferOutput bo = new BufferOutput(trg);
             ZipOutputStream out = new ZipOutputStream(bo);){
            ZipEntry ze;
            while ((ze = in.getNextEntry()) != null) {
                int c;
                out.putNextEntry(new ZipEntry(name + '/' + ze.getName().replaceAll("^.*/", "")));
                while ((c = in.read(data)) != -1) {
                    out.write(data, 0, c);
                }
            }
        }
        src.delete();
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.ALTER) + " " + (Object)((Object)Commands.CmdDrop.BACKUP)).args();
    }
}

