"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PipelineWithChangeControl = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_codebuild_1 = require("aws-cdk-lib/aws-codebuild");
const aws_codepipeline_1 = require("aws-cdk-lib/aws-codepipeline");
const aws_codepipeline_actions_1 = require("aws-cdk-lib/aws-codepipeline-actions");
const constructs_1 = require("constructs");
const change_controller_1 = require("../time-windows/change-controller/change-controller");
class PipelineWithChangeControl extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const sourceOutput = new aws_codepipeline_1.Artifact('SourceOutput');
        const buildOutput = new aws_codepipeline_1.Artifact('BuildOutput');
        const pipeline = new aws_codepipeline_1.Pipeline(this, 'Pipeline', {
            pipelineName: props.pipelineName,
            role: props.pipelineRole,
        });
        // Source Stage
        const sourceStage = pipeline.addStage({
            stageName: 'Source',
        });
        const sourceAction = new aws_codepipeline_actions_1.CodeCommitSourceAction({
            actionName: 'CodeCommitSource',
            branch: 'main',
            trigger: aws_codepipeline_actions_1.CodeCommitTrigger.EVENTS,
            repository: props.sourceRepository,
            output: sourceOutput,
        });
        sourceStage.addAction(sourceAction);
        // Build stage
        const buildStage = pipeline.addStage({
            stageName: 'Build',
        });
        const buildProject = new aws_codebuild_1.PipelineProject(this, 'BuildStageProject', {
            buildSpec: aws_codebuild_1.BuildSpec.fromObject({
                version: '0.2',
                phases: {
                    install: {
                        'runtime-versions': {
                            nodejs: 16,
                        },
                        // eslint-disable-next-line quote-props
                        commands: ['yarn install'],
                    },
                    build: {
                        commands: ['echo Build started on `date`', 'yarn build'],
                    },
                    post_build: {
                        commands: ['echo Build completed on `date`'],
                    },
                },
                artifacts: {
                    files: ['build/**/*', 'node_modules/**/*', 'src/*'],
                },
            }),
            environment: {
                buildImage: aws_codebuild_1.LinuxBuildImage.AMAZON_LINUX_2_4,
                privileged: true,
                computeType: aws_codebuild_1.ComputeType.SMALL,
            },
        });
        const buildAction = new aws_codepipeline_actions_1.CodeBuildAction({
            actionName: 'BuildAction',
            project: buildProject,
            input: sourceOutput,
            outputs: [buildOutput],
        });
        buildStage.addAction(buildAction);
        // Deploy Stage
        const deployStage = pipeline.addStage({
            stageName: 'Deploy',
        });
        // CodeBuild Deploy Project
        const deployProject = new aws_codebuild_1.PipelineProject(this, 'DeployStageProject', {
            buildSpec: aws_codebuild_1.BuildSpec.fromObject({
                version: '0.2',
                phases: {
                    install: {
                        'runtime-versions': {
                            nodejs: 16,
                        },
                        // eslint-disable-next-line quote-props
                        commands: ['npm install -g aws-cdk'],
                    },
                    build: {
                        commands: ['echo Deploy started on `date`', 'cdk deploy'],
                    },
                    post_build: {
                        commands: ['echo Deploy completed on `date`'],
                    },
                },
            }),
            environment: {
                buildImage: aws_codebuild_1.LinuxBuildImage.AMAZON_LINUX_2_4,
                privileged: true,
                computeType: aws_codebuild_1.ComputeType.SMALL,
            },
        });
        // CodeBuild Deploy Action
        const deployAction = new aws_codepipeline_actions_1.CodeBuildAction({
            actionName: 'DeployAction',
            project: deployProject,
            input: buildOutput,
        });
        // Add Deploy Action to Stage
        deployStage.addAction(deployAction);
        // Add Change Controller
        props.changeControlCalendar._bind(this);
        pipeline.stages.forEach((stage) => {
            new change_controller_1.ChangeController(this, `change-controller-${stage.stageName}`, {
                calendar: props.changeControlCalendar,
                stage,
                schedule: props.changeControlCheckSchedule,
                searchTerms: props.searchTerms,
            });
        });
    }
}
exports.PipelineWithChangeControl = PipelineWithChangeControl;
_a = JSII_RTTI_SYMBOL_1;
PipelineWithChangeControl[_a] = { fqn: "@cdklabs/cdk-codepipeline-extensions.PipelineWithChangeControl", version: "0.0.3" };
//# sourceMappingURL=data:application/json;base64,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