/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.python;

import java.util.Objects;
import org.jpmml.python.Scope;
import org.jpmml.python.Token;

public abstract class AbstractTranslator {
    private Scope scope = null;

    public Scope ensureScope() {
        Scope scope = this.getScope();
        if (scope == null) {
            throw new IllegalStateException();
        }
        return scope;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = Objects.requireNonNull(scope);
    }

    protected static String translateBoolean(String image) {
        return image.toLowerCase();
    }

    protected static String translateInt(String image) {
        if (image.endsWith("l") || image.endsWith("L")) {
            return image.substring(0, image.length() - 1);
        }
        return image;
    }

    protected static String translateString(String image) {
        return image.substring(1, image.length() - 1);
    }

    protected static int parseInt(Token sign, Token value) {
        return Integer.parseInt((sign != null ? sign.image : "") + AbstractTranslator.translateInt(value.image));
    }
}

