/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.nearest_neighbor;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.nearest_neighbor.KNNInput;
import org.dmg.pmml.nearest_neighbor.PMMLElements;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="KNNInputs", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "knnInputs"})
@Added(value=Version.PMML_4_1)
@JsonRootName(value="KNNInputs")
@JsonPropertyOrder(value={"extensions", "knnInputs"})
public class KNNInputs
extends PMMLObject
implements Iterable<KNNInput>,
HasExtensions<KNNInputs> {
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    @XmlElement(name="KNNInput", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="KNNInput")
    private List<KNNInput> knnInputs;
    private static final long serialVersionUID = 67371270L;

    public KNNInputs() {
    }

    @ValueConstructor
    public KNNInputs(@Property(value="knnInputs") List<KNNInput> knnInputs) {
        this.knnInputs = knnInputs;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public KNNInputs addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public Iterator<KNNInput> iterator() {
        return this.requireKNNInputs().iterator();
    }

    public boolean hasKNNInputs() {
        return this.knnInputs != null && !this.knnInputs.isEmpty();
    }

    public List<KNNInput> requireKNNInputs() {
        if (this.knnInputs == null || this.knnInputs.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.KNNINPUTS_KNNINPUTS);
        }
        return this.knnInputs;
    }

    public List<KNNInput> getKNNInputs() {
        if (this.knnInputs == null) {
            this.knnInputs = new ArrayList<KNNInput>();
        }
        return this.knnInputs;
    }

    public KNNInputs addKNNInputs(KNNInput ... knnInputs) {
        this.getKNNInputs().addAll(Arrays.asList(knnInputs));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE && this.hasKNNInputs()) {
                status = PMMLObject.traverse(visitor, this.getKNNInputs());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

