#
# This file is part of Invenio.
# Copyright (C) 2016-2018 CERN.
#
# Invenio is free software; you can redistribute it and/or modify it
# under the terms of the MIT License; see LICENSE file for more details.

"""Create cesnet openid remote tables."""
import sqlalchemy_utils
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '0f27e899fc55'
down_revision = '7b18e6f52083'
branch_labels = ()
depends_on = None


def upgrade():
    """Upgrade database."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('cesnet_group',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('uuid', sqlalchemy_utils.types.uuid.UUIDType(), nullable=False),
    sa.Column('display_name', sa.String(length=255), nullable=False),
    sa.Column('uri', sa.String(length=1024), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_cesnet_group')),
    sa.UniqueConstraint('uri', name=op.f('uq_cesnet_group_uri'))
    )
    op.create_index(op.f('ix_cesnet_group_uuid'), 'cesnet_group', ['uuid'], unique=True)
    op.create_table('cesnet_group_roles',
    sa.Column('group_id', sa.Integer(), nullable=True),
    sa.Column('role_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['group_id'], ['cesnet_group.id'], name='fk_cesnet_group_roles_group_id'),
    sa.ForeignKeyConstraint(['role_id'], ['accounts_role.id'], name='fk_cesnet_group_roles_role_id')
    )
    # ### end Alembic commands ###


def downgrade():
    """Downgrade database."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('cesnet_group_roles')
    op.drop_index(op.f('ix_cesnet_group_uuid'), table_name='cesnet_group')
    op.drop_table('cesnet_group')
    # ### end Alembic commands ###
