#include "iarduino_I2C_pH.h"																									//
																																//
//		Инициализация модуля:																									//	Возвращаемое значение: результат инициализации.
bool	iarduino_I2C_pH::begin				(void){																				//	Параметр: отсутствует
		//	Инициируем работу с шиной I2C:																						//
			objI2C->begin(100);																									//	Инициируем передачу данных по шине I2C на скорости 100 кГц.
		//	Если адрес не указан, то ищим модуль на шине I2C:																	//
			if(valAddrTemp==0){																									//
				for(int i=1; i<127; i++){																						//	Проходим по всем адресам на шине I2C
					if( objI2C->checkAddress(i)											){	valAddr=i; delay(2);				//	Если на шине I2C есть устройство с адресом i, то используем этот адрес для проверки найденного модуля...
					if(_readBytes(REG_MODEL,4)											){										//	Читаем 4 байта начиная с регистра «REG_MODEL» в массив «data».
					if( data[0]     == DEF_MODEL_PH										){										//	Если у модуля с адресом i в регистре «MODEL»   (data[0]) хранится значение DEF_MODEL_PH, то ...
					if((data[2]>>1) == i                 || data[2] == 0xFF				){										//	Если у модуля с адресом i в регистре «ADDRESS» (data[2]) хранится значение i (адрес+младший бит) или 0xFF (адрес не задавался), то ...
					if( data[3]     == DEF_CHIP_ID_FLASH || data[3] == DEF_CHIP_ID_METRO){										//	Если у модуля с адресом i в регистре «CHIP_ID» (data[3]) хранится значение DEF_CHIP_ID_FLASH (идентификатор модулей Flash), или DEF_CHIP_ID_METRO (идентификатор модулей Metro), то ...
						valAddrTemp=i; i=128;																					//	Считаем что модуль обнаружен, сохраняем значение i как найденный адрес и выходим из цикла.
					}}}}}																										//
				}																												//
			}																													//
		//	Если модуль не найден, то возвращаем ошибку инициализации:															//
			if( valAddrTemp == 0														){	valAddr=0; return false;}			//
		//	Проверяем наличие модуля на шине I2C:																				//
			if( objI2C->checkAddress(valAddrTemp) == false								){	valAddr=0; return false;}			//	Если на шине I2C нет устройств с адресом valAddrTemp, то возвращаем ошибку инициализации
			valAddr=valAddrTemp;																								//	Сохраняем адрес модуля на шине I2C.
			delay(5);																											//
		//	Проверяем значения регистров модуля:																				//
			if(_readBytes(REG_MODEL,4)==false											){	valAddr=0; return false;}			//	Если не удалось прочитать 4 байта в массив «data» из модуля начиная с регистра «REG_MODEL», то возвращаем ошибку инициализации.
			if( data[0]     != DEF_MODEL_PH												){	valAddr=0; return false;}			//	Если значение  регистра «MODEL»   (data[0]) не совпадает со значением DEF_MODEL_PH, то возвращаем ошибку инициализации.
			if((data[2]>>1) != valAddrTemp       && data[2] !=0xFF						){	valAddr=0; return false;}			//	Если значение  регистра «ADDRESS» (data[2]) не совпадает с адресом модуля и не совпадает со значением 0xFF, то возвращаем ошибку инициализации.
			if( data[3]     != DEF_CHIP_ID_FLASH && data[3] != DEF_CHIP_ID_METRO		){	valAddr=0; return false;}			//	Если значение  регистра «CHIP_ID» (data[3]) не совпадает со значением DEF_CHIP_ID_FLASH и DEF_CHIP_ID_METRO, то возвращаем ошибку инициализации.
			valVers=data[1];																									//	Сохраняем байт регистра «VERSION» (data[1]) в переменую «valVers».
		//	Перезагружаем модуль устанавливая его регистры в значение по умолчанию:												//
			reset();																											//	Выполняем программную перезагрузку.
			delay(5);																											//
			return true;																										//	Возвращаем флаг успешной инициализаии.
}																																//
																																//
//		Перезагрузка модуля:																									//	Возвращаемое значение:	результат перезагрузки.
bool	iarduino_I2C_pH::reset				(void){																				//	Параметр:				отсутствует.
			if(valAddr){																										//	Если модуль был инициализирован, то ...
			//	Устанавливаем бит перезагрузки:																					//
				if(_readBytes(REG_BITS_0,1)==false){return false;}																//	Читаем 1 байт регистра «BITS_0» в массив «data».
				data[0] |= 0b10000000;																							//	Устанавливаем бит «SET_RESET»
				if(_writeBytes(REG_BITS_0,1)==false){return false;}																//	Записываем 1 байт в регистр «BITS_0» из массива «data».
			//	Ждём установки флага завершения перезагрузки:																	//
				do{ if(_readBytes(REG_FLAGS_0,1)==false){return false;} }														//	Читаем 1 байт регистра «REG_FLAGS_0» в массив «data».
				while( (data[0]&0b10000000) == 0);																				//	Повторяем чтение пока не установится флаг «FLG_RESET».
				return true;																									//
			}else{																												//	Иначе, если модуль не инициализирован, то ...
				return false;																									//	Возвращаем ошибку.
			}																													//
}																																//
																																//
//		Смена адреса модуля:																									//	Возвращаемое значение:	резульат смены адреса.
bool	iarduino_I2C_pH::changeAddress		(uint8_t newAddr){																	//	Параметр:				newAddr - новый адрес модуля (0x07 < адрес < 0x7F).
			if(valAddr){																										//	Если модуль был инициализирован, то ...
			//	Проверяем новый адрес:																							//
				if(newAddr>0x7F){newAddr>>=1;}																					//	Корректируем адрес, если он указан с учётом бита RW.
				if(newAddr==0x00 || newAddr==0x7F){return false;}																//	Запрещаем устанавливать адрес 0x00 и 0x7F.
			//	Записываем новый адрес:																							//
				if(_readBytes(REG_BITS_0,1)==false){return false;}																//	Читаем 1 байт регистра «BITS_0» в массив «data».
				data[0] |= 0b00000010;																							//	Устанавливаем бит «SAVE_ADR_EN»
				if(_writeBytes(REG_BITS_0,1)==false){return false;}																//	Записываем 1 байт в регистр «BITS_0» из массива «data».
				data[0] = (newAddr<<1)|0x01;																					//	Готовим новый адрес к записи в модуль, установив бит «SAVE_FLASH».
				if(_writeBytes(REG_ADDRESS,1)==false){return false;}															//	Записываем 1 байт в регистр «ADDRESS» из массива «data».
				delay(200);																										//	Даём более чем достаточное время для применения модулем нового адреса.
			//	Проверяем наличие модуля с новым адресом на шине I2C:															//
				if(objI2C->checkAddress(newAddr)==false){return false;}															//	Если на шине I2C нет модуля с адресом newAddr, то возвращаем ошибку.
				valAddr     = newAddr;																							//	Сохраняем новый адрес как текущий.
				valAddrTemp = newAddr;																							//	Сохраняем новый адрес как указанный.
				return true;																									//	Возвращаем флаг успеха.
			}else{																												//	Иначе, если модуль не инициализирован, то ...
				return false;																									//	Возвращаем ошибку.
			}																													//
}																																//
																																//
//		Получение флага наличия подтяжки линий шины I2C:																		//	Возвращаемое значение:	флаг наличия подтяжки линий шины I2C.
bool	iarduino_I2C_pH::getPullI2C		(void){																				//	Параметр:				отсутствует.
			if(valAddr){																										//	Если модуль был инициализирован, то ...
			//	Считываем первые два регистра: регистр флагов и регистр битов:													//
				if(_readBytes(REG_FLAGS_0,2)==false ){ return false; }															//	Читаем 2 байта начиная с регистра «REG_FLAGS_0» в массив «data».
			//	Проверяем поддерживает ли модуль управление подтяжкой линий шины I2C:											//
				if( (data[0] & 0b00000100) == false ){ return false; }															//	Если флаг «FLG_I2C_UP» регистра «REG_FLAGS_0» сброшен, значит модуль не поддерживает управление подтяжкой линий шины I2C.
			//	Проверяем установлена ли подтяжка линий шины I2C:																//
				if( (data[1] & 0b00000100) == false ){ return false; }															//	Если бит  «SET_I2C_UP» регистра «REG_BITS_0»  сброшен, значит подтяжка линий шины I2C не установлена.
				return true;																									//	Возвращаем флаг успеха.
			}else{																												//	Иначе, если модуль не инициализирован, то ...
				return false;																									//	Возвращаем ошибку.
			}																													//
}																																//
																																//
//		Установка подтяжки линий шины I2C:																						//	Возвращаемое значение:	результат установки подтяжки линий шины I2C.
bool	iarduino_I2C_pH::setPullI2C		(bool f){																			//	Параметр:				флаг подтяжки линий шины I2C.
			if(valAddr){																										//	Если модуль был инициализирован, то ...
			//	Считываем первые два регистра: регистр флагов и регистр битов:													//
				if(_readBytes(REG_FLAGS_0,2)==false ){ return false; }															//	Читаем 2 байта начиная с регистра «REG_FLAGS_0» в массив «data».
			//	Проверяем поддерживает ли модуль управление подтяжкой линий шины I2C:											//
				if( (data[0] & 0b00000100) == false ){ return false; }															//	Если флаг «FLG_I2C_UP» регистра «REG_FLAGS_0» сброшен, значит модуль не поддерживает управление подтяжкой линий шины I2C.
			//	Устанавливаем или сбрасываем бит включения подтяжки линий шины I2C:												//
				if(f){ data[0] = (data[1] |  0b00000100); }																		//	Если флаг «f» установлен, то копируем значение из 1 в 0 элемент массива «data» установив бит «SET_I2C_UP».
				else { data[0] = (data[1] & ~0b00000100); }																		//	Если флаг «f» сброшен   , то копируем значение из 1 в 0 элемент массива «data» сбросив   бит «SET_I2C_UP».
			//	Сохраняем получившееся значение в регистр «REG_BITS_0»:															//
				if(_writeBytes(REG_BITS_0,1)==false ){ return false; }															//	Записываем 1 байт в регистр «REG_BITS_0» из массива «data».
				return true;																									//	Возвращаем флаг успеха.
			}else{																												//	Иначе, если модуль не инициализирован, то ...
				return false;																									//	Возвращаем ошибку.
			}																													//
}																																//
																																//
//		Запуск калибровки модуля:																								//	Возвращаемое значение:	результат запуска калибровки.
bool	iarduino_I2C_pH::setCalibration	(uint8_t num, float pH){																//	Параметры:				num - стадия калибровки (1 или 2), pH - водородный показатель от 0 до 14,000.
			if(valAddr){																										//	Если модуль был инициализирован, то ...
			//	Проверяем полученные данные:																					//
				if( (num<1) || (num>2    ) ){ return false; }																	//	Параметр «num» определяет стадию калибровки и может принимать значения 1 или 2.
				if( (pH <0) || (pH >14.0f) ){ return false; }																	//	Параметр «pH» определяет водородный показатель и может принимать значения от 0 до 14,000.
			//	Готовим данные для записи:																						//
				data[0] =  (uint16_t)(pH*1000.0f)     & 0x00FF;																	//	Устанавливаем младший байт значения «pH» для регистра «REG_PH_KNOWN_PH».
				data[1] = ((uint16_t)(pH*1000.0f)>>8) & 0x00FF;																	//	Устанавливаем старший байт значения «pH» для регистра «REG_PH_KNOWN_PH».
			//	Отправляем подготовленные данные в модуль:																		//
				if(_writeBytes(REG_PH_KNOWN_PH, 2)==false ){ return false; }													//	Записываем 2 байта из массива «data» в регистр «REG_PH_KNOWN_PH».
			//	Готовим данные для записи:																						//
				data[0] = num==1? PH_BIT_CALC_1:PH_BIT_CALC_2;																	//	Устанавливаем бит запуска 1 или 2 стадии калибровки.
			//	Отправляем подготовленные данные в модуль:																		//
				if(_writeBytes(REG_PH_CALIBRATION, 1)==false ){ return false; }													//	Записываем 1 байт из массива «data» в регистр «REG_PH_CALIBRATION».
				return true;																									//	Возвращаем флаг успеха.
			}else{																												//	Иначе, если модуль не инициализирован, то ...
				return false;																									//	Возвращаем ошибку.
			}																													//
}																																//
																																//
//		Получение текущей стадии калибровки модуля:																				//	Возвращаемое значение:	стадия калибровки (0-нет, 1, 2)
uint8_t	iarduino_I2C_pH::getCalibration	(void){																					//	Параметр:				отсутствует.
			if(valAddr){																										//	Если модуль был инициализирован, то ...
			//	Читаем данные из модуля:																						//
				_readBytes(REG_PH_CALIBRATION, 1);																				//	Читаем 1 байт из регистра «REG_TDS_CALIBRATION» в массив «data».
			//	Возвращаем результат:																							//
				if(data[0]&PH_FLG_STATUS_1){return 1;}																			//	Выполняется 1 стадия калибровки.
				if(data[0]&PH_FLG_STATUS_2){return 2;}																			//	Выполняется 2 стадия калибровки.
			}																													//
			return 0;																											//	Калибровка не выполняется.
}																																//
																																//
//		Получение водородного показателя жидкости требуемого для калибровки модуля с кнопки:									//	Возвращаемое значение:	водородный показатель калибровочной жидкости.
float	iarduino_I2C_pH::getKnownPH		(uint8_t num){																			//	Параметр:				стадия калибровки (1 или 2).
			if(valAddr){																										//	Если модуль был инициализирован, то ...
			//	Проверяем полученные данные:																					//
				if( (num<1) || (num>2) ){ return 0; }																			//	Параметр «num» определяет стадию калибровки и может принимать значения 1 или 2.
			//	Читаем данные из модуля:																						//
				_readBytes(num==1? REG_PH_KNOWN_PH_1:REG_PH_KNOWN_PH_2, 2);														//	Читаем 2 байта из регистров «REG_PH_KNOWN_PH_1» или «REG_PH_KNOWN_PH_2» в массив «data».
			//	Возвращаем результат:																							//
				return (float)( ((uint16_t)data[1]<<8) | data[0] )/1000.0f;														//	Возвращаем результат, преобразовав значение из тысячных долей pH.
			}																													//
			return 0;																											//	Возвращаем ошибку.
}																																//
																																//
//		Установка водородного показателя жидкости требуемого для калибровки модуля с кнопки:									//	Возвращаемое значение:	результат установки.
bool	iarduino_I2C_pH::setKnownPH		(uint8_t num, float pH){																//	Параметры:				num - стадия калибровки (1 или 2), pH - водородный показатель от 0 до 14,000.
			if(valAddr){																										//	Если модуль был инициализирован, то ...
			//	Проверяем полученные данные:																					//
				if( (num<1) || (num>2    ) ){ return false; }																	//	Параметр «num» определяет стадию калибровки и может принимать значения 1 или 2.
				if( (pH <0) || (pH >14.0f) ){ return false; }																	//	Параметр «pH» определяет водородный показатель и может принимать значения от 0 до 14,000.
			//	Готовим данные для записи:																						//
				data[0] =  (uint16_t)(pH*1000.0f)     & 0x00FF;																	//	Устанавливаем младший байт значения «pH».
				data[1] = ((uint16_t)(pH*1000.0f)>>8) & 0x00FF;																	//	Устанавливаем старший байт значения «pH».
			//	Отправляем подготовленные данные в модуль:																		//
				if(_writeBytes(num==1? REG_PH_KNOWN_PH_1:REG_PH_KNOWN_PH_2, 2)==false ){ return false; }						//	Записываем 2 байта из массива «data» в регистр «REG_PH_KNOWN_PH_1» или «REG_PH_KNOWN_PH_2».
				delay(50);																										//	Даём время для сохранения данных в энергонезависимую память модуля.
				return true;																									//	Возвращаем флаг успеха.
			}else{																												//	Иначе, если модуль не инициализирован, то ...
				return false;																									//	Возвращаем ошибку.
			}																													//
}																																//
																																//
//		Получение коэффициента усиления усилителя:																				//	Возвращаемое значение:	коэффициент усиления от 1 до 65,535.
float	iarduino_I2C_pH::getKy			(void){																					//	Параметр:				отсутствует.
			if(valAddr){																										//	Если модуль был инициализирован, то ...
			//	Читаем данные из модуля:																						//
				_readBytes(REG_PH_Ky, 2);																						//	Читаем 2 байта из регистра «REG_PH_Ky» в массив «data».
			//	Возвращаем результат:																							//
				return (float)( ((uint16_t)data[1]<<8) | data[0] )/1000.0f;														//	Возвращаем результат, преобразовав значение из тысячных долей.
			}																													//
			return 0;																											//	Возвращаем ошибку.
}																																//
																																//
//		Установка коэффициента усиления усилителя:																				//	Возвращаемое значение:	результат установки.
bool	iarduino_I2C_pH::setKy			(float Ky){																				//	Параметр:				коэффициент усиления от 1 до 65,535.
			if(valAddr){																										//	Если модуль был инициализирован, то ...
			//	Проверяем полученные данные:																					//
				if( (Ky<1.0f) || (Ky>65.535f) ){ return false; }																//	Параметр «Ky» определяет коэффициент усиления и может принимать значения от 1 до 65,535.
			//	Готовим данные для записи:																						//
				data[0] =  (uint16_t)(Ky*1000.0f)     & 0x00FF;																	//	Устанавливаем младший байт значения «Ky».
				data[1] = ((uint16_t)(Ky*1000.0f)>>8) & 0x00FF;																	//	Устанавливаем старший байт значения «Ky».
			//	Отправляем подготовленные данные в модуль:																		//
				if(_writeBytes(REG_PH_Ky, 2)==false ){ return false; }															//	Записываем 2 байта из массива «data» в регистр «REG_PH_Ky».
				delay(50);																										//	Даём время для сохранения данных в энергонезависимую память модуля.
				return true;																									//	Возвращаем флаг успеха.
			}else{																												//	Иначе, если модуль не инициализирован, то ...
				return false;																									//	Возвращаем ошибку.
			}																													//
}																																//
																																//
//		Получение шага смещения напряжения датчика при смещении pH на 1:														//	Возвращаемое значение:	шаг смещения напряжения датчика от 0,01 мВ до 655,35 мВ.
float	iarduino_I2C_pH::getVstp		(void){																					//	Параметр:				отсутствует.
			if(valAddr){																										//	Если модуль был инициализирован, то ...
			//	Читаем данные из модуля:																						//
				_readBytes(REG_PH_Ustp, 2);																						//	Читаем 2 байта из регистра «REG_PH_Ustp» в массив «data».
			//	Возвращаем результат:																							//
				return (float)( ((uint16_t)data[1]<<8) | data[0] )/100.0f;														//	Возвращаем результат, преобразовав значение из сотых долей мВ.
			}																													//
			return 0;																											//	Возвращаем ошибку.
}																																//
																																//
//		Установка шага смещения напряжения датчика при смещении pH на 1:														//	Возвращаемое значение:	результат установки.
bool	iarduino_I2C_pH::setVstp		(float Vstp){																			//	Параметр:				шаг смещения напряжения датчика от 0,01 мВ до 655,35 мВ.
			if(valAddr){																										//	Если модуль был инициализирован, то ...
			//	Проверяем полученные данные:																					//
				if( (Vstp<0.01f) || (Vstp>655.35f) ){ return false; }															//	Параметр «Vstp» определяет шага смещения напряжения датчика и может принимать значения от 0,01 мВ до 655,35 мВ.
			//	Готовим данные для записи:																						//
				data[0] =  (uint16_t)(Vstp*100.0f)     & 0x00FF;																//	Устанавливаем младший байт значения «Vstp».
				data[1] = ((uint16_t)(Vstp*100.0f)>>8) & 0x00FF;																//	Устанавливаем старший байт значения «Vstp».
			//	Отправляем подготовленные данные в модуль:																		//
				if(_writeBytes(REG_PH_Ustp, 2)==false ){ return false; }														//	Записываем 2 байта из массива «data» в регистр «REG_PH_Ustp».
				delay(50);																										//	Даём время для сохранения данных в энергонезависимую память модуля.
				return true;																									//	Возвращаем флаг успеха.
			}else{																												//	Иначе, если модуль не инициализирован, то ...
				return false;																									//	Возвращаем ошибку.
			}																													//
}																																//
																																//
//		Получение напряжения на входе датчика:																					//	Возвращаемое значение:	напряжение на входе датчика от 0 до 6,5535 В.
float	iarduino_I2C_pH::getVin			(void){																					//
			if(valAddr){																										//	Если модуль был инициализирован, то ...
			//	Читаем данные из модуля:																						//
				_readBytes(REG_PH_Uin, 2);																						//	Читаем 2 байта из регистра «REG_PH_Uin» в массив «data».
			//	Возвращаем результат:																							//
				return (float)( ((uint16_t)data[1]<<8) | data[0] )/10000.0f;													//	Возвращаем результат, преобразовав значение из десятитысячных долей В.
			}																													//
			return 0;																											//	Возвращаем ошибку.
}																																//
																																//
//		Получение напряжения на выходе усилителя:																				//	Возвращаемое значение:	напряжение на выходе усилителя от 0 до 6,5535 В.
float	iarduino_I2C_pH::getVout		(void){																					//	Параметр:				отсутствует.
			if(valAddr){																										//	Если модуль был инициализирован, то ...
			//	Читаем данные из модуля:																						//
				_readBytes(REG_PH_Uout, 2);																						//	Читаем 2 байта из регистра «REG_PH_Uout» в массив «data».
			//	Возвращаем результат:																							//
				return (float)( ((uint16_t)data[1]<<8) | data[0] )/10000.0f;													//	Возвращаем результат, преобразовав значение из десятитысячных долей В.
			}																													//
			return 0;																											//	Возвращаем ошибку.
}																																//
																																//
//		Получение нейтрального напряжения на выходе усилителя:																	//	Возвращаемое значение:	нейтральное напряжение на выходе усилителя от 0 до 6,5535 В.
float	iarduino_I2C_pH::getVn			(void){																					//	Параметр:				отсутствует.
			if(valAddr){																										//	Если модуль был инициализирован, то ...
			//	Читаем данные из модуля:																						//
				_readBytes(REG_PH_Un, 2);																						//	Читаем 2 байта из регистра «REG_PH_Un» в массив «data».
			//	Возвращаем результат:																							//
				return (float)( ((uint16_t)data[1]<<8) | data[0] )/10000.0f;													//	Возвращаем результат, преобразовав значение из десятитысячных долей В.
			}																													//
			return 0;																											//	Возвращаем ошибку.
}																																//
																																//
//		Получение нейтрального pH для датчика:																					//	Возвращаемое значение:	нейтральный pH для датчика от 0 до 14,000.
float	iarduino_I2C_pH::getPHn			(void){																					//	Параметр:				отсутствует.
			if(valAddr){																										//	Если модуль был инициализирован, то ...
			//	Читаем данные из модуля:																						//
				_readBytes(REG_PH_pHn, 2);																						//	Читаем 2 байта из регистра «REG_PH_pHn» в массив «data».
			//	Возвращаем результат:																							//
				return (float)( ((uint16_t)data[1]<<8) | data[0] )/1000.0f;														//	Возвращаем результат, преобразовав значение из тысячных долей.
			}																													//
			return 0;																											//	Возвращаем ошибку.
}																																//
																																//
//		Установка коэффициента усиления усилителя:																				//	Возвращаемое значение:	результат установки.
bool	iarduino_I2C_pH::setPHn			(float PHn){																			//	Параметр:				нейтральный pH для датчика от 0 до 14,000.
			if(valAddr){																										//	Если модуль был инициализирован, то ...
			//	Проверяем полученные данные:																					//
				if( (PHn<0) || (PHn>14.0f) ){ return false; }																	//	Параметр «PHn» определяет нейтральный pH для датчика и может принимать значения от 0 до 14,000.
			//	Готовим данные для записи:																						//
				data[0] =  (uint16_t)(PHn*1000.0f)     & 0x00FF;																//	Устанавливаем младший байт значения «Ky».
				data[1] = ((uint16_t)(PHn*1000.0f)>>8) & 0x00FF;																//	Устанавливаем старший байт значения «Ky».
			//	Отправляем подготовленные данные в модуль:																		//
				if(_writeBytes(REG_PH_pHn, 2)==false ){ return false; }															//	Записываем 2 байта из массива «data» в регистр «REG_PH_pHn».
				delay(50);																										//	Даём время для сохранения данных в энергонезависимую память модуля.
				return true;																									//	Возвращаем флаг успеха.
			}else{																												//	Иначе, если модуль не инициализирован, то ...
				return false;																									//	Возвращаем ошибку.
			}																													//
}																																//
																																//
//		Получение водородного показателя pH жидкости:																			//	Возвращаемое значение:	водородный показатель жидкости от 0 до 14,000 pH.
float	iarduino_I2C_pH::getPH			(void){																					//	Параметр:				отсутствует.
			if(valAddr){																										//	Если модуль был инициализирован, то ...
			//	Читаем данные из модуля:																						//
				_readBytes(REG_PH_pH, 2);																						//	Читаем 2 байта из регистра «REG_PH_pH» в массив «data».
			//	Возвращаем результат:																							//
				return (float)( ((uint16_t)data[1]<<8) | data[0] )/1000.0f;														//	Возвращаем результат, преобразовав значение из тысячных долей.
			}																													//
			return 0;																											//	Возвращаем ошибку.
}																																//
																																//
//		Чтение данных из регистров в массив data:																				//	Возвращаемое значение:	результат чтения (true/false).
bool	iarduino_I2C_pH::_readBytes		(uint8_t reg, uint8_t sum){															//	Параметры:				reg - номер первого регистра, sum - количество читаемых байт.
			bool	result=false;																								//	Определяем флаг       для хранения результата чтения.
			uint8_t	sumtry=10;																									//	Определяем переменную для подсчёта количества оставшихся попыток чтения.
			do{	result = objI2C->readBytes(valAddr, reg, data, sum);															//	Считываем из модуля valAddr, начиная с регистра reg, в массив data, sum байт.
				sumtry--;	if(!result){delay(1);}																				//	Уменьшаем количество попыток чтения и устанавливаем задержку при неудаче.
			}	while		(!result && sumtry>0);																				//	Повторяем чтение если оно завершилось неудачей, но не более sumtry попыток.
			delayMicroseconds(500);																								//	Между пакетами необходимо выдерживать паузу.
			return result;																										//	Возвращаем результат чтения (true/false).
}																																//
																																//
//		Запись данных в регистры из массива data:																				//	Возвращаемое значение:	результат записи (true/false).
bool	iarduino_I2C_pH::_writeBytes	(uint8_t reg, uint8_t sum, uint8_t num){											//	Параметры:				reg - номер первого регистра, sum - количество записываемых байт, num - номер первого элемента массива data.
			bool	result=false;																								//	Определяем флаг       для хранения результата записи.
			uint8_t	sumtry=10;																									//	Определяем переменную для подсчёта количества оставшихся попыток записи.
			do{	result = objI2C->writeBytes(valAddr, reg, &data[num], sum);														//	Записываем в модуль valAddr начиная с регистра reg, sum байи из массива data начиная с элемента num.
				sumtry--;	if(!result){delay(1);}																				//	Уменьшаем количество попыток записи и устанавливаем задержку при неудаче.
			}	while		(!result && sumtry>0);																				//	Повторяем запись если она завершилась неудачей, но не более sumtry попыток.
			delay(10);																											//	Ждём применения модулем записанных данных.
			return result;																										//	Возвращаем результат записи (true/false).
}																																//
																																//
