# ПРИМЕР ПОЛУЧЕНИЯ НАСТРОЕК МОДУЛЯ:              # * Строки со звёздочкой являются необязательными.

#   Подключаем библиотеку   для работы с pH-метром I2C-flash.
from pyiArduinoI2Cph import *

#   Объявляем объект sensor для работы с функциями и методами библиотеки pyiArduinoI2Cph, указывая адрес модуля на шине I2C.
sensor = pyiArduinoI2Cph(0x09)

print("pH1  = "            , end='')        #
print(sensor.getKnownPH(1) , end='')        #   Выводим требуемый водородный показатель 1 жидкости для калибровки модуля кнопкой от 0 до 14,000 pH.
print("pH.\r\npH2  = "     , end='')        #
print(sensor.getKnownPH(2) , end='')        #   Выводим требуемый водородный показатель 2 жидкости для калибровки модуля кнопкой от 0 до 14,000 pH.
print("pH.\r\nKy   = "     , end='')        #
print(sensor.getKy()       , end='')        #   Выводим коэффициент усиления операционного усилителя от 1 до 65,535.
print("\r\nVstp = "        , end='')        #
print(sensor.getVstp()     , end='')        #   Выводим шаг смещения напряжения датчика от 0,01 мВ до 655,35 мВ при смещении кислотности на 1 pH.
print("мВ.\r\npHn  = "     , end='')        #
print(sensor.getPHn()      , end='')        #   Выводим нейтральную кислотность для датчика от 0 до 14,000 pH.
print("pH.\r\n"            , end='')        #
